/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyWaiter;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ReplyTracker {
    private Map waiters = Collections.synchronizedMap(new LinkedHashMap());
    private long timeout = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Long addWaiter(ReplyWaiter replyWaiter) {
        Long l = new Long(UniqueID.generateID(UID.getPrefix()));
        this.waiters.put(l, replyWaiter);
        return l;
    }

    public void addWaiter(Long l, ReplyWaiter replyWaiter) {
        this.waiters.put(l, replyWaiter);
    }

    public void removeWaiter(Long l) {
        this.waiters.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyStatus waitForReply(Long l, long l2) throws BrokerException {
        ReplyWaiter replyWaiter = (ReplyWaiter)this.waiters.get(l);
        if (!$assertionsDisabled && replyWaiter == null) {
            throw new AssertionError();
        }
        try {
            ReplyStatus replyStatus = replyWaiter.waitForReply(l2);
            return replyStatus;
        }
        finally {
            this.waiters.remove(l);
        }
    }

    public boolean notifyReply(Long l, BrokerAddress brokerAddress, GPacket gPacket) {
        ReplyWaiter replyWaiter = (ReplyWaiter)this.waiters.get(l);
        if (replyWaiter == null) {
            return false;
        }
        replyWaiter.notifyReply(brokerAddress, gPacket);
        return true;
    }

    public void abortWaiter(Long l) {
        ReplyWaiter replyWaiter = (ReplyWaiter)this.waiters.get(l);
        if (replyWaiter == null) {
            return;
        }
        replyWaiter.abort();
    }

    public void addBroker(BrokerAddress brokerAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroker(BrokerAddress brokerAddress, boolean bl, boolean bl2) {
        Long l = null;
        ReplyWaiter replyWaiter = null;
        Set set = this.waiters.keySet();
        Map map = this.waiters;
        synchronized (map) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                l = (Long)iterator.next();
                replyWaiter = (ReplyWaiter)this.waiters.get(l);
                replyWaiter.removeParticipant(brokerAddress, bl, bl2);
            }
        }
    }

    static {
        $assertionsDisabled = !ReplyTracker.class.desiredAssertionStatus();
    }
}

