/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import java.io.IOException;

public class KeystoreUtil {
    public static final String KEYSTORE_DIR_PROP = "imq.keystore.file.dirpath";
    public static final String KEYSTORE_FILE_PROP = "imq.keystore.file.name";
    public static final String KEYSTORE_PASSWORD_PROP = "imq.keystore.password";
    private static String keystore_location = null;
    private static String pass_phrase = null;
    protected static BrokerResources br = Globals.getBrokerResources();

    public static void clear() {
        keystore_location = null;
        Object var0 = null;
    }

    public static String getKeystoreLocation() throws IOException {
        if (keystore_location == null) {
            BrokerConfig brokerConfig = Globals.getConfig();
            String string = System.getProperty("file.separator");
            String string2 = brokerConfig.getProperty(KEYSTORE_DIR_PROP);
            String string3 = string2 != null ? (string2 = StringUtil.expandVariables(string2, brokerConfig)) : brokerConfig.getProperty("imq.varhome") + string + "security";
            keystore_location = string3 + string + brokerConfig.getProperty(KEYSTORE_FILE_PROP);
        }
        return keystore_location;
    }

    public static String getKeystorePassword() throws IOException {
        if (pass_phrase == null) {
            Password password = null;
            BrokerConfig brokerConfig = Globals.getConfig();
            pass_phrase = brokerConfig.getProperty(KEYSTORE_PASSWORD_PROP);
            password = new Password();
            for (int i = 0; (pass_phrase == null || pass_phrase.equals("")) && i <= 5; ++i) {
                System.err.print(br.getString("B0004", KeystoreUtil.getKeystoreLocation()));
                System.err.flush();
                if (Broker.getBroker().background) {
                    System.err.print("\n");
                    break;
                }
                pass_phrase = password.getPassword();
            }
        }
        return pass_phrase;
    }
}

