/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.util.timer.JMQTimerTask;

class TaskQueue {
    private JMQTimerTask[] queue = new JMQTimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    void add(JMQTimerTask jMQTimerTask) {
        if (++this.size == this.queue.length) {
            JMQTimerTask[] jMQTimerTaskArray = new JMQTimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, jMQTimerTaskArray, 0, this.size);
            this.queue = jMQTimerTaskArray;
        }
        this.queue[this.size] = jMQTimerTask;
        this.fixUp(this.size);
    }

    JMQTimerTask getMin() {
        return this.queue[1];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void rescheduleMin(long l) {
        this.queue[1].nextExecutionTime = l;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    private void fixUp(int n) {
        while (n > 1) {
            int n2 = n >> 1;
            if (this.queue[n2].nextExecutionTime <= this.queue[n].nextExecutionTime) break;
            JMQTimerTask jMQTimerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = jMQTimerTask;
            n = n2;
        }
    }

    private void fixDown(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.queue[n2].nextExecutionTime > this.queue[n2 + 1].nextExecutionTime) {
                ++n2;
            }
            if (this.queue[n].nextExecutionTime <= this.queue[n2].nextExecutionTime) break;
            JMQTimerTask jMQTimerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = jMQTimerTask;
            n = n2;
        }
    }
}

