/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Iterator;

public class CompositeList
extends CollectionList {
    public CompositeList() {
        super(new BasicEventList(), GlazedLists.listCollectionListModel());
    }

    public CompositeList(ReadWriteLock lock) {
        super(new BasicEventList(lock), GlazedLists.listCollectionListModel());
    }

    public CompositeList(ListEventPublisher publisher, ReadWriteLock lock) {
        super(new BasicEventList(publisher, lock), GlazedLists.listCollectionListModel());
    }

    public void addMemberList(EventList list) {
        if (!this.getPublisher().equals(list.getPublisher())) {
            throw new IllegalArgumentException("Member list must share publisher with CompositeList");
        }
        if (!this.getReadWriteLock().equals(list.getReadWriteLock())) {
            throw new IllegalArgumentException("Member list must share lock with CompositeList");
        }
        this.source.add(list);
    }

    public EventList createMemberList() {
        return new BasicEventList(this.getPublisher(), this.getReadWriteLock());
    }

    public void removeMemberList(EventList list) {
        Iterator i = this.source.iterator();
        while (i.hasNext()) {
            if (i.next() != list) continue;
            i.remove();
            return;
        }
        throw new IllegalArgumentException("Cannot remove list " + list + " which is not in this CompositeList");
    }
}

