/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.nio;

import ca.odell.glazedlists.impl.nio.NIOAttachment;
import ca.odell.glazedlists.impl.nio.NIODaemon;
import ca.odell.glazedlists.impl.nio.ServerShutdownException;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.logging.Logger;

class Shutdown
implements Runnable {
    private static Logger logger = Logger.getLogger(Shutdown.class.toString());
    private NIODaemon nioDaemon = null;

    public Shutdown(NIODaemon nioDaemon) {
        this.nioDaemon = nioDaemon;
    }

    public void run() {
        logger.info("Cleaning up listening socket and closing " + (this.nioDaemon.getSelector().keys().size() - 1) + " connections");
        Iterator<SelectionKey> k = this.nioDaemon.getSelector().keys().iterator();
        while (k.hasNext()) {
            NIOAttachment attachment;
            SelectionKey key = k.next();
            if (!key.isValid()) {
                attachment = (NIOAttachment)key.attachment();
                attachment.close(new IOException("Connection closed"));
                continue;
            }
            if ((key.interestOps() & 0x10) != 0) {
                try {
                    ServerSocketChannel server = (ServerSocketChannel)key.channel();
                    server.close();
                    key.cancel();
                }
                catch (IOException e) {
                    logger.warning("Error closing server socket, " + e.getMessage());
                }
                continue;
            }
            attachment = (NIOAttachment)key.attachment();
            attachment.close(new ServerShutdownException());
        }
    }
}

