/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class ComparatorChain
implements Comparator {
    private final Comparator[] comparators;

    public ComparatorChain(List comparators) {
        this.comparators = comparators.toArray(new Comparator[comparators.size()]);
    }

    public int compare(Object alpha, Object beta) {
        for (int i = 0; i < this.comparators.length; ++i) {
            int compareResult = this.comparators[i].compare(alpha, beta);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }

    public Comparator[] getComparators() {
        return this.comparators;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ComparatorChain)) {
            return false;
        }
        ComparatorChain chainOther = (ComparatorChain)other;
        return Arrays.equals(this.comparators, chainOther.comparators);
    }
}

