/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar.ui.basic;

import com.michaelbaranov.microba.calendar.HolidayPolicy;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

class CalendarHeader
extends JPanel {
    private Locale locale;
    private TimeZone zone;
    private Date date;
    private Color backgroundColorActive = UIManager.getColor("activeCaption");
    private Color backgroundColorInactive = UIManager.getColor("inactiveCaption");
    private HolidayPolicy holidayPolicy;

    public CalendarHeader(Date date, Locale locale, TimeZone zone, HolidayPolicy holidayPolicy) {
        this.locale = locale;
        this.zone = zone;
        this.date = date;
        this.holidayPolicy = holidayPolicy;
        this.reflectData();
    }

    private void reflectData() {
        Calendar cal = Calendar.getInstance(this.zone, this.locale);
        cal.setTime(this.date == null ? new Date() : this.date);
        SimpleDateFormat fmt = new SimpleDateFormat("E", this.locale);
        fmt.setTimeZone(this.zone);
        int numDaysInWeek = cal.getActualMaximum(7) - cal.getActualMinimum(7) + 1;
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        cal.set(7, firstDayOfWeek);
        this.removeAll();
        this.setLayout(new GridLayout(1, numDaysInWeek, 2, 2));
        this.setBackground(this.isEnabled() ? this.backgroundColorActive : this.backgroundColorInactive);
        for (int i = 0; i < numDaysInWeek; ++i) {
            JLabel label = new JLabel();
            label.setText(fmt.format(cal.getTime()));
            label.setForeground(this.isEnabled() ? UIManager.getColor("controlText") : UIManager.getColor("textInactiveText"));
            label.setHorizontalAlignment(0);
            label.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            Font boldFont = label.getFont().deriveFont(1);
            label.setFont(boldFont);
            this.add(label);
            boolean isHolliday = false;
            if (this.holidayPolicy != null) {
                isHolliday = this.holidayPolicy.isWeekend(this, cal);
            }
            if (isHolliday) {
                label.setForeground(Color.RED);
            }
            cal.add(7, 1);
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.revalidate();
        this.repaint();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.reflectData();
    }

    public void setDate(Date date) {
        this.date = date;
        this.reflectData();
    }

    public TimeZone getZone() {
        return this.zone;
    }

    public void setZone(TimeZone zone) {
        this.zone = zone;
        this.reflectData();
    }

    public void setHolidayPolicy(HolidayPolicy holidayPolicy) {
        this.holidayPolicy = holidayPolicy;
        this.reflectData();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.reflectData();
    }
}

