/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.io;

import java.io.IOException;
import java.util.Arrays;
import org.pdfbox.io.RandomAccess;

public class RandomAccessBuffer
implements RandomAccess {
    private int EXTRA_SPACE = 16384;
    private byte[] buffer = new byte[this.EXTRA_SPACE];
    private long pointer = 0L;
    private long size = this.EXTRA_SPACE;

    public void close() throws IOException {
        this.buffer = null;
        this.pointer = 0L;
        this.size = 0L;
    }

    public void seek(long position) throws IOException {
        this.pointer = position;
    }

    public int read() throws IOException {
        if (this.pointer >= this.size) {
            return -1;
        }
        byte result = this.buffer[(int)this.pointer];
        ++this.pointer;
        return result;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.pointer >= this.size) {
            return 0;
        }
        int maxLength = (int)Math.min((long)length, this.size - this.pointer);
        System.arraycopy(this.buffer, (int)this.pointer, b, offset, maxLength);
        this.pointer += (long)maxLength;
        return maxLength;
    }

    public long length() throws IOException {
        return this.size;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.pointer + (long)length >= (long)this.buffer.length) {
            byte[] temp = new byte[this.buffer.length + length + this.EXTRA_SPACE];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(this.buffer, 0, temp, 0, (int)this.size);
            this.buffer = temp;
        }
        System.arraycopy(b, offset, this.buffer, (int)this.pointer, length);
        this.pointer += (long)length;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }
}

