/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;

public class BitSet
implements IntSet,
Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public void add(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(el);
    }

    public void addAll(IntSet set) {
        if (set instanceof BitSet) {
            this.orInPlace((BitSet)set);
        } else if (set instanceof IntervalSet) {
            IntervalSet other = (IntervalSet)set;
            Iterator iter = other.intervals.iterator();
            while (iter.hasNext()) {
                Interval I = (Interval)iter.next();
                this.orInPlace(BitSet.range(I.a, I.b));
            }
        } else {
            throw new IllegalArgumentException("can't add " + set.getClass().getName() + " to BitSet");
        }
    }

    public void addAll(int[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            int e = elements[i];
            this.add(e);
            ++i;
        }
    }

    public void addAll(List elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.size()) {
            Object o = elements.get(i);
            if (!(o instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer eI = (Integer)o;
            this.add(eI);
            ++i;
        }
    }

    public IntSet and(IntSet a) {
        BitSet s = (BitSet)this.clone();
        s.andInPlace((BitSet)a);
        return s;
    }

    public void andInPlace(BitSet a) {
        int min = Math.min(this.bits.length, a.bits.length);
        int i = min - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] & a.bits[i];
            --i;
        }
        i = min;
        while (i < this.bits.length) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public void clear() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            this.bits[i] = 0L;
            --i;
        }
    }

    public void clear(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ -1L);
    }

    public Object clone() {
        BitSet s;
        try {
            s = (BitSet)super.clone();
            s.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return s;
    }

    public int size() {
        int deg = 0;
        int i = this.bits.length - 1;
        while (i >= 0) {
            long word = this.bits[i];
            if (word != 0L) {
                int bit = 63;
                while (bit >= 0) {
                    if ((word & 1L << bit) != 0L) {
                        ++deg;
                    }
                    --bit;
                }
            }
            --i;
        }
        return deg;
    }

    public boolean equals(Object other) {
        block8: {
            int i;
            int n;
            BitSet otherSet;
            block7: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n = Math.min(this.bits.length, otherSet.bits.length);
                i = 0;
                while (i < n) {
                    if (this.bits[i] != otherSet.bits[i]) {
                        return false;
                    }
                    ++i;
                }
                if (this.bits.length <= n) break block7;
                i = n + 1;
                while (i < this.bits.length) {
                    if (this.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                break block8;
            }
            if (otherSet.bits.length <= n) break block8;
            i = n + 1;
            while (i < otherSet.bits.length) {
                if (otherSet.bits[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public boolean member(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        boolean bl = false;
        if ((this.bits[n] & BitSet.bitMask(el)) != 0L) {
            bl = true;
        }
        return bl;
    }

    public int getSingleElement() {
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                return i;
            }
            ++i;
        }
        return -6;
    }

    public boolean isNil() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) {
                return false;
            }
            --i;
        }
        return true;
    }

    public IntSet complement() {
        BitSet s = (BitSet)this.clone();
        s.notInPlace();
        return s;
    }

    public IntSet complement(IntSet set) {
        if (set == null) {
            return this.complement();
        }
        return set.subtract(this);
    }

    public void notInPlace() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            this.bits[i] = this.bits[i] ^ -1L;
            --i;
        }
    }

    public void notInPlace(int maxBit) {
        this.notInPlace(0, maxBit);
    }

    public void notInPlace(int minBit, int maxBit) {
        this.growToInclude(maxBit);
        int i = minBit;
        while (i <= maxBit) {
            int n;
            int n2 = n = BitSet.wordNumber(i);
            this.bits[n2] = this.bits[n2] ^ BitSet.bitMask(i);
            ++i;
        }
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public static BitSet of(int el) {
        BitSet s = new BitSet(el + 1);
        s.add(el);
        return s;
    }

    public static BitSet of(Collection elements) {
        BitSet s = new BitSet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Integer el = (Integer)iter.next();
            s.add(el);
        }
        return s;
    }

    public static BitSet of(IntSet set) {
        if (set == null) {
            return null;
        }
        if (set instanceof BitSet) {
            return (BitSet)set;
        }
        if (set instanceof IntervalSet) {
            BitSet s = new BitSet();
            s.addAll(set);
            return s;
        }
        throw new IllegalArgumentException("can't create BitSet from " + set.getClass().getName());
    }

    public static BitSet of(Map elements) {
        return BitSet.of(elements.keySet());
    }

    public static BitSet range(int a, int b) {
        BitSet s = new BitSet(b + 1);
        int i = a;
        while (i <= b) {
            int n;
            int n2 = n = BitSet.wordNumber(i);
            s.bits[n2] = s.bits[n2] | BitSet.bitMask(i);
            ++i;
        }
        return s;
    }

    public IntSet or(IntSet a) {
        if (a == null) {
            return this;
        }
        BitSet s = (BitSet)this.clone();
        s.orInPlace((BitSet)a);
        return s;
    }

    public void orInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min = Math.min(this.bits.length, a.bits.length);
        int i = min - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] | a.bits[i];
            --i;
        }
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ -1L);
    }

    private final void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet a) {
        if (a == null) {
            return false;
        }
        return this.and(a).equals(this);
    }

    public void subtractInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        int i = 0;
        while (i < this.bits.length && i < a.bits.length) {
            int n = i;
            this.bits[n] = this.bits[n] & (a.bits[i] ^ -1L);
            ++i;
        }
    }

    public IntSet subtract(IntSet a) {
        if (a == null || !(a instanceof BitSet)) {
            return null;
        }
        BitSet s = (BitSet)this.clone();
        s.subtractInPlace((BitSet)a);
        return s;
    }

    public List toList() {
        throw new NoSuchMethodError("BitSet.toList() unimplemented");
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en = 0;
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                elems[en++] = i;
            }
            ++i;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Grammar g) {
        StringBuffer buf = new StringBuffer();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                if (i > 0 && havePrintedAnElement) {
                    buf.append(separator);
                }
                if (g != null) {
                    buf.append(g.getTokenDisplayName(i));
                } else {
                    buf.append(i);
                }
                havePrintedAnElement = true;
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }

    public String toString(String separator, List vocabulary) {
        if (vocabulary == null) {
            return this.toString(null);
        }
        String str = "";
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                if (str.length() > 0) {
                    str = str + separator;
                }
                str = i >= vocabulary.size() ? str + '\'' + (char)i + '\'' : (vocabulary.get(i) == null ? str + '\'' + (char)i + '\'' : str + (String)vocabulary.get(i));
            }
            ++i;
        }
        return str;
    }

    public String toStringOfHalfWords() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.bits.length) {
            if (i != 0) {
                s.append(", ");
            }
            long tmp = this.bits[i];
            s.append(tmp &= 0xFFFFFFFFL);
            s.append("UL");
            s.append(", ");
            tmp = this.bits[i] >>> 32;
            s.append(tmp &= 0xFFFFFFFFL);
            s.append("UL");
            ++i;
        }
        return s.toString();
    }

    public String toStringOfWords() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.bits.length) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(this.bits[i]);
            s.append("L");
            ++i;
        }
        return s.toString();
    }

    public String toStringWithRanges() {
        return this.toString();
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }
}

