/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestInterpretedParsing
extends BaseTest {
    public void testSimpleParse() throws Exception {
        Grammar pg = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY EOF;\nassign : ID ASSIGN expr SEMI ;\nexpr : INT | FLOAT | ID ;\n");
        Grammar g = new Grammar();
        g.importTokenVocabulary(pg);
        g.setFileName("__string");
        g.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream input = new ANTLRStringStream("while x { i=1; y=3.42; z=y; }");
        Interpreter lexEngine = new Interpreter(g, input);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        tokens.setTokenTypeChannel(g.getTokenType("WS"), 99);
        Interpreter parseEngine = new Interpreter(pg, tokens);
        ParseTree t = parseEngine.parse("prog");
        String result = t.toStringTree();
        String expecting = "(<grammar p> (prog [@0,0:4='while',<4>,1:0] [@2,6:6='x',<5>,1:6] [@4,8:8='{',<6>,1:8] (assign [@6,10:10='i',<5>,1:10] [@7,11:11='=',<8>,1:11] (expr [@8,12:12='1',<10>,1:12]) [@9,13:13=';',<9>,1:13]) (assign [@11,15:15='y',<5>,1:15] [@12,16:16='=',<8>,1:16] (expr [@13,17:20='3.42',<11>,1:17]) [@14,21:21=';',<9>,1:21]) (assign [@16,23:23='z',<5>,1:23] [@17,24:24='=',<8>,1:24] (expr [@18,25:25='y',<5>,1:25]) [@19,26:26=';',<9>,1:26]) [@21,28:28='}',<7>,1:28] [@0,0:0='<no text>',<-1>,0:-1]))";
        TestInterpretedParsing.assertEquals((String)result, (String)expecting);
    }

    public void testMismatchedTokenError() throws Exception {
        Grammar pg = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY;\nassign : ID ASSIGN expr SEMI ;\nexpr : INT | FLOAT | ID ;\n");
        Grammar g = new Grammar();
        g.setFileName("__string");
        g.importTokenVocabulary(pg);
        g.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream input = new ANTLRStringStream("while x { i=1 y=3.42; z=y; }");
        Interpreter lexEngine = new Interpreter(g, input);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        tokens.setTokenTypeChannel(g.getTokenType("WS"), 99);
        Interpreter parseEngine = new Interpreter(pg, tokens);
        ParseTree t = parseEngine.parse("prog");
        String result = t.toStringTree();
        String expecting = "(<grammar p> (prog [@0,0:4='while',<4>,1:0] [@2,6:6='x',<5>,1:6] [@4,8:8='{',<6>,1:8] (assign [@6,10:10='i',<5>,1:10] [@7,11:11='=',<8>,1:11] (expr [@8,12:12='1',<10>,1:12]) MismatchedTokenException(5!=9))))";
        TestInterpretedParsing.assertEquals((String)result, (String)expecting);
    }

    public void testMismatchedSetError() throws Exception {
        Grammar pg = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY;\nassign : ID ASSIGN expr SEMI ;\nexpr : INT | FLOAT | ID ;\n");
        Grammar g = new Grammar();
        g.importTokenVocabulary(pg);
        g.setFileName("<string>");
        g.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream input = new ANTLRStringStream("while x { i=; y=3.42; z=y; }");
        Interpreter lexEngine = new Interpreter(g, input);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        tokens.setTokenTypeChannel(g.getTokenType("WS"), 99);
        Interpreter parseEngine = new Interpreter(pg, tokens);
        ParseTree t = parseEngine.parse("prog");
        String result = t.toStringTree();
        String expecting = "(<grammar p> (prog [@0,0:4='while',<4>,1:0] [@2,6:6='x',<5>,1:6] [@4,8:8='{',<6>,1:8] (assign [@6,10:10='i',<5>,1:10] [@7,11:11='=',<8>,1:11] (expr MismatchedSetException(9!={5, 10..11})))))";
        TestInterpretedParsing.assertEquals((String)result, (String)expecting);
    }

    public void testNoViableAltError() throws Exception {
        Grammar pg = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY;\nassign : ID ASSIGN expr SEMI ;\nexpr : {;}INT | FLOAT | ID ;\n");
        Grammar g = new Grammar();
        g.importTokenVocabulary(pg);
        g.setFileName("<string>");
        g.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream input = new ANTLRStringStream("while x { i=; y=3.42; z=y; }");
        Interpreter lexEngine = new Interpreter(g, input);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        tokens.setTokenTypeChannel(g.getTokenType("WS"), 99);
        Interpreter parseEngine = new Interpreter(pg, tokens);
        ParseTree t = parseEngine.parse("prog");
        String result = t.toStringTree();
        String expecting = "(<grammar p> (prog [@0,0:4='while',<4>,1:0] [@2,6:6='x',<5>,1:6] [@4,8:8='{',<6>,1:8] (assign [@6,10:10='i',<5>,1:10] [@7,11:11='=',<8>,1:11] (expr NoViableAltException(9!=[4:1: expr : ( INT | FLOAT | ID );])))))";
        TestInterpretedParsing.assertEquals((String)result, (String)expecting);
    }
}

