/*
 *  Jajuk
 *  Copyright (C) 2007 The Jajuk Team
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *  $Revision$
 */

package org.jajuk.ui.widgets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jajuk.services.core.SessionService;
import org.jajuk.util.Conf;
import org.jajuk.util.Const;
import org.jajuk.util.DownloadManager;
import org.jajuk.util.LocaleManager;
import org.jajuk.util.Messages;
import org.jajuk.util.UtilGUI;
import org.jajuk.util.UtilSystem;
import org.w3c.dom.Document;
import org.xamjwg.html.HtmlParserContext;
import org.xamjwg.html.gui.HtmlPanel;
import org.xamjwg.html.parser.DocumentBuilderImpl;
import org.xamjwg.html.parser.InputSourceImpl;
import org.xamjwg.html.test.SimpleHtmlParserContext;
import org.xamjwg.html.test.SimpleHtmlRendererContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Type description
 */
public class JajukHtmlPanel extends HtmlPanel {

  private static final long serialVersionUID = -4033441908072591661L;

  private final SimpleHtmlRendererContext rcontext;

  private final HtmlParserContext context;

  private final DocumentBuilderImpl dbi;

  /**
   * A HTML renderer based on Cobra
   */
  public JajukHtmlPanel() {
    super();
    // Disable Cobra traces
    Logger.getLogger("").setLevel(Level.OFF);
    rcontext = new SimpleHtmlRendererContext(this);
    context = new SimpleHtmlParserContext();
    dbi = new DocumentBuilderImpl(context, rcontext);
  }

  /**
   * Display a wikipedia url
   * 
   * @throws SAXException
   */
  public void setURL(URL url) throws IOException, SAXException {
    setCursor(UtilGUI.WAIT_CURSOR);
    File page = new File(SessionService.getConfFileByPath(Const.FILE_CACHE).getAbsolutePath() + '/'
        + UtilSystem.getOnlyFile(url.toString() + ".html"));
    String sPage = DownloadManager.downloadText(url);
    // Leave if no result
    if (sPage == null) {
      return;
    }
    // Remove scripting
    int index = -1;
    int lastindex = -1;
    StringBuilder sb = new StringBuilder(sPage);
    // only the part between <!-- start content --> and <!-- end content --> is
    // important to us
    index = sb.indexOf("<!-- start content -->");
    lastindex = sb.indexOf("</body></html>");
    if (index > 0) {
      sb.delete(0, index);
      sb.delete(sb.indexOf("<!-- end content -->") + 20, lastindex);
    }
    sPage = sb.toString();
    // fix internal links
    // TODO: language should be retrieved from the combo box and not from the
    // user settings, but dunno how to get that...
    sPage = sPage.replaceAll("href=\"/", "href=\"http://"
        + LocaleManager.getLocaleForDesc(LocaleManager.getDescForLocale(Conf
            .getString(Const.CONF_WIKIPEDIA_LANGUAGE))) + ".wikipedia.org/");
    // Display the page
    showPage(sPage, page);
    // Set current url as a tooltip
    setToolTipText(url.toString());
    // Disable waiting cursor
    setCursor(UtilGUI.DEFAULT_CURSOR);
  }

  /**
   * Display a "nothing found" page
   * 
   * @throws SAXException
   * 
   * @throws Exception
   */
  public void setUnknow() throws IOException, SAXException {
    File page = new File(SessionService.getConfFileByPath(Const.FILE_CACHE).getAbsolutePath() + '/'
        + "noresult.html");
    String sPage = "<html><body><h1>" + Messages.getString("WikipediaView.3")
        + "</h1></body></html>";
    showPage(sPage, page);
  }

  /**
   * Make the internal operations
   * 
   * @param sPage
   * @param page
   * @throws IOException
   * @throws SAXException
   */
  private void showPage(String sPage, File page) throws IOException, SAXException {
    // Write the page itself
    Writer bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(page), "UTF-8"));
    try {
      bw.write(sPage);
      bw.flush();
    } finally {
      bw.close();
    }
    // A Reader should be created with the correct charset,
    // which may be obtained from the Content-Type header
    // of an HTTP response.
    Reader reader = new InputStreamReader(new FileInputStream(page), "UTF-8");
    try {
      // InputSourceImpl constructor with URI recommended
      // so the renderer can resolve page component URLs.
      InputSource is = new InputSourceImpl(reader, "file://" + page.getAbsolutePath());
      // A documentURI should be provided to resolve relative
      // URIs.
      Document document = dbi.parse(is);

      // Now set document in panel. This is what causes the
      // document to render.
      setDocument(document, rcontext);
    } finally {
      reader.close();
    }
  }

  public void back() {
    rcontext.back();
  }

}
