package org.jboss.ha.singleton;

import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;

public interface HASingletonElectionPolicy
{

   /**
    * Called by the HASingleton to provide the election policy a reference to 
    * itself.  A policy that was designed to elect a particular kind of singleton
    * could downcast this object to a particular type and then access the
    * singleton for state information needed for the election decision.
    */
   void setManagedSingleton(Object singleton);

   Object getManagedSingleton();

   /**
    * Sets the HAPartition; from this the election policy can gain
    * access to the DistributedReplicantManager for tracking the 
    * deployment topology for the singleton service and to the HAPartition 
    * for making group RPC calls.
    */
   void setHAPartition(HAPartition partition);

   HAPartition getHAPartition();

   /**
    * Return the elected master node.
    * @return the master node
    */
   ClusterNode pickSingleton();

   /**
    * Given the HAPartition, return the elected master node.
    * @param partition
    * @return the master node
    */
   ClusterNode pickSingleton(HAPartition partition);

   /**
    * Conducts an election and returns whether the managed service
    * is the master, based on the current view of partition.
    * @return true only if the managed service is the master
    */
   boolean isElectedMaster();

   /**
    * Given the HAPartition, return whether the managed service is the master.
    * @param partition
    * @return true only if the managed service is the master
    */
   boolean isElectedMaster(HAPartition partition);

}