/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.UserTransaction;
import org.objectweb.carol.util.configuration.CarolConfiguration;
import org.objectweb.carol.util.configuration.RMIConfigurationException;
import org.objectweb.jonas_timer.TimerManager;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.objectweb.transaction.jta.TMService;
import org.objectweb.transaction.jta.TransactionManager;

public class Jotm
implements TMService {
    Current current = null;
    private static final String TMFACTORY_NAME = "TMFactory";
    private TransactionFactory tf = null;
    private boolean local;
    private boolean bound;

    public Jotm(boolean local, boolean bound) throws NamingException {
        TraceTm.configure();
        if (TraceTm.jotm.isInfoEnabled()) {
            TraceTm.jotm.info((Object)("JOTM started with a " + (local ? "local" : "remote") + " transaction factory" + " which is " + (bound ? "" : "not") + " bound."));
        }
        this.local = local;
        this.bound = bound;
        TraceTm.jotm.info((Object)"CAROL initialization");
        try {
            CarolConfiguration.init();
        }
        catch (RMIConfigurationException e) {
            TraceTm.jotm.error((Object)"CAROL initialization failed", (Throwable)e);
        }
        if (local) {
            try {
                this.tf = new TransactionFactoryImpl();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Instanciation of TransactionFactory failed", (Throwable)e);
            }
            if (bound) {
                try {
                    InitialContext ictx = new InitialContext();
                    ictx.rebind(TMFACTORY_NAME, (Object)this.tf);
                }
                catch (NamingException e) {
                    TraceTm.jotm.error((Object)"TransactionFactory rebind failed", (Throwable)e);
                    throw e;
                }
            }
        } else {
            try {
                InitialContext ictx = new InitialContext();
                this.tf = (TransactionFactory)ictx.lookup(TMFACTORY_NAME);
            }
            catch (NamingException e) {
                TraceTm.jotm.error((Object)"TransactionFactory lookup failed", (Throwable)e);
                throw e;
            }
        }
        this.current = new Current(this.tf);
    }

    public TransactionManager getTransactionManager() {
        TraceTm.jotm.debug((Object)("TransactionManager=" + this.current));
        return this.current;
    }

    public UserTransaction getUserTransaction() {
        TraceTm.jotm.debug((Object)("UserTransaction=" + this.current));
        return this.current;
    }

    public void stop() {
        TraceTm.jotm.info((Object)"stop JOTM");
        if (this.local) {
            try {
                InitialContext ictx = new InitialContext();
                ictx.unbind(TMFACTORY_NAME);
                PortableRemoteObject.unexportObject((Remote)this.tf);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.tf = null;
        TimerManager.stop(false);
    }
}

