/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.common.P6SpyOptions;
import com.p6spy.engine.spy.P6Base;
import com.p6spy.engine.spy.P6SpyDriverCore;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class P6DataSource
extends P6Base
implements DataSource,
Referenceable,
Serializable {
    protected DataSource rds;
    protected String rdsName;
    static /* synthetic */ Class class$com$p6spy$engine$spy$P6SpyDriver;

    public static void initMethod() {
        P6SpyDriverCore.initMethod((class$com$p6spy$engine$spy$P6SpyDriver == null ? (class$com$p6spy$engine$spy$P6SpyDriver = P6DataSource.class$("com.p6spy.engine.spy.P6SpyDriver")) : class$com$p6spy$engine$spy$P6SpyDriver).getName());
    }

    public String getDataSourceName() {
        return this.rdsName;
    }

    public void setDataSourceName(String inVar) {
        this.rdsName = inVar;
    }

    protected void bindDataSource() throws SQLException {
        if (this.rdsName == null) {
            this.rdsName = P6SpyOptions.getRealDataSource();
        }
        if (this.rdsName == null) {
            throw new SQLException("P6DataSource: no value for Real Data Source Name, cannot perform jndi lookup");
        }
        try {
            Hashtable<String, String> env = null;
            String factory = P6SpyOptions.getJNDIContextFactory();
            if (factory != null) {
                String custom;
                env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", factory);
                String url = P6SpyOptions.getJNDIContextProviderURL();
                if (url != null) {
                    env.put("java.naming.provider.url", url);
                }
                if ((custom = P6SpyOptions.getJNDIContextCustom()) != null) {
                    StringTokenizer st = new StringTokenizer(custom, ",", false);
                    while (st.hasMoreElements()) {
                        String pair = st.nextToken();
                        StringTokenizer pst = new StringTokenizer(pair, ";", false);
                        if (!pst.hasMoreElements()) continue;
                        String name = pst.nextToken();
                        if (!pst.hasMoreElements()) continue;
                        String value = pst.nextToken();
                        env.put(name, value);
                    }
                }
            }
            InitialContext ctx = env != null ? new InitialContext(env) : new InitialContext();
            this.rds = (DataSource)ctx.lookup(this.rdsName);
            String dsProps = P6SpyOptions.getRealDataSourceProperties();
            if (dsProps != null) {
                Hashtable<String, String> props = null;
                StringTokenizer st = new StringTokenizer(dsProps, ",", false);
                while (st.hasMoreElements()) {
                    String pair = st.nextToken();
                    StringTokenizer pst = new StringTokenizer(pair, ";", false);
                    if (!pst.hasMoreElements()) continue;
                    String name = pst.nextToken();
                    if (!pst.hasMoreElements()) continue;
                    String value = pst.nextToken();
                    if (props == null) {
                        props = new Hashtable<String, String>();
                    }
                    props.put(name, value);
                }
                Hashtable<String, String> matchedProps = new Hashtable<String, String>();
                if (props != null) {
                    Class<?> klass = this.rds.getClass();
                    Method[] methods = klass.getMethods();
                    int i = 0;
                    while (methods != null && i < methods.length) {
                        Method method = methods[i];
                        String methodName = method.getName();
                        if (methodName.startsWith("set")) {
                            String propertyname = methodName.substring(3).toLowerCase();
                            Enumeration keys = props.keys();
                            while (keys.hasMoreElements()) {
                                String key = (String)keys.nextElement();
                                if (!key.toLowerCase().equals(propertyname)) continue;
                                try {
                                    Object[] args;
                                    String value = (String)props.get(key);
                                    Class<?>[] types = method.getParameterTypes();
                                    if (types[0].getName().equals(value.getClass().getName())) {
                                        args = new String[]{value};
                                        P6LogQuery.logDebug("calling " + methodName + " on DataSource " + this.rdsName + " with " + value);
                                        method.invoke((Object)this.rds, args);
                                        matchedProps.put(key, value);
                                        continue;
                                    }
                                    if (types[0].isPrimitive() && types[0].getName().equals("int")) {
                                        args = new Integer[]{Integer.valueOf(value)};
                                        P6LogQuery.logDebug("calling " + methodName + " on DataSource " + this.rdsName + " with " + value);
                                        method.invoke((Object)this.rds, args);
                                        matchedProps.put(key, value);
                                        continue;
                                    }
                                    P6LogQuery.logDebug("method " + methodName + " on DataSource " + this.rdsName + " matches property " + propertyname + " but expects unsupported type " + types[0].getName());
                                    matchedProps.put(key, value);
                                }
                                catch (IllegalAccessException e) {
                                    throw new SQLException("spy.properties file includes datasource property " + key + " for datasource " + this.rdsName + " but access is denied to method " + methodName);
                                }
                                catch (InvocationTargetException e2) {
                                    throw new SQLException("spy.properties file includes datasource property " + key + " for datasource " + this.rdsName + " but call method " + methodName + " fails");
                                }
                            }
                        }
                        ++i;
                    }
                    Enumeration keys = props.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (matchedProps.containsKey(key)) continue;
                        P6LogQuery.logDebug("spy.properties file includes datasource property " + key + " for datasource " + this.rdsName + " but class " + klass.getName() + " has no method" + " by that name");
                    }
                }
            }
        }
        catch (NamingException e) {
            throw new SQLException("P6DataSource: naming exception during jndi lookup of Real Data Source Name of '" + this.rdsName + "'. " + e.getMessage());
        }
        if (this.rds == null) {
            throw new SQLException("P6DataSource: jndi lookup for Real Data Source Name of '" + this.rdsName + "' failed, cannot bind named data source.");
        }
    }

    public Reference getReference() throws NamingException {
        String FactoryName = "com.p6spy.engine.spy.P6DataSourceFactory";
        Reference Ref2 = new Reference(this.getClass().getName(), FactoryName, null);
        Ref2.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        return Ref2;
    }

    public int getLoginTimeout() throws SQLException {
        if (this.rds == null) {
            this.bindDataSource();
        }
        return this.rds.getLoginTimeout();
    }

    public void setLoginTimeout(int inVar) throws SQLException {
        if (this.rds == null) {
            this.bindDataSource();
        }
        this.rds.setLoginTimeout(inVar);
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.rds == null) {
            this.bindDataSource();
        }
        return this.rds.getLogWriter();
    }

    public void setLogWriter(PrintWriter inVar) throws SQLException {
        this.rds.setLogWriter(inVar);
    }

    public Connection getConnection() throws SQLException {
        if (this.rds == null) {
            this.bindDataSource();
        }
        return P6SpyDriverCore.wrapConnection(this.rds.getConnection());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.rds == null) {
            this.bindDataSource();
        }
        return P6SpyDriverCore.wrapConnection(this.rds.getConnection(username, password));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        P6DataSource.initMethod();
    }
}

