/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.mortbay.util.Code;
import org.mortbay.util.IO;

public class HttpTunnel {
    private Socket _socket;
    private Thread _thread;
    private int _timeoutMs;
    private InputStream _in;
    private OutputStream _out;

    protected HttpTunnel() {
    }

    public HttpTunnel(Socket socket, int timeoutMs) {
        this._socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(InputStream in, OutputStream out) {
        Copy copy = new Copy();
        this._in = in;
        this._out = out;
        try {
            this._thread = Thread.currentThread();
            copy.start();
            this.copydata(this._socket.getInputStream(), this._out);
        }
        catch (Exception e) {
            Code.ignore(e);
        }
        finally {
            try {
                this._in.close();
                this._socket.shutdownOutput();
                this._socket.close();
            }
            catch (Exception e) {
                Code.ignore(e);
            }
            copy.interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copydata(InputStream in, OutputStream out) throws IOException {
        long timestamp = 0L;
        while (true) {
            try {
                IO.copy(in, out);
                return;
            }
            catch (InterruptedIOException e) {
                Code.ignore(e);
                if (timestamp == 0L) {
                    timestamp = System.currentTimeMillis();
                    continue;
                }
                if (this._timeoutMs > 0 && System.currentTimeMillis() - timestamp > (long)this._timeoutMs) throw e;
                continue;
            }
            break;
        }
    }

    private class Copy
    extends Thread {
        private Copy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HttpTunnel.this.copydata(HttpTunnel.this._in, HttpTunnel.this._socket.getOutputStream());
            }
            catch (Exception e) {
                Code.ignore(e);
            }
            finally {
                try {
                    HttpTunnel.this._out.close();
                    HttpTunnel.this._socket.shutdownInput();
                    HttpTunnel.this._socket.close();
                }
                catch (Exception e) {
                    Code.ignore(e);
                }
                HttpTunnel.this._thread.interrupt();
            }
        }
    }
}

