/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.j2ee.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.logging.Logger;
import org.mortbay.j2ee.session.Container;
import org.mortbay.j2ee.session.DistributableIdGenerator;
import org.mortbay.j2ee.session.IdGenerator;
import org.mortbay.j2ee.session.LocalStore;
import org.mortbay.j2ee.session.State;
import org.mortbay.j2ee.session.StateAdaptor;
import org.mortbay.j2ee.session.StateInterceptor;
import org.mortbay.j2ee.session.Store;
import org.mortbay.j2ee.session.ValidatingInterceptor;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionContext;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class Manager
implements SessionManager {
    protected static final Logger _log = Logger.getLogger((Class)(class$org$mortbay$j2ee$session$Manager == null ? (class$org$mortbay$j2ee$session$Manager = Manager.class$("org.mortbay.j2ee.session.Manager")) : class$org$mortbay$j2ee$session$Manager));
    protected WebApplicationContext _context;
    protected int _scavengerPeriod = 60;
    protected StateInterceptor[] _interceptorStack = null;
    protected IdGenerator _idGenerator = null;
    protected int _maxInactiveInterval;
    protected Store _store = null;
    final Map _sessions = new HashMap();
    boolean _started = false;
    Object _startedLock = new Object();
    Timer _scavenger;
    protected ServletHandler _handler;
    final List _sessionListeners = new ArrayList();
    final List _sessionAttributeListeners = new ArrayList();
    static /* synthetic */ Class class$org$mortbay$j2ee$session$Manager;

    public WebApplicationContext getContext() {
        return this._context;
    }

    public void setContext(WebApplicationContext context) {
        this._context = context;
    }

    public void setScavengerPeriod(int period) {
        this._scavengerPeriod = period;
    }

    public int getScavengerPeriod() {
        return this._scavengerPeriod;
    }

    public StateInterceptor[] getInterceptorStack() {
        return this._interceptorStack;
    }

    public void setInterceptorStack(StateInterceptor[] interceptorStack) {
        this._interceptorStack = interceptorStack;
    }

    public IdGenerator getIdGenerator() {
        return this._idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this._idGenerator = idGenerator;
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int seconds) {
        this._maxInactiveInterval = seconds;
    }

    public Store getStore() {
        return this._store;
    }

    public void setStore(Store store) {
        this._store = store;
        if (this._store != null) {
            this._store.setManager(this);
        }
    }

    public Object clone() {
        IdGenerator ig;
        Manager m = new Manager();
        Store store = this.getStore();
        if (store != null) {
            m.setStore((Store)store.clone());
        }
        if ((ig = this.getIdGenerator()) != null) {
            m.setIdGenerator((IdGenerator)ig.clone());
        }
        m.setInterceptorStack(this.getInterceptorStack());
        m.setMaxInactiveInterval(this.getMaxInactiveInterval());
        m.setScavengerPeriod(this.getScavengerPeriod());
        return m;
    }

    public String getContextPath() {
        return this._handler.getHttpContext().getContextPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        _log.trace((Object)"starting...");
        Object object = this._startedLock;
        synchronized (object) {
            if (this._started) {
                _log.warn((Object)"already started");
                return;
            }
            if (this._store == null) {
                _log.warn((Object)"No Store. Falling back to a local session implementation - NO HTTPSESSION DISTRIBUTION");
                this.setStore(new LocalStore());
            }
            if (this._idGenerator == null) {
                this._idGenerator = new DistributableIdGenerator();
            }
            try {
                this._store.start();
            }
            catch (Exception e) {
                _log.warn((Object)"Faulty Store. Falling back to a local session implementation - NO HTTPSESSION DISTRIBUTION", (Throwable)e);
                this.setStore(new LocalStore());
                try {
                    this._store.start();
                }
                catch (Exception e2) {
                    _log.error((Object)"could not start Store", (Throwable)e2);
                }
            }
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("starting local scavenger thread...(period: " + this.getScavengerPeriod() + " secs)"));
            }
            long delay = this.getScavengerPeriod() * 1000;
            boolean isDaemon = true;
            this._scavenger = new Timer(isDaemon);
            this._scavenger.scheduleAtFixedRate((TimerTask)new Scavenger(), delay, delay);
            _log.trace((Object)"...local scavenger thread started");
            this._started = true;
        }
        _log.trace((Object)"...started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this._startedLock;
        synchronized (object) {
            return this._started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        _log.trace((Object)"stopping...");
        Object object = this._startedLock;
        synchronized (object) {
            if (!this._started) {
                _log.warn((Object)"already stopped/not yet started");
                return;
            }
            Map map = this._sessions;
            synchronized (map) {
                ArrayList copy = new ArrayList(this._sessions.values());
                Iterator i = copy.iterator();
                while (i.hasNext()) {
                    ((StateAdaptor)i.next()).migrate();
                }
                this._sessions.clear();
            }
            _log.trace((Object)"stopping local scavenger thread...");
            this._scavenger.cancel();
            this._scavenger = null;
            _log.trace((Object)"...local scavenger thread stopped");
            this.scavenge();
            this._store.stop();
            this._store.destroy();
            this.setStore(null);
            this._started = false;
        }
        _log.trace((Object)"...stopped");
    }

    public void initialize(ServletHandler handler) {
        _log.trace((Object)"initialising...");
        this._handler = handler;
        _log.trace((Object)"...initialised");
    }

    public HttpSession getHttpSession(String id) {
        return this.findSession(id, true);
    }

    public boolean sessionExists(String id) {
        return this.findSession(id, false) != null;
    }

    public HttpSession newHttpSession(HttpServletRequest request) {
        return this.newSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener listener) throws IllegalArgumentException, IllegalStateException {
        Object object = this._startedLock;
        synchronized (object) {
            if (this.isStarted()) {
                throw new IllegalStateException("EventListeners must be added before a Session Manager starts");
            }
            boolean known = false;
            if (listener instanceof HttpSessionAttributeListener) {
                this._sessionAttributeListeners.add(listener);
                known = true;
            }
            if (listener instanceof HttpSessionListener) {
                this._sessionListeners.add(listener);
                known = true;
            }
            if (!known) {
                throw new IllegalArgumentException("Unknown EventListener type " + listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) throws IllegalStateException {
        Object object = this._startedLock;
        synchronized (object) {
            if (this.isStarted()) {
                throw new IllegalStateException("EventListeners may not be removed while a Session Manager is running");
            }
            if (listener instanceof HttpSessionAttributeListener) {
                this._sessionAttributeListeners.remove(listener);
            }
            if (listener instanceof HttpSessionListener) {
                this._sessionListeners.remove(listener);
            }
        }
    }

    public ServletContext getServletContext() {
        return this._handler.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return SessionContext.NULL_IMPL;
    }

    protected HttpSession newContainer(String id, State state) {
        return Container.newContainer(this, id, state, this.getMaxInactiveInterval(), this.currentSecond(), this.getInterceptorStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession newSession(HttpServletRequest request) {
        String id = null;
        HttpSession session = null;
        try {
            id = this._store.allocateId(request);
            State state = this._store.newState(id, this.getMaxInactiveInterval());
            session = this.newContainer(id, state);
        }
        catch (Exception e) {
            _log.error((Object)"could not create HttpSession", (Throwable)e);
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("remembering session - " + id));
        }
        Map map = this._sessions;
        synchronized (map) {
            this._sessions.put(id, session);
        }
        this.notifySessionCreated(session);
        return session;
    }

    protected State destroyContainer(HttpSession session) {
        return Container.destroyContainer(session, this.getInterceptorStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroySession(HttpSession container) {
        State state;
        Object tmp;
        String id = container.getId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("forgetting session - " + id));
        }
        Map map = this._sessions;
        synchronized (map) {
            tmp = this._sessions.remove(id);
        }
        container = (HttpSession)tmp;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("forgetting session - " + container));
        }
        if (container == null) {
            _log.warn((Object)("session - " + container + " has already been destroyed"));
            return;
        }
        try {
            State s = state = ((StateAdaptor)container).getState();
            StateInterceptor si = null;
            while (s instanceof StateInterceptor) {
                si = (StateInterceptor)s;
                s = si.getState();
                if (!(si instanceof ValidatingInterceptor)) continue;
                si.stop();
            }
            String[] names = state.getAttributeNameStringArray();
            int i = 0;
            while (i < names.length) {
                state.removeAttribute(names[i], false);
                ++i;
            }
        }
        catch (RemoteException e) {
            _log.error((Object)"could not raise events on session destruction - problem in distribution layer", (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("notifying session - " + id));
        }
        this.notifySessionDestroyed(container);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("destroying container - " + id));
        }
        state = this.destroyContainer(container);
        try {
            if (state != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("removing state - " + id));
                }
                this._store.removeState(state);
            }
        }
        catch (Exception e) {
            _log.error((Object)"could not remove session state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession findSession(String id, boolean create) {
        HttpSession container;
        block6: {
            container = null;
            try {
                State state = this._store.loadState(id);
                State state2 = state = state != null && state.isValid() ? state : null;
                if (state == null) break block6;
                Map map = this._sessions;
                synchronized (map) {
                    container = (HttpSession)this._sessions.get(id);
                    if (container == null && create) {
                        container = this.newContainer(id, state);
                        this._sessions.put(id, container);
                    }
                }
            }
            catch (Exception ignore) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)("did not find distributed session: " + id));
            }
        }
        return container;
    }

    public Object notifyAttributeAdded(HttpSession session, String name, Object value) {
        int n = this._sessionAttributeListeners.size();
        if (n > 0) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, name, value);
            int i = 0;
            while (i < n) {
                ((HttpSessionAttributeListener)this._sessionAttributeListeners.get(i)).attributeAdded(event);
                ++i;
            }
            event = null;
        }
        return value;
    }

    public Object notifyAttributeReplaced(HttpSession session, String name, Object value) {
        int n = this._sessionAttributeListeners.size();
        if (n > 0) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, name, value);
            int i = 0;
            while (i < n) {
                ((HttpSessionAttributeListener)this._sessionAttributeListeners.get(i)).attributeReplaced(event);
                ++i;
            }
            event = null;
        }
        return value;
    }

    public Object notifyAttributeRemoved(HttpSession session, String name, Object value) {
        int n = this._sessionAttributeListeners.size();
        if (n > 0) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, name, value);
            int i = 0;
            while (i < n) {
                ((HttpSessionAttributeListener)this._sessionAttributeListeners.get(i)).attributeRemoved(event);
                ++i;
            }
            event = null;
        }
        return value;
    }

    public void notifySessionCreated(HttpSession session) {
        int n = this._sessionListeners.size();
        if (n > 0) {
            HttpSessionEvent event = new HttpSessionEvent(session);
            int i = 0;
            while (i < n) {
                ((HttpSessionListener)this._sessionListeners.get(i)).sessionCreated(event);
                ++i;
            }
            Object var3_3 = null;
        }
    }

    public void notifySessionDestroyed(HttpSession session) {
        int n = this._sessionListeners.size();
        if (n > 0) {
            HttpSessionEvent event = new HttpSessionEvent(session);
            int i = 0;
            while (i < n) {
                ((HttpSessionListener)this._sessionListeners.get(i)).sessionDestroyed(event);
                ++i;
            }
            Object var3_3 = null;
        }
    }

    public long currentSecond() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        ArrayList copy;
        _log.trace((Object)"starting local scavenge...");
        Map map = this._sessions;
        synchronized (map) {
            copy = new ArrayList(this._sessions.values());
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            String id = null;
            long t = System.currentTimeMillis();
            try {
                StateAdaptor sa = (StateAdaptor)i.next();
                id = sa.getId();
                long lat = sa.getLastAccessedTime();
            }
            catch (IllegalStateException ignore) {
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("session (" + id + ") must have been invalid - removing it"));
                }
                Map map2 = this._sessions;
                synchronized (map2) {
                    this._sessions.remove(id);
                }
            }
        }
        _log.trace((Object)"...finished local scavenge");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Scavenger
    extends TimerTask {
        Scavenger() {
        }

        public void run() {
            Manager.this.scavenge();
        }
    }
}

