/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.common;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;

public class LevelImpl
implements Level,
Serializable {
    int value = 0;
    String name = null;
    String stringValue = null;

    public LevelImpl(String string, int n) {
        this.value = n;
        this.name = string;
        this.stringValue = String.valueOf(n);
    }

    public LevelImpl(String string, String string2, LevelFactory levelFactory) {
        this.stringValue = string2;
        this.value = LevelImpl.evaluate(string2, levelFactory);
        this.name = string;
    }

    public int compareTo(Level level) {
        return this.value - level.getIntValue();
    }

    public static int evaluate(String string, LevelFactory levelFactory) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +-", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("FATAL")) {
                n = BasicLevel.FATAL;
                continue;
            }
            if (string2.equalsIgnoreCase("ERROR")) {
                n = BasicLevel.ERROR;
                continue;
            }
            if (string2.equalsIgnoreCase("WARN")) {
                n = BasicLevel.WARN;
                continue;
            }
            if (string2.equalsIgnoreCase("INFO")) {
                n = BasicLevel.INFO;
                continue;
            }
            if (string2.equalsIgnoreCase("DEBUG")) {
                n = BasicLevel.DEBUG;
                continue;
            }
            if (Character.isDigit(string2.charAt(0))) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (Character.isLetter(string2.charAt(0))) {
                Level level = levelFactory.getLevel(string2);
                if (level == null) {
                    return 0;
                }
                n = level.getIntValue();
                continue;
            }
            if (string2.charAt(0) == '+') {
                n3 = 1;
                continue;
            }
            if (string2.charAt(0) == '-') {
                n3 = 2;
                continue;
            }
            if (!Character.isSpaceChar(string2.charAt(0))) continue;
        }
        if (n != 0) {
            if (n2 != 0 && n3 != 0) {
                switch (n3) {
                    case 1: {
                        return n + n2;
                    }
                    case 2: {
                        return n - n2;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            return n;
        }
        if (n2 != 0) {
            return n2;
        }
        return 0;
    }

    public int getIntValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean isComparableWith(Level level) {
        return level instanceof LevelImpl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "(name=" + this.name + ", val=" + this.value + ", sval=" + this.stringValue + ")";
    }
}

