/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.util.Enumeration;
import java.util.Hashtable;
import org.enhydra.jdbc.core.JdbcThreadFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.PoolHelper;
import org.enhydra.jdbc.pool.PoolKeeper;
import org.enhydra.jdbc.util.Logger;

public class GenericPool {
    private long lifeTime;
    private Hashtable locked;
    private Hashtable unlocked;
    private JdbcThreadFactory threadFactory = null;
    private int minSize;
    private int maxSize;
    private PoolHelper poolHelper;
    private int count;
    private boolean gc;
    private boolean debug;
    private long deadLockMaxWait;
    private long deadLockRetryWait;
    private Logger log;
    private int checkLevelObject;
    protected Thread keeper;
    protected PoolKeeper poolKeeper;
    private long sleepTime;
    protected int generation = 1;
    public static final long DEFAULT_EXPIRATION = 600000L;
    public static final long DEFAULT_SLEEPTIME = 300000L;
    public static final int DEFAULT_MINSIZE = 2;
    public static final int DEFAULT_MAXSIZE = 50;
    public static final int DEFAULT_DEADLOCKMAXWAIT = 300000;
    public static final int DEFAULT_DEADLOCKRETRYWAIT = 10000;

    public GenericPool(PoolHelper helper) {
        this(helper, 2, 50, 600000L, 300000L);
    }

    public GenericPool(PoolHelper helper, int initSize) {
        this(helper, 2, initSize, 600000L, 300000L);
    }

    public GenericPool(PoolHelper helper, int minSize, int maxSize, long lifeTime, long sleepTime) {
        this.lifeTime = lifeTime;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.poolHelper = helper;
        this.sleepTime = sleepTime;
        this.checkLevelObject = 0;
        this.deadLockMaxWait = 300000L;
        this.deadLockRetryWait = 10000L;
    }

    public synchronized void start() {
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
        this.count = 0;
        this.gc = false;
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.minSize) {
            try {
                GenerationObject genObject = this.poolHelper.create();
                this.unlocked.put(genObject, new Long(now));
            }
            catch (Exception e) {
                this.log.error("Error Exception in GenericPool:start");
            }
            ++this.count;
            ++i;
        }
        if (this.threadFactory != null) {
            try {
                this.poolKeeper = new PoolKeeper(this.sleepTime, this);
                this.keeper = this.threadFactory.getThread(this.poolKeeper);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage());
            }
        } else {
            this.keeper = new Thread(new PoolKeeper(this.sleepTime, this));
        }
        this.keeper.start();
        this.log.debug("GenericPool:start pool started");
    }

    public synchronized boolean checkOwner(GenerationObject genObject, String user, String password) {
        return this.equals(user, genObject.getUser()) && this.equals(password, genObject.getPassword());
    }

    JdbcThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    void setThreadFactory(JdbcThreadFactory tf) {
        this.threadFactory = tf;
    }

    private boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object checkOut(String user, String password) throws Exception {
        this.log.debug("GenericPool:checkOut an object");
        long now = System.currentTimeMillis();
        if (this.getUnlockedObjectCount() > 0) {
            Object realObject;
            GenerationObject o;
            Enumeration e;
            if (this.checkLevelObject == 3 || this.checkLevelObject == 4) {
                e = this.unlocked.keys();
                while (e.hasMoreElements()) {
                    o = (GenerationObject)e.nextElement();
                    realObject = o.getObj();
                    if ((this.checkLevelObject != 3 || this.poolHelper.checkThisObject(realObject)) && (this.checkLevelObject != 4 || this.poolHelper.testThisObject(realObject))) continue;
                    this.log.debug("GenericPool:checkOut remove object checkLevelObject=" + this.checkLevelObject);
                    this.removeUnlockedObject(o);
                    this.minimumObject();
                }
            }
            e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                o = (GenerationObject)e.nextElement();
                realObject = o.getObj();
                if (now - (Long)this.unlocked.get(o) > this.lifeTime) {
                    this.removeUnlockedObject(o);
                    this.minimumObject();
                    continue;
                }
                if (!this.checkOwner(o, user, password)) continue;
                if (this.checkLevelObject == 0 || this.checkLevelObject == 1 && this.poolHelper.checkThisObject(realObject) || this.checkLevelObject == 2 && this.poolHelper.testThisObject(realObject)) {
                    this.unlocked.remove(o);
                    this.locked.put(o, new Long(now));
                    this.notifyAll();
                    this.log.debug("GenericPool:checkOut return an object (after verification if needed)");
                    return o.getObj();
                }
                this.log.debug("GenericPool:checkOut kill an object from the pool");
                this.removeUnlockedObject(o);
                this.minimumObject(user, password);
            }
        }
        int currentWait = 0;
        while (this.count >= this.maxSize && (long)currentWait < this.getDeadLockMaxWait()) {
            this.log.info("GenericPool:checkOut waiting for an object");
            try {
                GenericPool genericPool = this;
                synchronized (genericPool) {
                    this.wait(this.getDeadLockRetryWait());
                }
            }
            catch (InterruptedException excp) {
                this.log.error("GenericPool:checkOut ERROR Failed while waiting for an object: " + excp);
            }
            currentWait = (int)((long)currentWait + this.getDeadLockRetryWait());
        }
        if (this.count >= this.maxSize) {
            throw new Exception("GenericPool:checkOut ERROR  impossible to obtain a new object from the pool");
        }
        if (this.count < this.maxSize) {
            this.log.debug("GenericPool:checkOut no objects available, create a new one");
            try {
                GenerationObject genObject = this.poolHelper.create(user, password);
                this.locked.put(genObject, new Long(now));
                ++this.count;
                this.notifyAll();
                return genObject.getObj();
            }
            catch (Exception excp) {
                this.log.error("GenericPool:checkOut Error Exception in GenericPool:checkOut");
                throw excp;
            }
        }
        return null;
    }

    public synchronized void minimumObject() {
        this.minimumObject(null, null);
    }

    public synchronized void minimumObject(String user, String password) {
        this.log.debug("GenericPool:minimumObject create object if there are less than minSize objects in the pool count =" + this.count);
        if (this.count < this.minSize && this.unlocked != null) {
            long now = System.currentTimeMillis();
            int i = this.count;
            while (i < this.minSize) {
                try {
                    GenerationObject genObject = user != null && password != null ? this.poolHelper.create() : this.poolHelper.create(user, password);
                    this.unlocked.put(genObject, new Long(now));
                }
                catch (Exception e) {
                    this.log.error("GenericPool:minimumObject Error Exception in GenericPool:minimumObject");
                }
                ++i;
            }
            this.count = this.minSize;
        }
    }

    public synchronized void checkIn(Object o) {
        this.log.debug("GenericPool:checkIn return an object to the pool");
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject obj = (GenerationObject)enumeration.nextElement();
            if (!obj.getObj().equals(o)) continue;
            this.locked.remove(obj);
            int genObj = obj.getGeneration();
            if (this.generation > genObj) {
                if (this.poolHelper.checkThisObject(obj.getObj())) continue;
                this.removeUnlockedObject(obj);
                continue;
            }
            this.unlocked.put(obj, new Long(System.currentTimeMillis()));
            this.notifyAll();
        }
        if (this.count > this.maxSize) {
            this.log.info("GenericPool:checkIn more than maxSize object in the pool");
            enum = this.unlocked.keys();
            int i = this.maxSize;
            while (i < this.count) {
                if (this.getUnlockedObjectCount() > 0) {
                    GenerationObject obj = (GenerationObject)enum.nextElement();
                    this.removeUnlockedObject(obj);
                }
                ++i;
            }
            this.count = this.getUnlockedObjectCount() + this.getLockedObjectCount();
            if (this.count > this.maxSize) {
                this.log.warn("GenericPool:checkIn Be careful, the maximum size of the pool does not correspond to your data. When objects will be check in, the pool will decrease");
            }
        }
    }

    private synchronized void removeUnlockedObject(GenerationObject obj) {
        --this.count;
        this.unlocked.remove(obj);
        this.poolHelper.expire(obj.getObj());
        obj.killObject();
        obj = null;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public synchronized void setMinSize(int min) throws Exception {
        if (min < 0) {
            throw new Exception("GenericPool:setMinSize Minimum size of the pool can't be lesser than 0");
        }
        if (min > this.maxSize) {
            throw new Exception("GenericPool:setMinSize Minimum size of the pool can't be greater than the maxSize (" + this.maxSize + ")");
        }
        this.minSize = min;
        this.minimumObject();
    }

    public synchronized void setMaxSize(int max) throws Exception {
        if (max < 0) {
            throw new Exception("GenericPool:setMaxSize Maximum size of the pool can't be lesser than 0");
        }
        if (max < this.minSize) {
            throw new Exception("GenericPool:setMaxSize Maximum size of the pool can't be lesser than the minSize (" + this.minSize + ")");
        }
        this.maxSize = max;
        if (this.count > max) {
            this.log.info("GenericPool:setMaxSize pool has more than max element");
            Enumeration enumeration = this.unlocked.keys();
            int i = max;
            while (i < this.count) {
                if (this.getUnlockedObjectCount() > 0) {
                    GenerationObject o = (GenerationObject)enumeration.nextElement();
                    this.removeUnlockedObject(o);
                }
                ++i;
            }
            this.count = this.getUnlockedObjectCount() + this.getLockedObjectCount();
            if (this.count > max) {
                this.log.warn("GenericPool:setMaxSize Be careful, the maximum size of the pool does not correspond to your data. When objects will be check in, the pool will decrease");
            }
        }
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
        this.log.debug("GenericPool:setGeneration Be careful, it is very dangerous to change the generation number, many objects could be destroyed");
    }

    public void setGC(boolean gc) {
        this.gc = gc;
    }

    public void setCheckLevelObject(int level) {
        if (level > 0 && level <= 4) {
            this.checkLevelObject = level;
        }
    }

    public void setDeadLockMaxWait(long deadLock) {
        this.deadLockMaxWait = deadLock;
    }

    public void setDeadLockRetryWait(long deadLockRetryWait) {
        this.deadLockRetryWait = deadLockRetryWait;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public boolean isGC() {
        return this.gc;
    }

    public int getCount() {
        return this.count;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getCheckLevelObject() {
        return this.checkLevelObject;
    }

    public void stop() {
        this.log.debug("GenericPool:stop start to stop the pool");
        if (this.getLockedObjectCount() != 0 || this.getUnlockedObjectCount() != 0) {
            this.expireAll();
            if (this.poolKeeper != null) {
                this.poolKeeper.stop();
            }
            this.keeper.interrupt();
            this.locked.clear();
            this.unlocked.clear();
            this.locked = null;
            this.unlocked = null;
            this.count = 0;
        }
        this.log.debug("GenericPool:stop pool stopped");
    }

    public int getLockedObjectCount() {
        if (this.locked != null) {
            return this.locked.size();
        }
        return 0;
    }

    public int getUnlockedObjectCount() {
        if (this.unlocked != null) {
            return this.unlocked.size();
        }
        return 0;
    }

    public long getDeadLockMaxWait() {
        return this.deadLockMaxWait;
    }

    public long getDeadLockRetryWait() {
        return this.deadLockRetryWait;
    }

    public String toString() {
        return "GenericPool:Pool information : \n   num of element = " + this.count + "\n   minsize = " + this.minSize + "\n   maxsize = " + this.maxSize + "\n   lifeTime = " + this.lifeTime + " (ms)" + "\n   generation = " + this.generation + "\n   size of locked table = " + this.getLockedObjectCount() + "\n   size of unlocked table = " + this.getUnlockedObjectCount() + "\n   time to wait before deadlock = " + this.getDeadLockMaxWait() + " (ms)" + "\n   number of wait loop = " + this.getDeadLockRetryWait() + "\n";
    }

    protected synchronized void cleanUp() {
        if (this.unlocked == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Enumeration enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enumeration.nextElement();
            long lasttouch = (Long)this.unlocked.get(o);
            if (now - lasttouch <= this.lifeTime) continue;
            this.log.debug("GenericPool:cleanUp clean up the pool");
            this.removeUnlockedObject(o);
        }
        if (this.isGC()) {
            System.gc();
        }
        if (this.count < this.minSize) {
            this.log.info("GenericPool:cleanUp less than minSize objects in the pool");
            int i = this.count;
            while (i < this.minSize) {
                try {
                    GenerationObject genObject = this.poolHelper.create();
                    this.unlocked.put(genObject, new Long(now));
                }
                catch (Exception e) {
                    this.log.error("GenericPool:cleanUp Error Exception in GenericPool:cleanUp");
                }
                ++this.count;
                this.notifyAll();
                ++i;
            }
        }
    }

    void expireAll() {
        this.log.debug("GenericPool:expireAll close all object in the unlocked and locked structures");
        Enumeration enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enumeration.nextElement();
            this.poolHelper.expire(o.getObj());
            o.killObject();
            o = null;
        }
        enum = this.locked.keys();
        while (enum.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enum.nextElement();
            this.poolHelper.expire(o.getObj());
            o.killObject();
            Object var3_3 = null;
        }
    }

    public void nextGeneration(Object obj) {
        this.log.debug("GenericPool:nextGeneration");
        int genObj = 0;
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enumeration.nextElement();
            if (!o.getObj().equals(obj)) continue;
            genObj = o.getGeneration();
        }
        enum = this.unlocked.keys();
        while (enum.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enum.nextElement();
            if (o.getGeneration() > genObj || this.poolHelper.checkThisObject(o.getObj())) continue;
            this.removeUnlockedObject(o);
        }
        ++this.generation;
    }

    public synchronized void removeLockedObject(Object obj) {
        this.log.debug("GenericPool:removeObject remove an object");
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enumeration.nextElement();
            if (!o.getObj().equals(obj)) continue;
            this.locked.remove(o);
            --this.count;
            o.killObject();
            Object var3_3 = null;
        }
    }

    public void setLogger(Logger alog) {
        this.log = alog;
    }
}

