/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.standard.StandardConnectionHandle;
import org.enhydra.jdbc.standard.StandardXACallableStatement;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXAPreparedStatement;
import org.enhydra.jdbc.standard.StandardXAStatement;

public class StandardXAConnectionHandle
extends StandardConnectionHandle {
    boolean globalTransaction;
    public TransactionManager transactionManager;
    public Transaction tx;
    public StandardXAConnection xacon;
    public boolean thisAutoCommit = true;

    public StandardXAConnectionHandle(StandardXAConnection pooledCon, Hashtable preparedStatementCache, int preparedStmtCacheSize, TransactionManager tm) {
        super(pooledCon, preparedStatementCache, preparedStmtCacheSize);
        this.xacon = pooledCon;
        this.transactionManager = tm;
        this.log = pooledCon.dataSource.log;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.transactionManager = tm;
    }

    public synchronized void close() throws SQLException {
        Transaction ttx = this.tx;
        super.close();
        this.log.debug("StandardXAConnectionHandle:close");
        this.log.debug("StandardXAConnectionHandle:close globalTransaction='" + this.globalTransaction + "' con.getAutoCommit='" + this.con.getAutoCommit() + "' ttx='" + ttx + "'");
        if (!this.con.getAutoCommit() && ttx == null) {
            this.log.debug("StandardXAConnectionHandle:close rollback the connection");
            this.con.rollback();
        } else {
            this.log.debug("StandardXAConnectionHandle:close do nothing else");
        }
    }

    void setGlobalTransaction(boolean setting) throws SQLException {
        this.log.debug("StandardXAConnectionHandle:setGlobalTransaction gTransaction='" + setting + "'");
        this.globalTransaction = setting;
        this.con = this.pooledCon.getPhysicalConnection();
        if (this.con == null) {
            this.log.warn("StandardXAConnectionHandle:setGlobalTransaction con is null before setupPreparedStatementCache");
        } else {
            this.log.debug("StandardXAConnectionHandle:setGlobalTransaction con is *NOT* null before setupPreparedStatementCache");
        }
        super.setAutoCommit(!setting);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:setAutoCommit This connection is part of a global transaction");
        }
        super.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:commit:This connection is part of a global transaction");
        }
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:rollback:This connection is part of a global transaction");
        }
        super.rollback();
    }

    synchronized PreparedStatement checkPreparedCache(String sql, int type, int concurrency, Object lookupKey) throws SQLException {
        PreparedStatement ret = null;
        if (this.preparedStatementCache != null) {
            Object obj = this.preparedStatementCache.get(lookupKey);
            if (obj != null) {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is found");
                ret = (PreparedStatement)obj;
                try {
                    ret.clearParameters();
                }
                catch (SQLException e) {
                    ret = this.createPreparedStatement(sql, type, concurrency);
                }
                this.preparedStatementCache.remove(lookupKey);
                this.inUse.put(lookupKey, ret);
            } else {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is *NOT* found");
                ret = this.createPreparedStatement(sql, type, concurrency);
                this.inUse.put(lookupKey, ret);
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:checkPreparedCache object the cache is out");
            ret = this.createPreparedStatement(sql, type, concurrency);
        }
        this.log.debug("StandardXAConnectionHandle:checkPreparedCache pstmt='" + ret.toString() + "'");
        return ret;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        block7: {
            if (this.tx == null) {
                this.log.debug("StandardXAConnectionHandle:prepareStatement tx==null");
                try {
                    try {
                        Transaction ntx;
                        Transaction transaction = ntx = this.transactionManager != null ? this.transactionManager.getTransaction() : null;
                        if (ntx == null) break block7;
                        this.tx = ntx;
                        this.thisAutoCommit = this.getAutoCommit();
                        this.setAutoCommit(false);
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                            break block7;
                        }
                        catch (RollbackException n) {
                            n.printStackTrace();
                            throw new SQLException("StandardXAConnectionHandle:prepareStatemnet enlistResource exception");
                        }
                    }
                    catch (SystemException n) {
                        n.printStackTrace();
                        throw new SQLException("StandardXAConnectionHandle:prepareStatement getTransaction exception: " + n.toString());
                    }
                }
                catch (NullPointerException n) {
                    n.printStackTrace();
                    throw new SQLException("StandardXAConnectionHandle:prepareStatement should not be used outside an EJBServer");
                }
            }
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx!=null");
        }
        return new StandardXAPreparedStatement(this, sql, 0, 0);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StandardXAPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StandardXACallableStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new StandardXACallableStatement(this, sql, 0, 0);
    }

    public Statement createStatement() throws SQLException {
        block7: {
            if (this.tx == null) {
                this.log.debug("StandardXAConnectionHandle:createStatement tx==null");
                try {
                    try {
                        Transaction ntx;
                        Transaction transaction = ntx = this.transactionManager != null ? this.transactionManager.getTransaction() : null;
                        if (ntx == null) break block7;
                        this.tx = ntx;
                        this.setAutoCommit(false);
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException n) {
                            throw new SQLException("StandardXAConnectionHandle:createStatement enlistResource exception: " + n.toString());
                        }
                    }
                    catch (SystemException n) {
                        throw new SQLException("StandardXAConnectionHandle:createStatement getTransaction exception: " + n.toString());
                    }
                }
                catch (NullPointerException n) {
                    throw new SQLException("StandardXAConnectionHandle:createStatement should not be used outside an EJBServer: " + n.toString());
                }
            }
        }
        return new StandardXAStatement(this, 0, 0);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StandardXAStatement(this, resultSetType, resultSetConcurrency);
    }
}

