/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.enhydra.jdbc.core.CoreStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXAStatement
extends CoreStatement {
    private StandardXAConnectionHandle con;
    private boolean closed;
    private int resultSetType;
    private int resultSetConcurrency;

    StandardXAStatement(StandardXAConnectionHandle con, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.con = con;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.log = con.log;
        this.statement = this.newStatement();
    }

    private Statement newStatement() throws SQLException {
        if (this.resultSetType == 0 && this.resultSetConcurrency == 0) {
            return this.con.con.createStatement();
        }
        return this.con.con.createStatement(this.resultSetType, this.resultSetConcurrency);
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.closed = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void preInvoke() throws SQLException {
        block8: {
            this.log.warn("** StandardXAStatement:preInvoke this methodis no longer used!!! **");
            if (this.closed) {
                throw new SQLException("StandardXAStatement:preinvoke Prepare Statement is closed");
            }
            Transaction ntx = null;
            if (this.con.tx == null) {
                try {
                    try {
                        Transaction transaction = ntx = this.con.transactionManager != null ? this.con.transactionManager.getTransaction() : null;
                        if (ntx == null) break block8;
                        this.con.tx = ntx;
                        this.con.setAutoCommit(false);
                        if (this.statement != null) {
                            this.statement.close();
                            this.statement = null;
                        }
                        break block8;
                    }
                    catch (SystemException n) {
                        throw new SQLException("StandardXAStatement:preInvoke getTransaction exception: " + n.toString());
                    }
                }
                catch (NullPointerException n) {
                    throw new SQLException("StandardXAStatement:preInvoke should not be used outside an EJBServer: " + n.toString());
                }
            }
            System.out.println("XAs: con.tx is not null=" + this.con.tx.toString());
        }
        if (this.statement == null) {
            this.statement = this.newStatement();
        }
    }

    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

