/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.Trace;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.management.loading.MLet;

public final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private final Vector loaders = new Vector(10);
    private final Hashtable search = new Hashtable(10);
    private final Hashtable loadersWithNames = new Hashtable(10);
    private static final String dbgTag = "ClassLoaderRepositorySupport";

    public final Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass((Vector)this.loaders.clone(), string);
    }

    public final Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("loadClassWithout", string + "\twithout " + classLoader);
        }
        Vector vector = (Vector)this.loaders.clone();
        if (classLoader == null) {
            return this.loadClass(vector, string);
        }
        vector.removeElement(classLoader);
        this.startValidSearch(classLoader, string);
        try {
            Class clazz = this.loadClass(vector, string);
            Object var6_5 = null;
            this.stopValidSearch(classLoader, string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.stopValidSearch(classLoader, string);
            throw throwable;
        }
    }

    private final Class loadClass(Vector vector, String string) throws ClassNotFoundException {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            try {
                ClassLoader classLoader = (ClassLoader)iterator.next();
                if (ClassLoaderRepositorySupport.isTraceOn()) {
                    ClassLoaderRepositorySupport.trace("loadClass", "trying loader = " + classLoader);
                }
                if (classLoader instanceof MLet) {
                    return ((MLet)classLoader).loadClass(string, null);
                }
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(string);
    }

    private final synchronized void startValidSearch(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Vector<ClassLoader> vector = (Vector<ClassLoader>)this.search.get(string);
        if (vector != null && vector.contains(classLoader)) {
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("startValidSearch", "already requested loader=" + classLoader + " class= " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (vector == null) {
            vector = new Vector<ClassLoader>(1);
            this.search.put(string, vector);
        }
        vector.addElement(classLoader);
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("startValidSearch", "loader=" + classLoader + " class= " + string);
        }
    }

    private final synchronized void stopValidSearch(ClassLoader classLoader, String string) {
        Vector vector = (Vector)this.search.get(string);
        if (vector != null) {
            vector.removeElement(classLoader);
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("stopValidSearch", "loader=" + classLoader + " class= " + string);
            }
        }
    }

    public final void addClassLoader(ClassLoader classLoader) {
        this.loaders.addElement(classLoader);
    }

    public final void removeClassLoader(ClassLoader classLoader) {
        this.loaders.removeElement(classLoader);
    }

    public final void addClassLoader(ObjectName objectName, ClassLoader classLoader) {
        this.loadersWithNames.put(objectName, classLoader);
        this.addClassLoader(classLoader);
    }

    public final void removeClassLoader(ObjectName objectName) {
        ClassLoader classLoader = (ClassLoader)this.loadersWithNames.remove(objectName);
        this.removeClassLoader(classLoader);
    }

    public final ClassLoader getClassLoader(ObjectName objectName) {
        return (ClassLoader)this.loadersWithNames.get(objectName);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        ClassLoaderRepositorySupport.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        ClassLoaderRepositorySupport.debug(dbgTag, string, string2);
    }
}

