/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.MBeanAccessor;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MBeanServerNotificationListener;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.NamedObject;
import com.sun.jdmk.Repository;
import com.sun.jdmk.RepositorySupport;
import com.sun.jdmk.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class DefaultMBeanAccessor
implements MBeanAccessor {
    private transient MBeanInstantiator instantiator = null;
    private transient MBeanServer server = null;
    private transient MetaData meta = null;
    private transient Repository repository = null;
    private String domain = null;
    private boolean queryByRepo;
    private transient ArrayList listenerList = new ArrayList();
    private int sequenceNumber = 0;
    private static final String dbgTag = "DefaultMBeanAccessor";

    public DefaultMBeanAccessor(MBeanServer mBeanServer) {
        this.initialize(mBeanServer, ((MBeanServerInt)((Object)mBeanServer)).getMetaData(), ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator(), null, null);
    }

    public DefaultMBeanAccessor(MBeanServer mBeanServer, String string) {
        this.initialize(mBeanServer, ((MBeanServerInt)((Object)mBeanServer)).getMetaData(), ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator(), string, null);
    }

    public DefaultMBeanAccessor(MBeanServer mBeanServer, String string, Repository repository) {
        this.initialize(mBeanServer, ((MBeanServerInt)((Object)mBeanServer)).getMetaData(), ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator(), string, repository);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(string, objectName, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectName objectName2 = objectName;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name->" + objectName.toString());
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured during MBean creation");
        }
        String string2 = "null";
        if (objectName != null) {
            string2 = objectName.toString();
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace(dbgTag, "createMBean", "ClassName = " + string + ",ObjectName = " + string2);
        }
        Class clazz = this.instantiator.findClassWithDefaultLoaderRepository(string);
        this.instantiator.testCreation(clazz);
        this.meta.testCompliance(clazz);
        Object object = this.instantiator.instantiate(clazz, objectArray, stringArray, this.getClass().getClassLoader());
        ObjectName objectName3 = this.registerCreatedObject(object, objectName);
        return this.makeObjectInstance(string, object, objectName3);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Class clazz;
        Object object;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name->" + objectName.toString());
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured during MBean registration");
        }
        if (objectName2 == null) {
            object = "null";
            if (objectName != null) {
                object = objectName.toString();
            }
            if (DefaultMBeanAccessor.isTraceOn()) {
                DefaultMBeanAccessor.trace(dbgTag, "createMBean", "ClassName = " + string + ",ObjectName = " + (String)object + " Loader name = null");
            }
            clazz = this.instantiator.findClass(string, this.getClass().getClassLoader());
        } else {
            object = "null";
            if (objectName != null) {
                object = objectName.toString();
            }
            if (DefaultMBeanAccessor.isTraceOn()) {
                DefaultMBeanAccessor.trace(dbgTag, "createMBean", "ClassName = " + string + ",ObjectName = " + (String)object + ",Loader name = " + objectName2.toString());
            }
            clazz = this.instantiator.findClass(string, objectName2);
        }
        this.instantiator.testCreation(clazz);
        this.meta.testCompliance(clazz);
        object = this.instantiator.instantiate(clazz, objectArray, stringArray, this.getClass().getClassLoader());
        ObjectName objectName3 = this.registerCreatedObject(object, objectName);
        return this.makeObjectInstance(string, object, objectName3);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName objectName2 = objectName;
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        this.meta.testCompliance(clazz);
        ObjectName objectName3 = this.registerObject(object, objectName);
        return this.makeObjectInstance(string, object, objectName3);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to unregister the MBean");
        }
        DefaultMBeanAccessor defaultMBeanAccessor = this;
        synchronized (defaultMBeanAccessor) {
            ModifiableClassLoaderRepository modifiableClassLoaderRepository;
            Object object = this.repository.retrieve(objectName);
            if (object == null) {
                if (DefaultMBeanAccessor.isTraceOn()) {
                    DefaultMBeanAccessor.trace("unregisterMBean", objectName + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            if (object instanceof MBeanRegistration) {
                this.meta.preDeregisterInvoker(object);
            }
            this.repository.remove(objectName);
            if (DefaultMBeanAccessor.isTraceOn()) {
                DefaultMBeanAccessor.trace("unregisterMBean", "Send delete notification of object " + objectName.getCanonicalName());
            }
            this.sendNotification("JMX.mbean.unregistered", objectName);
            if (object instanceof MBeanRegistration) {
                this.meta.postDeregisterInvoker(object);
            }
            if (object instanceof ClassLoader && (modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository()) != null) {
                modifiableClassLoaderRepository.removeClassLoader(objectName);
            }
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        String string;
        Object object = this.getMBean(objectName);
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            DefaultMBeanAccessor.debugX("getObjectInstance", introspectionException);
            throw new JMRuntimeException("Can't obtain class name for " + objectName + ": " + introspectionException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            DefaultMBeanAccessor.debugX("getObjectInstance", notCompliantMBeanException);
            throw new JMRuntimeException("Can't obtain class name for " + objectName + ": " + notCompliantMBeanException);
        }
        return new ObjectInstance(objectName, string);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set set = new HashSet();
        DefaultMBeanAccessor defaultMBeanAccessor = this;
        synchronized (defaultMBeanAccessor) {
            set = this.repository.query(objectName, queryExp);
        }
        if (this.queryByRepo) {
            return set;
        }
        return this.filterListOfObjects(set, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        Set set = this.queryMBeans(objectName, queryExp);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(objectInstance.getObjectName());
        }
        return hashSet;
    }

    public boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        DefaultMBeanAccessor defaultMBeanAccessor = this;
        synchronized (defaultMBeanAccessor) {
            boolean bl = this.repository.contains(objectName);
            return bl;
        }
    }

    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("getAttribute", "Attribute= " + string + ", obj= " + objectName);
        }
        Object object = this.getMBean(objectName);
        return this.meta.getAttribute(object, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (stringArray.length == 0) {
            return new AttributeList(0);
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("getAttributes", "Object= " + objectName);
        }
        Object object = this.getMBean(objectName);
        return this.meta.getAttributes(object, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("setAttribute", "Object= " + objectName + ", attribute=" + attribute.getName());
        }
        Object object = this.getMBean(objectName);
        Object object2 = this.meta.setAttribute(object, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attributeList.isEmpty()) {
            return attributeList;
        }
        Object object = this.getMBean(objectName);
        return this.meta.setAttributes(object, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object = this.getMBean(objectName);
        return this.meta.invoke(object, string, objectArray, stringArray);
    }

    protected MetaData meta() {
        return this.meta;
    }

    protected ObjectInstance makeObjectInstance(String string, Object object, ObjectName objectName) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            try {
                string = this.meta.getMBeanClassName(object);
            }
            catch (IntrospectionException introspectionException) {
                DefaultMBeanAccessor.debugX("makeObjectInstance", introspectionException);
                throw new NotCompliantMBeanException("Can't obtain class name for " + objectName + ": " + introspectionException);
            }
            catch (JMRuntimeException jMRuntimeException) {
                DefaultMBeanAccessor.debugX("makeObjectInstance", jMRuntimeException);
                throw new NotCompliantMBeanException("Can't obtain class name for " + objectName + ": " + jMRuntimeException);
            }
        }
        if (string == null) {
            throw new NotCompliantMBeanException("The class Name returned is null");
        }
        return new ObjectInstance(objectName, string);
    }

    protected ObjectName registerObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName objectName2 = objectName;
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to register the MBean");
        }
        String string = "null";
        if (objectName != null) {
            string = objectName.toString();
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace(dbgTag, "registerMBean", "ObjectName = " + string);
        }
        Object var5_6 = null;
        if (object instanceof MBeanRegistration) {
            objectName2 = this.meta.preRegisterInvoker(object, objectName, this.server);
        }
        if (objectName2 == null) {
            if (object instanceof MBeanRegistration) {
                this.meta.postRegisterInvoker(object, false);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No object name specified");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to register the MBean");
        }
        this.internal_addObject(object, objectName2);
        if (object instanceof MBeanRegistration) {
            this.meta.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository();
            if (modifiableClassLoaderRepository == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
                throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to register the MBean as a class loader");
            }
            modifiableClassLoaderRepository.addClassLoader(objectName2, (ClassLoader)object);
        }
        return objectName2;
    }

    protected ObjectName registerCreatedObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        return this.registerObject(object, objectName);
    }

    private Object getMBean(ObjectName objectName) throws InstanceNotFoundException {
        block9: {
            if (objectName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to get an MBean");
            }
            if (objectName.getDomain().equals("")) {
                try {
                    objectName = new ObjectName(this.domain + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!DefaultMBeanAccessor.isDebugOn()) break block9;
                    DefaultMBeanAccessor.debug("getMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        Object object = null;
        DefaultMBeanAccessor defaultMBeanAccessor = this;
        synchronized (defaultMBeanAccessor) {
            object = this.repository.retrieve(objectName);
            if (object == null) {
                if (DefaultMBeanAccessor.isTraceOn()) {
                    DefaultMBeanAccessor.trace("getMBean", objectName + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
        }
        return object;
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("addNotificationListener", "obj= " + objectName);
        }
        Object object2 = this.getMBean(objectName);
        NotificationBroadcaster notificationBroadcaster = null;
        if (!(object2 instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        notificationBroadcaster = (NotificationBroadcaster)object2;
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        MBeanServerNotificationListener mBeanServerNotificationListener = this.getListener(objectName, notificationListener);
        if (mBeanServerNotificationListener != null) {
            mBeanServerNotificationListener.filter = notificationFilter;
            mBeanServerNotificationListener.handback = object;
        } else {
            mBeanServerNotificationListener = new MBeanServerNotificationListener(notificationListener, notificationFilter, object, objectName, this);
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(mBeanServerNotificationListener);
            }
        }
        notificationBroadcaster.addNotificationListener(mBeanServerNotificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2 = this.getMBean(objectName2);
        if (!(object2 instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName2.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("addNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("removeNotificationListener", "obj= " + objectName);
        }
        Object object = this.getMBean(objectName);
        NotificationBroadcaster notificationBroadcaster = null;
        if (!(object instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        notificationBroadcaster = (NotificationBroadcaster)object;
        MBeanServerNotificationListener mBeanServerNotificationListener = this.getListener(objectName, notificationListener);
        if (mBeanServerNotificationListener == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        try {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                int n = this.listenerList.indexOf(mBeanServerNotificationListener);
                this.listenerList.remove(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        notificationBroadcaster.removeNotificationListener(mBeanServerNotificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object;
        try {
            object = this.getMBean(objectName2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ListenerNotFoundException(instanceNotFoundException.getMessage());
        }
        if (!(object instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("removeNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.removeNotificationListener(objectName, (NotificationListener)object);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object object = this.getMBean(objectName);
        MBeanInfo mBeanInfo = this.meta.getMBeanInfo(object);
        if (mBeanInfo == null) {
            throw new JMRuntimeException("MBean " + objectName + "has no MBeanInfo");
        }
        return mBeanInfo;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        try {
            return this.meta.isInstanceOf(object, string);
        }
        catch (ReflectionException reflectionException) {
            DefaultMBeanAccessor.debugX("isInstanceOf", reflectionException);
            return false;
        }
    }

    public ClassLoader getMBeanClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        return object.getClass().getClassLoader();
    }

    private void internal_addObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        DefaultMBeanAccessor defaultMBeanAccessor = this;
        synchronized (defaultMBeanAccessor) {
            try {
                this.repository.addMBean(object, objectName);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (object instanceof MBeanRegistration) {
                    this.meta.postRegisterInvoker(object, false);
                }
                throw instanceAlreadyExistsException;
            }
        }
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("addObject", "Send create notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", objectName);
    }

    private void sendNotification(String string, ObjectName objectName) {
        ObjectName objectName2 = null;
        try {
            objectName2 = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        MBeanServerNotification mBeanServerNotification = null;
        DefaultMBeanAccessor defaultMBeanAccessor = this;
        synchronized (defaultMBeanAccessor) {
            ++this.sequenceNumber;
            if (DefaultMBeanAccessor.isTraceOn()) {
                DefaultMBeanAccessor.trace("sendNotification", "Incr sequenceNumber = " + this.sequenceNumber);
            }
            mBeanServerNotification = new MBeanServerNotification(string, (Object)objectName2, (long)this.sequenceNumber, objectName);
        }
        ((MBeanServerInt)((Object)this.server)).getMBeanServerDelegate().sendNotification(mBeanServerNotification);
    }

    private void initialize(MBeanServer mBeanServer, MetaData metaData, MBeanInstantiator mBeanInstantiator, String string, Repository repository) {
        this.server = mBeanServer;
        this.meta = metaData;
        this.instantiator = mBeanInstantiator;
        this.repository = repository;
        if (this.repository == null) {
            this.repository = new RepositorySupport();
        }
        this.domain = string == null || string.equals("") ? this.repository.getDefaultDomain() : string;
        this.repository.setDefaultDomain(this.domain);
        if (DefaultMBeanAccessor.isTraceOn()) {
            DefaultMBeanAccessor.trace("new", "Initializing domain " + this.domain);
        }
        try {
            this.queryByRepo = this.repository.isFiltering();
        }
        catch (Exception exception) {
            this.queryByRepo = false;
        }
    }

    private Set filterListOfObjects(Set set, QueryExp queryExp) {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        if (queryExp == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                NamedObject namedObject;
                block10: {
                    namedObject = (NamedObject)iterator.next();
                    Object object = namedObject.getObject();
                    string = null;
                    try {
                        string = this.meta.getMBeanClassName(object);
                    }
                    catch (JMException jMException) {
                        if (!DefaultMBeanAccessor.isDebugOn()) break block10;
                        DefaultMBeanAccessor.debug("filterListOfObjects", "Can't obtain class name for " + namedObject.getName() + ": " + jMException);
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                NamedObject namedObject;
                block11: {
                    namedObject = (NamedObject)iterator.next();
                    Object object = namedObject.getObject();
                    boolean bl = false;
                    queryExp.setMBeanServer(this.server);
                    try {
                        bl = queryExp.apply(namedObject.getName());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) continue;
                    string = null;
                    try {
                        string = this.meta.getMBeanClassName(object);
                    }
                    catch (JMException jMException) {
                        if (!DefaultMBeanAccessor.isDebugOn()) break block11;
                        DefaultMBeanAccessor.debug("filterListOfObjects", "Can't obtain class name for " + namedObject.getName() + ": " + jMException);
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        }
        return hashSet;
    }

    private MBeanServerNotificationListener getListener(ObjectName objectName, NotificationListener notificationListener) {
        MBeanServerNotificationListener mBeanServerNotificationListener = null;
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.listenerList.size()) {
                MBeanServerNotificationListener mBeanServerNotificationListener2 = (MBeanServerNotificationListener)this.listenerList.get(n);
                if (notificationListener == mBeanServerNotificationListener2.listener && objectName.equals(mBeanServerNotificationListener2.mbeanName)) {
                    mBeanServerNotificationListener = mBeanServerNotificationListener2;
                    break;
                }
                ++n;
            }
        }
        return mBeanServerNotificationListener;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        DefaultMBeanAccessor.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        DefaultMBeanAccessor.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (DefaultMBeanAccessor.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            DefaultMBeanAccessor.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            DefaultMBeanAccessor.debug(dbgTag, string, string2);
        }
    }
}

