/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.NamedObject;
import com.sun.jdmk.Repository;
import com.sun.jdmk.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

public class RepositorySupport
implements Repository {
    private final Hashtable domainTb = new Hashtable(5);
    private int nbElements = 0;
    private String domain = "DefaultDomain";
    private final String dbgTag = "Repository";

    public void setConfigParameters(ArrayList arrayList) {
    }

    public boolean isFiltering() {
        return false;
    }

    public void addMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        Hashtable hashtable;
        block11: {
            if (objectName.getDomain().equals("")) {
                try {
                    objectName = new ObjectName(this.domain + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!this.isDebugOn()) break block11;
                    this.debug("addMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("addMBean", "name=" + objectName);
        }
        if (objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: " + objectName.toString()));
        }
        String string = objectName.getDomain();
        try {
            if (!this.query(new ObjectName("JMImplementation:*"), null).isEmpty() && string.equals("JMImplementation")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        if (string.equals("")) {
            string = this.domain;
        }
        if ((hashtable = (Hashtable)this.domainTb.get(string)) == null) {
            this.addNewDomMoi(object, string, objectName);
            return;
        }
        Object v = hashtable.get(objectName);
        if (v != null) {
            throw new InstanceAlreadyExistsException(objectName.toString());
        }
        ++this.nbElements;
        hashtable.put(objectName, object);
    }

    public boolean contains(ObjectName objectName) {
        Object object;
        if (this.isTraceOn()) {
            this.trace("contains", "name=" + objectName);
        }
        return (object = this.retrieve(objectName)) != null;
    }

    public Object retrieve(ObjectName objectName) {
        Hashtable hashtable;
        if (this.isTraceOn()) {
            this.trace("retrieve", "name=" + objectName);
        }
        if (objectName.isPattern()) {
            return null;
        }
        String string = objectName.getDomain();
        if (string.equals("")) {
            string = this.domain;
        }
        if ((hashtable = (Hashtable)this.domainTb.get(string)) == null) {
            return null;
        }
        Object v = hashtable.get(objectName);
        return v;
    }

    protected final boolean matchKeys(ObjectName objectName, ObjectName objectName2) {
        Hashtable hashtable = objectName2.getKeyPropertyList();
        Hashtable hashtable2 = objectName.getKeyPropertyList();
        if (!objectName2.isPropertyPattern() && hashtable2.size() != hashtable.size()) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string).equals(hashtable2.get(string))) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private final void addAll(Hashtable hashtable, Set set) {
        if (hashtable == null || set == null) {
            return;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ObjectName objectName = (ObjectName)enumeration.nextElement();
                set.add(new NamedObject(objectName, hashtable.get(objectName)));
            }
        }
    }

    private final void addAllMatching(Hashtable hashtable, Set set, ObjectName objectName) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ObjectName objectName2 = (ObjectName)enumeration.nextElement();
                boolean bl = this.matchKeys(objectName2, objectName);
                if (!bl) continue;
                set.add(new NamedObject(objectName2, hashtable.get(objectName2)));
            }
        }
    }

    public Set query(ObjectName objectName, QueryExp queryExp) {
        ObjectName objectName2;
        HashSet<NamedObject> hashSet = new HashSet<NamedObject>();
        ObjectName objectName3 = null;
        try {
            objectName3 = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        ObjectName objectName4 = objectName2 = objectName == null ? objectName3 : objectName;
        if (!objectName2.isPattern()) {
            try {
                Object object = this.retrieve(objectName2);
                if (object != null) {
                    hashSet.add(new NamedObject(objectName2, object));
                }
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                // empty catch block
            }
            return hashSet;
        }
        if (objectName2 == objectName3 || objectName2.equals(objectName3)) {
            Hashtable hashtable = this.domainTb;
            synchronized (hashtable) {
                Enumeration enumeration = this.domainTb.elements();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable2 = (Hashtable)enumeration.nextElement();
                    this.addAll(hashtable2, hashSet);
                }
            }
            return hashSet;
        }
        if (objectName2.getDomain().equals("")) {
            Hashtable hashtable = (Hashtable)this.domainTb.get(this.domain);
            if (objectName2.getKeyPropertyListString().equals("")) {
                this.addAll(hashtable, hashSet);
            } else {
                this.addAllMatching(hashtable, hashSet, objectName);
            }
            return hashSet;
        }
        NameList nameList = this.findDomainToQuery(objectName2);
        int n = nameList.size();
        String[] stringArray = nameList.names;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Hashtable hashtable = (Hashtable)this.domainTb.get(string);
            if (hashtable != null) {
                if (objectName2.getKeyPropertyListString().equals("")) {
                    this.addAll(hashtable, hashSet);
                } else {
                    this.addAllMatching(hashtable, hashSet, objectName);
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public void remove(ObjectName objectName) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("remove", "name=" + objectName);
        }
        if (!this.contains(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        String string = objectName.getDomain();
        Hashtable hashtable = (Hashtable)this.domainTb.get(string);
        if (hashtable == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Object v = hashtable.get(objectName);
        if (v == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        hashtable.remove(objectName);
        --this.nbElements;
    }

    public Integer getCount() {
        return new Integer(this.nbElements);
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    public void setDefaultDomain(String string) {
        this.domain = string;
    }

    private final void addNewDomMoi(Object object, String string, ObjectName objectName) {
        Hashtable<ObjectName, Object> hashtable = new Hashtable<ObjectName, Object>();
        this.domainTb.put(string, hashtable);
        hashtable.put(objectName, object);
        ++this.nbElements;
    }

    private final NameList findDomainToQuery(ObjectName objectName) {
        NameList nameList;
        String string = objectName.getDomain();
        if (string.indexOf("*") != 0 || string.indexOf("?") != 0) {
            Hashtable hashtable = this.domainTb;
            synchronized (hashtable) {
                nameList = new NameList(this.domainTb.size());
                Enumeration enumeration = this.domainTb.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!RepositorySupport.wildmatch(string2, string)) continue;
                    nameList.add(string2);
                }
            }
        } else {
            nameList = new NameList(1);
            nameList.add(string);
        }
        return nameList;
    }

    private static final boolean wildmatch(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        while (n2 < n4) {
            char c;
            if ((c = string2.charAt(n2++)) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!RepositorySupport.wildmatch(string.substring(n), string2.substring(n2))) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (n < n3 && c == string.charAt(n++)) continue;
            return false;
        }
        return n == n3;
    }

    protected final Object makeNamedObject(ObjectName objectName, Object object) {
        return new NamedObject(objectName, object);
    }

    protected final Object makeNamedObject(String string, Object object) throws MalformedObjectNameException {
        return new NamedObject(string, object);
    }

    protected final ObjectName getObjectName(Object object) {
        return ((NamedObject)object).getName();
    }

    protected final Object getObject(Object object) {
        return ((NamedObject)object).getObject();
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace("Repository", string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private void debug(String string, String string2) {
        this.debug("Repository", string, string2);
    }

    private static final class NameList {
        public final String[] names;
        private int size = 0;

        NameList(int n) {
            this.names = new String[n];
            this.size = 0;
        }

        public final int size() {
            return this.size;
        }

        public final boolean add(String string) {
            this.names[this.size++] = string;
            return true;
        }
    }
}

