/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType
implements Serializable {
    static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List indexNames;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    public TabularType(String string, String string2, CompositeType compositeType, String[] stringArray) throws OpenDataException {
        super((class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = TabularType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName(), string, string2);
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument rowType cannot be null.");
        }
        TabularType.checkForNullElement(stringArray, "indexNames");
        TabularType.checkForEmptyString(stringArray, "indexNames");
        int n = 0;
        while (n < stringArray.length) {
            if (!compositeType.containsKey(stringArray[n])) {
                throw new OpenDataException("Argument's element value indexNames[" + n + "]=\"" + stringArray[n] + "\" is not a valid item name for rowType.");
            }
            ++n;
        }
        this.rowType = compositeType;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        int n2 = 0;
        while (n2 < stringArray.length) {
            arrayList.add(stringArray[n2]);
            ++n2;
        }
        this.indexNames = Collections.unmodifiableList(arrayList);
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new IllegalArgumentException("Argument's element " + string + "[" + n + "] cannot be null.");
            }
            ++n;
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].trim().equals("")) {
                throw new IllegalArgumentException("Argument's element " + string + "[" + n + "] cannot be an empty string.");
            }
            ++n;
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List getIndexNames() {
        return this.indexNames;
    }

    public boolean isValue(Object object) {
        TabularData tabularData;
        if (object == null) {
            return false;
        }
        try {
            tabularData = (TabularData)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.equals(tabularData.getTabularType());
    }

    public boolean equals(Object object) {
        TabularType tabularType;
        if (object == null) {
            return false;
        }
        try {
            tabularType = (TabularType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTypeName().equals(tabularType.getTypeName())) {
            return false;
        }
        if (!this.rowType.equals(tabularType.rowType)) {
            return false;
        }
        return this.indexNames.equals(tabularType.indexNames);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.getTypeName().hashCode();
            n += this.rowType.hashCode();
            Iterator iterator = this.indexNames.iterator();
            while (iterator.hasNext()) {
                n += iterator.next().hashCode();
            }
            this.myHashCode = new Integer(n);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer stringBuffer = new StringBuffer().append(this.getClass().getName()).append("(name=").append(this.getTypeName()).append(",rowType=").append(this.rowType.toString()).append(",indexNames=(");
            int n = 0;
            Iterator iterator = this.indexNames.iterator();
            while (iterator.hasNext()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(iterator.next().toString());
                ++n;
            }
            stringBuffer.append("))");
            this.myToString = stringBuffer.toString();
        }
        return this.myToString;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

