/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.Log;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.jdbcConnection;

class Database {
    private String sName;
    private UserManager aAccess;
    private Vector tTable;
    private DatabaseInformation dInfo;
    Logger logger;
    boolean bReadOnly;
    private boolean bShutdown;
    private Hashtable hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private Vector cSession;
    private HsqlDatabaseProperties databaseProperties;
    private Session sysSession;
    private static final int CALL = 1;
    private static final int CHECKPOINT = 2;
    private static final int COMMIT = 3;
    private static final int CONNECT = 4;
    private static final int CREATE = 5;
    private static final int DELETE = 6;
    private static final int DISCONNECT = 7;
    private static final int DROP = 8;
    private static final int GRANT = 9;
    private static final int INSERT = 10;
    private static final int REVOKE = 11;
    private static final int ROLLBACK = 12;
    private static final int SAVEPOINT = 13;
    private static final int SCRIPT = 14;
    private static final int SELECT = 15;
    private static final int SET = 16;
    private static final int SHUTDOWN = 17;
    private static final int UPDATE = 18;
    private static final int SEMICOLON = 19;
    private static final int ALTER = 20;
    private static final Hashtable hCommands = new Hashtable(37);

    Database(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.sName = string;
        this.open();
    }

    private void open() throws SQLException {
        this.tTable = new Vector();
        this.aAccess = new UserManager();
        this.cSession = new Vector();
        this.hAlias = new Hashtable();
        this.logger = new Logger();
        this.bReferentialIntegrity = true;
        Library.register(this.hAlias);
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean bl = false;
        this.sysSession = new Session(this, new User(null, null, true, null), true, false, 0);
        this.registerSession(this.sysSession);
        this.databaseProperties = new HsqlDatabaseProperties(this.sName);
        if (this.sName.equals(".")) {
            bl = true;
            this.databaseProperties.setProperty("sql.strict_fk", true);
        } else {
            bl = this.logger.openLog(this, this.sysSession, this.sName);
        }
        HsqlName.sysNumber = 0;
        Library.setSqlMonth(this.databaseProperties.isPropertyTrue("sql.month"));
        Parser.setEnforceSize(this.databaseProperties.isPropertyTrue("sql.enforce_size"));
        Column.setCompareInLocal(this.databaseProperties.isPropertyTrue("sql.compare_in_locale"));
        Record.gcFrequency = this.databaseProperties.getIntegerProperty("hsqldb.gc_interval", 0);
        if (bl) {
            this.execute("CREATE USER SA PASSWORD \"\" ADMIN", this.sysSession);
        }
        this.aAccess.grant("PUBLIC", "CLASS \"java.lang.Math\"", 15);
        this.aAccess.grant("PUBLIC", "CLASS \"org.hsqldb.Library\"", 15);
    }

    String getName() {
        return this.sName;
    }

    HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    boolean isShutdown() {
        return this.bShutdown;
    }

    synchronized Session connect(String string, String string2) throws SQLException {
        int n;
        User user = this.aAccess.getUser(string.toUpperCase(), string2.toUpperCase());
        int n2 = n = this.cSession.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.cSession.elementAt(n3) == null) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        Session session = new Session(this, user, true, this.bReadOnly, n2);
        this.logger.writeToLog(session, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
        this.registerSession(session);
        return session;
    }

    void registerSession(Session session) {
        int n = this.cSession.size();
        int n2 = session.getId();
        if (n2 >= n) {
            this.cSession.setSize(n2 + 1);
        }
        this.cSession.setElementAt(session, n2);
    }

    byte[] execute(String string, String string2, String string3) {
        Result result = null;
        try {
            Session session = this.connect(string, string2);
            result = this.execute(string3, session);
            this.execute("DISCONNECT", session);
        }
        catch (SQLException sQLException) {
            result = new Result(sQLException.getMessage(), sQLException.getErrorCode());
        }
        catch (Exception exception) {
            result = new Result(exception.getMessage(), 40);
        }
        try {
            return result.getBytes();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    synchronized Result execute(String string, Session session) {
        if (Record.gcFrequency != 0 && Record.memoryRecords > Record.gcFrequency) {
            System.gc();
            Trace.printSystemOut("gc at " + Record.memoryRecords);
            Record.memoryRecords = 0;
        }
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        Result result = null;
        try {
            Tokenizer tokenizer = new Tokenizer(string);
            Parser parser = new Parser(this, tokenizer, session);
            this.logger.cleanUp();
            Trace.check(session != null, 33);
            Trace.check(!this.bShutdown, 4);
            while (true) {
                tokenizer.setPartMarker();
                session.setScripting(false);
                String string2 = tokenizer.getString();
                if (string2.length() != 0) {
                    Integer n = (Integer)hCommands.get(string2);
                    if (n == null) {
                        throw Trace.error(11, string2);
                    }
                    int n2 = n;
                    switch (n2) {
                        case 15: {
                            result = parser.processSelect();
                            break;
                        }
                        case 10: {
                            result = parser.processInsert();
                            break;
                        }
                        case 18: {
                            result = parser.processUpdate();
                            break;
                        }
                        case 6: {
                            result = parser.processDelete();
                            break;
                        }
                        case 1: {
                            result = parser.processCall();
                            break;
                        }
                        case 16: {
                            result = this.processSet(tokenizer, session);
                            break;
                        }
                        case 3: {
                            result = this.processCommit(tokenizer, session);
                            session.setScripting(true);
                            break;
                        }
                        case 12: {
                            result = this.processRollback(tokenizer, session);
                            session.setScripting(true);
                            break;
                        }
                        case 13: {
                            result = this.processSavepoint(tokenizer, session);
                            session.setScripting(true);
                            break;
                        }
                        case 5: {
                            result = this.processCreate(tokenizer, session);
                            break;
                        }
                        case 20: {
                            result = this.processAlter(tokenizer, session);
                            break;
                        }
                        case 8: {
                            result = this.processDrop(tokenizer, session);
                            break;
                        }
                        case 9: {
                            result = this.processGrantOrRevoke(tokenizer, session, true);
                            break;
                        }
                        case 11: {
                            result = this.processGrantOrRevoke(tokenizer, session, false);
                            break;
                        }
                        case 4: {
                            result = this.processConnect(tokenizer, session);
                            break;
                        }
                        case 7: {
                            result = this.processDisconnect(session);
                            break;
                        }
                        case 14: {
                            result = this.processScript(tokenizer, session);
                            break;
                        }
                        case 17: {
                            result = this.processShutdown(tokenizer, session);
                            break;
                        }
                        case 2: {
                            result = this.processCheckpoint(session);
                            break;
                        }
                    }
                    if (!session.getScripting()) continue;
                    this.logger.writeToLog(session, tokenizer.getLastPart());
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            result = new Result(sQLException.getMessage() + " in statement [" + string + "]", sQLException.getErrorCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = Trace.getMessage(40) + " " + exception;
            result = new Result(string3 + " in statement [" + string + "]", 40);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            result = new Result("out of memory", 40);
        }
        return result == null ? new Result() : result;
    }

    void setReadOnly() {
        this.bReadOnly = true;
    }

    Vector getTables() {
        return this.tTable;
    }

    UserManager getUserManager() {
        return this.aAccess;
    }

    void setReferentialIntegrity(boolean bl) {
        this.bReferentialIntegrity = bl;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    Hashtable getAlias() {
        return this.hAlias;
    }

    String getAlias(String string) {
        String string2 = (String)this.hAlias.get(string);
        return string2 == null ? string : string2;
    }

    Table getTable(String string, Session session) throws SQLException {
        Table table = this.findUserTable(string, session);
        if (table == null) {
            table = this.dInfo.getSystemTable(string, session);
        }
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table getUserTable(String string, Session session) throws SQLException {
        Table table = this.findUserTable(string, session);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table getUserTable(String string) throws SQLException {
        Table table = this.findUserTable(string);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table findUserTable(String string) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.equals(string)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    Table findUserTable(String string, Session session) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.equals(string, session)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Session session) throws SQLException {
        return DatabaseScript.getScript(this, bl, bl2, bl3, session);
    }

    void linkTable(Table table) throws SQLException {
        this.tTable.addElement(table);
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    private Result processScript(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getString();
        if (tokenizer.wasValue()) {
            string = (String)tokenizer.getAsValue();
            Log.scriptToFile(this, string, true, session);
            return new Result();
        }
        tokenizer.back();
        return this.getScript(false, true, false, session);
    }

    private Result processCreate(Tokenizer tokenizer, Session session) throws SQLException {
        session.checkReadWrite();
        session.checkAdmin();
        String string = tokenizer.getString();
        boolean bl = false;
        if (string.equals("TEMP")) {
            bl = true;
            string = tokenizer.getString();
            Trace.check(string.equals("TABLE") || string.equals("MEMORY") || string.equals("TEXT"), 11, string);
            session.setScripting(false);
        } else {
            session.checkReadWrite();
            session.checkAdmin();
            session.setScripting(true);
        }
        if (string.equals("TABLE")) {
            int n = bl ? 1 : 2;
            this.processCreateTable(tokenizer, session, n);
        } else if (string.equals("MEMORY")) {
            tokenizer.getThis("TABLE");
            int n = bl ? 1 : 2;
            this.processCreateTable(tokenizer, session, n);
        } else if (string.equals("CACHED")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, session, 3);
        } else if (string.equals("TEXT")) {
            tokenizer.getThis("TABLE");
            int n = bl ? 4 : 5;
            this.processCreateTable(tokenizer, session, n);
        } else if (string.equals("VIEW")) {
            this.processCreateView(tokenizer, session);
        } else if (string.equals("TRIGGER")) {
            this.processCreateTrigger(tokenizer, session);
        } else if (string.equals("USER")) {
            String string2 = tokenizer.getStringToken();
            tokenizer.getThis("PASSWORD");
            String string3 = tokenizer.getStringToken();
            boolean bl2 = tokenizer.getString().equals("ADMIN");
            this.aAccess.createUser(string2, string3, bl2);
        } else if (string.equals("ALIAS")) {
            String string4 = tokenizer.getString();
            string = tokenizer.getString();
            Trace.check(string.equals("FOR"), 11, string);
            string = tokenizer.getString();
            if (string.startsWith("org.hsql.Library.")) {
                string = "org.hsqldb.Library." + string.substring("org.hsql.Library.".length());
            } else if (string.equals("java.lang.Math.abs")) {
                string = "org.hsqldb.Library.abs";
            }
            this.hAlias.put(string4, string);
        } else {
            boolean bl3 = false;
            if (string.equals("UNIQUE")) {
                bl3 = true;
                string = tokenizer.getString();
            }
            if (!string.equals("INDEX")) {
                throw Trace.error(11, string);
            }
            String string5 = tokenizer.getName();
            boolean bl4 = tokenizer.wasQuotedIdentifier();
            tokenizer.getThis("ON");
            Table table = this.getTable(tokenizer.getName(), session);
            this.addIndexOn(tokenizer, session, string5, bl4, table, bl3);
        }
        return new Result();
    }

    private int[] processColumnList(Tokenizer tokenizer, Table table) throws SQLException {
        Object object;
        Hashtable<String, String> hashtable;
        Vector<String> vector;
        block3: {
            vector = new Vector<String>();
            hashtable = new Hashtable<String, String>();
            tokenizer.getThis("(");
            do {
                String string = tokenizer.getName();
                vector.addElement(string);
                hashtable.put(string, string);
                object = tokenizer.getString();
                if (((String)object).equals(")")) break block3;
            } while (((String)object).equals(","));
            throw Trace.error(11, (String)object);
        }
        int n = vector.size();
        if (n != hashtable.size()) {
            throw Trace.error(27, "duplicate column in list");
        }
        object = new int[n];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = table.getColumnNr((String)vector.elementAt(n2));
            ++n2;
        }
        return object;
    }

    private void addIndexOn(Tokenizer tokenizer, Session session, String string, boolean bl, Table table, boolean bl2) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        HsqlName hsqlName = HsqlName.isReservedName(string) ? HsqlName.makeAutoName("USER", string) : new HsqlName(string, bl);
        if (this.findIndex(string) != null) {
            throw Trace.error(23);
        }
        session.commit();
        session.setScripting(!table.isTemp());
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.createIndex(nArray, hsqlName, bl2);
    }

    private Index findIndex(String string) {
        Table table = this.findTableForIndex(string);
        if (table == null) {
            return null;
        }
        return table.getIndex(string);
    }

    private Table findTableForIndex(String string) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.getIndex(string) != null) {
                return table;
            }
            ++n;
        }
        return null;
    }

    int getTableIndex(Table table) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table2 = (Table)this.tTable.elementAt(n);
            if (table2 == table) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger(Tokenizer tokenizer, Session session) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        int n = TriggerDef.getDefaultQueueSize();
        String string = tokenizer.getName();
        String string2 = tokenizer.getString();
        String string3 = tokenizer.getString();
        tokenizer.getThis("ON");
        String string4 = tokenizer.getString();
        Table table = this.getTable(string4, session);
        if (table.isView()) {
            throw Trace.error(55);
        }
        session.setScripting(!table.isTemp());
        String string5 = tokenizer.getString();
        if (string5.equals("FOR")) {
            string5 = tokenizer.getString();
            if (!string5.equals("EACH")) throw Trace.error(12, string5);
            string5 = tokenizer.getString();
            if (!string5.equals("ROW")) throw Trace.error(12, string5);
            bl = true;
            string5 = tokenizer.getString();
        }
        if (string5.equals("NOWAIT")) {
            bl2 = true;
            string5 = tokenizer.getString();
        }
        if (string5.equals("QUEUE")) {
            n = Integer.parseInt(tokenizer.getString());
            string5 = tokenizer.getString();
        }
        if (!string5.equals("CALL")) {
            throw Trace.error(12, string5);
        }
        String string6 = tokenizer.getString();
        try {
            Class<?> clazz = Class.forName(string6);
            Trigger trigger = (Trigger)clazz.newInstance();
            TriggerDef triggerDef = new TriggerDef(string, string2, string3, bl, table, trigger, "\"" + string6 + "\"", bl2, n);
            if (!triggerDef.isValid()) {
                String string7 = "Error in parsing trigger command ";
                throw Trace.error(11, string7);
            }
            table.addTrigger(triggerDef);
            triggerDef.start();
            return;
        }
        catch (Exception exception) {
            String string8 = "Exception in loading trigger class " + exception.getMessage();
            throw Trace.error(13, string8);
        }
    }

    private Column processCreateColumn(Tokenizer tokenizer, Table table) throws SQLException {
        String string;
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = string2 = tokenizer.getString();
        boolean bl3 = tokenizer.wasQuotedIdentifier();
        String string4 = tokenizer.getString();
        int n = Column.getTypeNr(string4);
        Trace.check(!string3.equals(""), 27, string3);
        if (string4.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
        }
        if (n == 12 && this.bIgnoreCase) {
            n = 100;
        }
        string2 = tokenizer.getString();
        if (n == 8 && string2.equals("PRECISION")) {
            string2 = tokenizer.getString();
        }
        String string5 = "";
        if (string2.equals("(")) {
            do {
                if ((string2 = tokenizer.getString()).equals(")")) continue;
                string5 = string5 + string2;
            } while (!string2.equals(")"));
            string2 = tokenizer.getString();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = string5.indexOf(",");
        if (n4 != -1) {
            string = string5.substring(n4 + 1, string5.length());
            string5 = string5.substring(0, n4);
            try {
                n3 = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        if (string5.trim().length() > 0) {
            try {
                n2 = Integer.parseInt(string5.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        string = null;
        if (string2.equals("DEFAULT")) {
            String string6 = tokenizer.getString();
            if (tokenizer.wasValue() && n != -2 && n != 1111) {
                Object object = tokenizer.getAsValue();
                if (object != null) {
                    string = String.valueOf(object);
                    try {
                        Column.convertObject(string, n);
                    }
                    catch (Exception exception) {
                        throw Trace.error(46, string);
                    }
                    String string7 = (String)Parser.enforceSize(string, n, n2, false);
                    if (!string.equals(string7)) {
                        throw Trace.error(46, string);
                    }
                }
            } else {
                throw Trace.error(46, string6);
            }
            string2 = tokenizer.getString();
        }
        boolean bl4 = true;
        if (string2.equals("NULL")) {
            string2 = tokenizer.getString();
        } else if (string2.equals("NOT")) {
            tokenizer.getThis("NULL");
            bl4 = false;
            string2 = tokenizer.getString();
        }
        if (string2.equals("IDENTITY")) {
            bl = true;
            string2 = tokenizer.getString();
            bl2 = true;
        }
        if (string2.equals("PRIMARY")) {
            tokenizer.getThis("KEY");
            bl2 = true;
        } else {
            tokenizer.back();
        }
        return new Column(new HsqlName(string3, bl3), bl4, n, n2, n3, bl, bl2, string);
    }

    private void processCreateTable(Tokenizer tokenizer, Session session, int n) throws SQLException {
        Object object;
        String string = tokenizer.getName();
        boolean bl = tokenizer.wasQuotedIdentifier();
        if (DatabaseInformation.isSystemTable(string) || this.findUserTable(string, session) != null) {
            throw Trace.error(21, string);
        }
        Table table = n == 4 || n == 5 ? new TextTable(this, new HsqlName(string, bl), n, session) : new Table(this, new HsqlName(string, bl), n, session);
        tokenizer.getThis("(");
        int[] nArray = null;
        int n2 = 0;
        boolean bl2 = false;
        while (true) {
            string = tokenizer.getString();
            bl = tokenizer.wasQuotedIdentifier();
            if (string.equals("CONSTRAINT") || string.equals("PRIMARY") || string.equals("FOREIGN") || string.equals("UNIQUE")) {
                tokenizer.back();
                bl2 = true;
                break;
            }
            tokenizer.back();
            object = this.processCreateColumn(tokenizer, table);
            table.addColumn((Column)object);
            if (((Column)object).isPrimaryKey()) {
                Trace.check(nArray == null, 24, "column " + n2);
                nArray = new int[]{n2};
            }
            if ((string = tokenizer.getString()).equals(")")) break;
            if (!string.equals(",")) {
                throw Trace.error(11, string);
            }
            ++n2;
        }
        try {
            Object object2;
            int n3;
            HsqlName hsqlName;
            TempConstraint tempConstraint;
            block21: {
                object = new Vector();
                tempConstraint = new TempConstraint(null, nArray, null, null, 1, false);
                hsqlName = null;
                ((Vector)object).addElement(tempConstraint);
                if (bl2) {
                    n3 = 0;
                    do {
                        string = tokenizer.getString();
                        HsqlName hsqlName2 = null;
                        ++n3;
                        if (string.equals("CONSTRAINT")) {
                            hsqlName2 = new HsqlName(tokenizer.getName(), tokenizer.wasQuotedIdentifier());
                            string = tokenizer.getString();
                        }
                        if (string.equals("PRIMARY")) {
                            tokenizer.getThis("KEY");
                            hsqlName = hsqlName2;
                            object2 = this.processColumnList(tokenizer, table);
                            TempConstraint tempConstraint2 = (TempConstraint)((Vector)object).elementAt(0);
                            Trace.check(tempConstraint2.localCol == null, 24);
                            tempConstraint2.localCol = object2;
                        } else if (string.equals("UNIQUE")) {
                            object2 = this.processColumnList(tokenizer, table);
                            if (hsqlName2 == null) {
                                hsqlName2 = HsqlName.makeAutoName("CT");
                            }
                            tempConstraint = new TempConstraint(hsqlName2, (int[])object2, null, null, 2, false);
                            ((Vector)object).addElement(tempConstraint);
                        } else if (string.equals("FOREIGN")) {
                            tokenizer.getThis("KEY");
                            tempConstraint = this.processCreateFK(tokenizer, session, table, hsqlName2);
                            if (tempConstraint.expCol == null) {
                                object2 = (TempConstraint)((Vector)object).elementAt(0);
                                tempConstraint.expCol = ((TempConstraint)object2).localCol;
                                if (tempConstraint.expCol == null) {
                                    throw Trace.error(26, "table has no primary key");
                                }
                            }
                            table.checkColumnsMatch(tempConstraint.localCol, tempConstraint.expTable, tempConstraint.expCol);
                            ((Vector)object).addElement(tempConstraint);
                        }
                        string = tokenizer.getString();
                        if (string.equals(")")) break block21;
                    } while (string.equals(","));
                    throw Trace.error(11, string);
                }
            }
            session.commit();
            tempConstraint = (TempConstraint)((Vector)object).elementAt(0);
            table.createPrimaryKey(hsqlName, tempConstraint.localCol);
            n3 = 0;
            int n4 = 1;
            while (n4 < ((Vector)object).size()) {
                tempConstraint = (TempConstraint)((Vector)object).elementAt(n4);
                if (tempConstraint.type == 2) {
                    object2 = new TableWorks(table);
                    ((TableWorks)object2).createUniqueConstraint(tempConstraint.localCol, tempConstraint.name);
                    table = ((TableWorks)object2).getTable();
                }
                if (tempConstraint.type == 0) {
                    object2 = new TableWorks(table);
                    ((TableWorks)object2).createForeignKey(tempConstraint.localCol, tempConstraint.expCol, tempConstraint.name, tempConstraint.expTable, tempConstraint.cascade);
                    table = ((TableWorks)object2).getTable();
                }
                ++n4;
            }
            this.linkTable(table);
        }
        catch (SQLException sQLException) {
            this.removeExportedKeys(table);
            throw sQLException;
        }
    }

    TempConstraint processCreateFK(Tokenizer tokenizer, Session session, Table table, HsqlName hsqlName) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        tokenizer.getThis("REFERENCES");
        String string = tokenizer.getString();
        Table table2 = table.equals(string) ? table : this.getTable(string, session);
        int[] nArray2 = null;
        String string2 = tokenizer.getString();
        tokenizer.back();
        if (string2.equals("(")) {
            nArray2 = this.processColumnList(tokenizer, table2);
        } else {
            Index index = table2.getPrimaryIndex();
            if (index != null && (nArray2 = index.getColumns())[0] == table2.getColumnCount()) {
                throw Trace.error(26, string + " has no primary key");
            }
        }
        string2 = tokenizer.getString();
        boolean bl = false;
        if (string2.equals("ON")) {
            tokenizer.getThis("DELETE");
            tokenizer.getThis("CASCADE");
            bl = true;
        } else {
            tokenizer.back();
        }
        if (hsqlName == null) {
            hsqlName = HsqlName.makeAutoName("FK");
        }
        return new TempConstraint(hsqlName, nArray, table2, nArray2, 0, bl);
    }

    private void processCreateView(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getName();
        int n = tokenizer.getPartMarker();
        if (this.findUserTable(string, session) != null) {
            throw Trace.error(52, string);
        }
        View view = new View(this, new HsqlName(string, tokenizer.wasQuotedIdentifier()));
        tokenizer.getThis("AS");
        tokenizer.setPartMarker();
        tokenizer.getThis("SELECT");
        Parser parser = new Parser(this, tokenizer, session);
        int n2 = session.getMaxRows();
        Select select = parser.parseSelect();
        if (select.sIntoTable != null) {
            throw Trace.error(22);
        }
        select.setPreProcess();
        Result result = select.getResult(1);
        view.setStatement(tokenizer.getLastPart());
        view.addColumns(result);
        session.commit();
        this.tTable.addElement(view);
        tokenizer.setPartMarker(n);
    }

    private void processRenameTable(Tokenizer tokenizer, Session session, String string) throws SQLException {
        String string2 = tokenizer.getName();
        boolean bl = tokenizer.wasQuotedIdentifier();
        Table table = this.findUserTable(string);
        if (table == null || !table.equals(string, session)) {
            throw Trace.error(22, string);
        }
        Table table2 = this.findUserTable(string2);
        if (table2 != null && table2.equals(table2.getName().name, session)) {
            throw Trace.error(21, string);
        }
        session.commit();
        session.setScripting(!table.isTemp());
        table.setName(string2, bl);
    }

    private Result processAlter(Tokenizer tokenizer, Session session) throws SQLException {
        session.checkReadWrite();
        session.checkAdmin();
        session.setScripting(true);
        String string = tokenizer.getString();
        if (string.equals("TABLE")) {
            this.processAlterTable(tokenizer, session);
        } else if (string.equals("INDEX")) {
            this.processAlterIndex(tokenizer, session);
        } else {
            throw Trace.error(11, string);
        }
        return new Result();
    }

    private void processAlterTable(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getString();
        Table table = this.getUserTable(string, session);
        TableWorks tableWorks = new TableWorks(table);
        String string2 = tokenizer.getString();
        session.setScripting(!table.isTemp());
        if (string2.equals("RENAME")) {
            tokenizer.getThis("TO");
            this.processRenameTable(tokenizer, session, string);
            return;
        }
        if (string2.equals("ADD")) {
            string2 = tokenizer.getString();
            if (string2.equals("CONSTRAINT")) {
                HsqlName hsqlName = new HsqlName(tokenizer.getName(), tokenizer.wasQuotedIdentifier());
                string2 = tokenizer.getString();
                if (string2.equals("FOREIGN")) {
                    tokenizer.getThis("KEY");
                    TempConstraint tempConstraint = this.processCreateFK(tokenizer, session, table, hsqlName);
                    table.checkColumnsMatch(tempConstraint.localCol, tempConstraint.expTable, tempConstraint.expCol);
                    session.commit();
                    tableWorks.createForeignKey(tempConstraint.localCol, tempConstraint.expCol, tempConstraint.name, tempConstraint.expTable, tempConstraint.cascade);
                    return;
                }
                if (string2.equals("UNIQUE")) {
                    int[] nArray = this.processColumnList(tokenizer, table);
                    session.commit();
                    tableWorks.createUniqueConstraint(nArray, hsqlName);
                    return;
                }
                throw Trace.error(11, string2);
            }
            if (string2.equals("COLUMN")) {
                int n = table.getColumnCount();
                Column column = this.processCreateColumn(tokenizer, table);
                string2 = tokenizer.getString();
                if (string2.equals("BEFORE")) {
                    string2 = tokenizer.getName();
                    n = table.getColumnNr(string2);
                } else {
                    tokenizer.back();
                }
                if (column.isIdentity() || column.isPrimaryKey() || !table.isEmpty() && !column.isNullable() && column.getDefaultString() == null) {
                    throw Trace.error(58);
                }
                session.commit();
                tableWorks.addOrDropColumn(column, n, 1);
                return;
            }
        } else {
            if (string2.equals("DROP")) {
                string2 = tokenizer.getString();
                if (string2.equals("CONSTRAINT")) {
                    String string3 = tokenizer.getName();
                    session.commit();
                    tableWorks.dropConstraint(string3);
                    return;
                }
                if (string2.equals("COLUMN")) {
                    string2 = tokenizer.getName();
                    int n = table.getColumnNr(string2);
                    session.commit();
                    tableWorks.addOrDropColumn(null, n, -1);
                    return;
                }
                throw Trace.error(11, string2);
            }
            throw Trace.error(11, string2);
        }
    }

    private void processAlterIndex(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getName();
        tokenizer.getThis("RENAME");
        tokenizer.getThis("TO");
        String string2 = tokenizer.getName();
        boolean bl = tokenizer.wasQuotedIdentifier();
        Table table = this.findTableForIndex(string);
        if (table == null || !table.equals(table.getName().name, session)) {
            throw Trace.error(26, string);
        }
        Table table2 = this.findTableForIndex(string2);
        if (table2 != null && table2.equals(table2.getName().name, session)) {
            throw Trace.error(23, string);
        }
        if (HsqlName.isReservedName(string)) {
            throw Trace.error(56, string);
        }
        if (HsqlName.isReservedName(string2)) {
            throw Trace.error(49, string);
        }
        session.setScripting(!table.isTemp());
        session.commit();
        table.getIndex(string).setName(string2, bl);
    }

    private Result processDrop(Tokenizer tokenizer, Session session) throws SQLException {
        session.checkReadWrite();
        session.checkAdmin();
        session.setScripting(true);
        String string = tokenizer.getString();
        if (string.equals("TABLE") || string.equals("VIEW")) {
            boolean bl = string.equals("VIEW");
            String string2 = tokenizer.getString();
            boolean bl2 = false;
            string = tokenizer.getString();
            if (string.equals("IF")) {
                tokenizer.getThis("EXISTS");
                bl2 = true;
            } else {
                tokenizer.back();
                Table table = this.getTable(string2, session);
                session.setScripting(!table.isTemp());
            }
            this.dropTable(string2, bl2, bl, session);
            session.commit();
        } else if (string.equals("USER")) {
            this.aAccess.dropUser(tokenizer.getStringToken());
        } else if (string.equals("TRIGGER")) {
            this.dropTrigger(tokenizer.getString(), session);
        } else if (string.equals("INDEX")) {
            String string3 = tokenizer.getName();
            Table table = this.findTableForIndex(string3);
            if (table == null || !table.equals(table.getName().name, session)) {
                throw Trace.error(26, string3);
            }
            table.checkDropIndex(string3, null);
            session.commit();
            session.setScripting(!table.isTemp());
            TableWorks tableWorks = new TableWorks(table);
            tableWorks.dropIndex(string3);
        } else {
            throw Trace.error(11, string);
        }
        return new Result();
    }

    private Result processGrantOrRevoke(Tokenizer tokenizer, Session session, boolean bl) throws SQLException {
        Object object;
        String string;
        String string2;
        session.checkReadWrite();
        session.checkAdmin();
        session.setScripting(true);
        int n = 0;
        do {
            string = tokenizer.getString();
            n |= UserManager.getRight(string);
        } while ((string2 = tokenizer.getString()).equals(","));
        if (!string2.equals("ON")) {
            throw Trace.error(11, string2);
        }
        string = tokenizer.getString();
        if (string.equals("CLASS")) {
            string = string + " \"" + tokenizer.getString() + "\"";
        } else {
            object = this.getTable(string, session);
            session.setScripting(!((Table)object).isTemp());
        }
        tokenizer.getThis("TO");
        object = tokenizer.getStringToken();
        if (bl) {
            this.aAccess.grant((String)object, string, n);
            String string3 = "GRANT";
        } else {
            this.aAccess.revoke((String)object, string, n);
            String string4 = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer tokenizer, Session session) throws SQLException {
        tokenizer.getThis("USER");
        String string = tokenizer.getStringToken();
        tokenizer.getThis("PASSWORD");
        String string2 = tokenizer.getStringToken();
        User user = this.aAccess.getUser(string, string2);
        session.commit();
        session.setUser(user);
        return new Result();
    }

    private Result processDisconnect(Session session) throws SQLException {
        if (!session.isClosed()) {
            session.disconnect();
            this.cSession.setElementAt(null, session.getId());
        }
        return new Result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result processSet(Tokenizer tokenizer, Session session) throws SQLException {
        session.setScripting(true);
        String string = tokenizer.getString();
        if (string.equals("PASSWORD")) {
            session.checkReadWrite();
            session.setPassword(tokenizer.getStringToken());
            return new Result();
        } else if (string.equals("READONLY")) {
            session.commit();
            session.setReadOnly(this.processTrueOrFalse(tokenizer));
            return new Result();
        } else if (string.equals("LOGSIZE")) {
            session.checkAdmin();
            int n = Integer.parseInt(tokenizer.getString());
            this.logger.setLogSize(n);
            return new Result();
        } else if (string.equals("IGNORECASE")) {
            session.checkAdmin();
            this.bIgnoreCase = this.processTrueOrFalse(tokenizer);
            return new Result();
        } else if (string.equals("MAXROWS")) {
            int n = Integer.parseInt(tokenizer.getString());
            session.setMaxRows(n);
            return new Result();
        } else if (string.equals("AUTOCOMMIT")) {
            session.setAutoCommit(this.processTrueOrFalse(tokenizer));
            return new Result();
        } else if (string.equals("TABLE")) {
            session.checkReadWrite();
            Table table = this.getTable(tokenizer.getString(), session);
            string = tokenizer.getString();
            session.setScripting(!table.isTemp());
            if (string.equals("SOURCE")) {
                if (!table.isTemp()) {
                    session.checkAdmin();
                }
                string = tokenizer.getString();
                if (!tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(7);
                }
                boolean bl = false;
                if (tokenizer.getString().equals("DESC")) {
                    bl = true;
                } else {
                    tokenizer.back();
                }
                table.setDataSource(string, bl, session);
                return new Result();
            } else if (string.equals("READONLY")) {
                session.checkAdmin();
                table.setDataReadOnly(this.processTrueOrFalse(tokenizer));
                return new Result();
            } else {
                if (!string.equals("INDEX")) throw Trace.error(11, string);
                session.checkAdmin();
                tokenizer.getString();
                table.setIndexRoots((String)tokenizer.getAsValue());
            }
            return new Result();
        } else if (string.equals("REFERENTIAL_INTEGRITY")) {
            session.checkAdmin();
            this.bReferentialIntegrity = this.processTrueOrFalse(tokenizer);
            return new Result();
        } else {
            if (!string.equals("WRITE_DELAY")) throw Trace.error(11, string);
            session.checkAdmin();
            boolean bl = this.processTrueOrFalse(tokenizer);
            this.logger.setWriteDelay(bl);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer tokenizer) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, string);
    }

    private Result processCommit(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getString();
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        session.commit();
        return new Result();
    }

    private Result processRollback(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("TO")) {
            String string2 = tokenizer.getString();
            if (!string2.equals("SAVEPOINT")) {
                throw Trace.error(11, string2);
            }
            string2 = tokenizer.getString();
            if (string2.length() == 0) {
                throw Trace.error(11, string2);
            }
            session.rollbackToSavepoint(string2);
            return new Result();
        }
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        session.rollback();
        return new Result();
    }

    private Result processSavepoint(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.getString();
        if (string.length() == 0) {
            throw Trace.error(11, string);
        }
        session.savepoint(string);
        return new Result();
    }

    public void finalize() {
        try {
            this.close(-1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void close(int n) throws SQLException {
        this.logger.closeLog(n);
        if (n == 1) {
            this.open();
            this.logger.closeLog(0);
        }
        this.bShutdown = true;
        jdbcConnection.removeDatabase(this);
    }

    private Result processShutdown(Tokenizer tokenizer, Session session) throws SQLException {
        if (!session.isClosed()) {
            session.checkAdmin();
        }
        int n = 0;
        String string = tokenizer.getString();
        if (string.equals("IMMEDIATELY")) {
            n = -1;
        } else if (string.equals("COMPACT")) {
            n = 1;
        } else {
            tokenizer.back();
        }
        int n2 = 1;
        int n3 = this.cSession.size();
        while (n2 < n3) {
            Session session2 = (Session)this.cSession.elementAt(n2);
            if (session2 != null) {
                session2.disconnect();
            }
            ++n2;
        }
        this.cSession.removeAllElements();
        this.close(n);
        this.processDisconnect(session);
        return new Result();
    }

    private Result processCheckpoint(Session session) throws SQLException {
        session.checkAdmin();
        session.checkReadWrite();
        this.logger.checkpoint();
        return new Result();
    }

    void dropTempTables(Session session) {
        int n = 0;
        while (n < this.tTable.size()) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.isTemp() && table.getOwnerSession() == session) {
                this.tTable.removeElementAt(n);
            }
            ++n;
        }
    }

    void dropTable(String string, boolean bl, boolean bl2, Session session) throws SQLException {
        Table table = null;
        int n = -1;
        int n2 = -1;
        Enumeration enumeration = null;
        Constraint constraint = null;
        Table table2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        while (n3 < this.tTable.size()) {
            table = (Table)this.tTable.elementAt(n3);
            if (table.equals(string, session) && bl2 == table.isView()) {
                n = n3;
                break;
            }
            table = null;
            ++n3;
        }
        if (n == -1) {
            if (bl) {
                return;
            }
            throw Trace.error(bl2 ? 53 : 22, string);
        }
        enumeration = table.getConstraints().elements();
        while (enumeration.hasMoreElements()) {
            constraint = (Constraint)enumeration.nextElement();
            if (constraint.getType() != 1) continue;
            table2 = constraint.getRef();
            bl3 = table2 != null;
            boolean bl5 = bl4 = bl3 && table.equals(table2);
            if (!bl3 || bl4) continue;
            int n4 = 0;
            while (n4 < this.tTable.size()) {
                if (table2.equals(this.tTable.elementAt(n4))) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            if (n2 == -1) continue;
            throw Trace.error(8, constraint.getName().name + " table: " + table2.getName().name);
        }
        if (table.isText()) {
            table.setDataSource("", false, session);
        }
        this.tTable.removeElementAt(n);
        this.removeExportedKeys(table);
    }

    void removeExportedKeys(Table table) {
        int n = 0;
        while (n < this.tTable.size()) {
            Vector vector = ((Table)this.tTable.elementAt(n)).getConstraints();
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                Constraint constraint = (Constraint)vector.elementAt(n2);
                Table table2 = constraint.getRef();
                if (table == table2) {
                    vector.removeElementAt(n2);
                }
                --n2;
            }
            ++n;
        }
    }

    private void dropTrigger(String string, Session session) throws SQLException {
        boolean bl = false;
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.elementAt(n);
            int n3 = TriggerDef.numTrigs();
            int n4 = 0;
            while (n4 < n3) {
                Vector vector = table.vTrigs[n4];
                int n5 = vector.size() - 1;
                while (n5 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)vector.elementAt(n5);
                    if (triggerDef.name.equals(string)) {
                        session.setScripting(!triggerDef.table.isTemp());
                        vector.removeElementAt(n5);
                        bl = true;
                        if (Trace.TRACE) {
                            Trace.trace("Trigger dropped " + string);
                        }
                    }
                    --n5;
                }
                ++n4;
            }
            ++n;
        }
        Trace.check(bl, 43, string);
    }

    static {
        hCommands.put("ALTER", new Integer(20));
        hCommands.put("CALL", new Integer(1));
        hCommands.put("CHECKPOINT", new Integer(2));
        hCommands.put("COMMIT", new Integer(3));
        hCommands.put("CONNECT", new Integer(4));
        hCommands.put("CREATE", new Integer(5));
        hCommands.put("DELETE", new Integer(6));
        hCommands.put("DISCONNECT", new Integer(7));
        hCommands.put("DROP", new Integer(8));
        hCommands.put("GRANT", new Integer(9));
        hCommands.put("INSERT", new Integer(10));
        hCommands.put("REVOKE", new Integer(11));
        hCommands.put("ROLLBACK", new Integer(12));
        hCommands.put("SAVEPOINT", new Integer(13));
        hCommands.put("SCRIPT", new Integer(14));
        hCommands.put("SELECT", new Integer(15));
        hCommands.put("SET", new Integer(16));
        hCommands.put("SHUTDOWN", new Integer(17));
        hCommands.put("UPDATE", new Integer(18));
        hCommands.put(";", new Integer(19));
    }

    class Logger {
        private Log lLog;

        Logger() {
        }

        boolean openLog(Database database, Session session, String string) throws SQLException {
            this.lLog = new Log(database, session, string);
            boolean bl = this.lLog.open();
            return bl;
        }

        void closeLog(int n) throws SQLException {
            if (this.lLog == null) {
                return;
            }
            this.lLog.stop();
            switch (n) {
                case -1: {
                    this.lLog.shutdown();
                    break;
                }
                case 0: {
                    this.lLog.close(false);
                    break;
                }
                case 1: {
                    this.lLog.close(true);
                }
            }
            this.lLog = null;
        }

        boolean hasLog() {
            return this.lLog != null;
        }

        Cache getCache() throws SQLException {
            if (this.lLog != null) {
                return this.lLog.getCache();
            }
            return null;
        }

        void cleanUp() throws SQLException {
            if (this.lLog != null && this.lLog.getCache() != null) {
                this.lLog.getCache().cleanUp();
            }
        }

        void logConnectUser(Session session, String string, String string2) throws SQLException {
            if (this.lLog != null) {
                this.lLog.write(session, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
            }
        }

        void writeToLog(Session session, String string) throws SQLException {
            if (this.lLog != null) {
                this.lLog.write(session, string);
            }
        }

        private void checkpoint() throws SQLException {
            if (this.lLog != null) {
                this.lLog.checkpoint();
            }
        }

        void setLogSize(int n) {
            if (this.lLog != null) {
                this.lLog.setLogSize(n);
            }
        }

        void setWriteDelay(boolean bl) {
            if (this.lLog != null) {
                this.lLog.setWriteDelay(bl);
            }
        }

        Cache openTextCache(String string, String string2, boolean bl, boolean bl2) throws SQLException {
            return this.lLog.openTextCache(string, string2, bl, bl2);
        }

        void closeTextCache(String string) throws SQLException {
            this.lLog.closeTextCache(string);
        }
    }

    private class TempConstraint {
        HsqlName name;
        int[] localCol;
        Table expTable;
        int[] expCol;
        int type;
        boolean cascade;

        TempConstraint(HsqlName hsqlName, int[] nArray, Table table, int[] nArray2, int n, boolean bl) {
            this.name = hsqlName;
            this.type = n;
            this.localCol = nArray;
            this.expTable = table;
            this.expCol = nArray2;
            this.cascade = bl;
        }
    }
}

