/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.file.monolog;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.file.DottedStringTools;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;

public class PropertiesConfAccess
implements Serializable {
    public static final String LOGGER_FIELD = "logger";
    public static final String ADDITIVITY_FIELD = "additivity";
    public static final String HANDLER_FIELD = "handler";
    public static final String LEVEL_FIELD = "level";
    public static final String TOPIC_FIELD = "topic";
    public static final char DOT = '.';
    public static final String HANDLER_TYPE_ATTRIBUTE = "type";
    public static final String HANDLER_TYPE_ATTRIBUTE_FILE_VALUE = "File";
    public static final String HANDLER_TYPE_ATTRIBUTE_CONSOLE_VALUE = "Console";
    public static final String HANDLER_TYPE_ATTRIBUTE_ROLLING_FILE_VALUE = "RollingFile";
    protected Vector loggerCleaned = null;

    protected void cleanOldHandler(TopicalLogger topicalLogger) throws Exception {
        if (this.loggerCleaned == null) {
            this.loggerCleaned = new Vector();
        }
        if (!this.loggerCleaned.contains(topicalLogger)) {
            this.loggerCleaned.addElement(topicalLogger);
            Handler[] handlerArray = topicalLogger.getHandlers();
            int n = 0;
            while (n < handlerArray.length) {
                topicalLogger.removeHandler(handlerArray[n]);
                ++n;
            }
        }
    }

    public void debug(String string) {
    }

    protected String[] getDependsLevel(String string) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +-", true);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            if (!Character.isLetter(objectArray.charAt(0))) continue;
            vector.addElement(objectArray);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected String getHandlerType(byte by) throws Exception {
        switch (by) {
            case 1: {
                return HANDLER_TYPE_ATTRIBUTE_FILE_VALUE;
            }
            case 2: {
                return HANDLER_TYPE_ATTRIBUTE_CONSOLE_VALUE;
            }
            case 3: {
                return HANDLER_TYPE_ATTRIBUTE_ROLLING_FILE_VALUE;
            }
        }
        throw new Exception("Unknow handler type: " + by);
    }

    protected byte getHandlerType(String string) throws Exception {
        if (string == null) {
            throw new Exception("Null handler type: ");
        }
        if (HANDLER_TYPE_ATTRIBUTE_FILE_VALUE.equalsIgnoreCase(string)) {
            return 1;
        }
        if (HANDLER_TYPE_ATTRIBUTE_CONSOLE_VALUE.equalsIgnoreCase(string)) {
            return 2;
        }
        if (HANDLER_TYPE_ATTRIBUTE_ROLLING_FILE_VALUE.equalsIgnoreCase(string)) {
            return 3;
        }
        throw new Exception("Unknow handler type: " + string);
    }

    protected boolean isDefaultLevel(Level level) {
        return level.getName().equalsIgnoreCase("DEBUG") || level.getName().equalsIgnoreCase("INFO") || level.getName().equalsIgnoreCase("WARN") || level.getName().equalsIgnoreCase("ERROR") || level.getName().equalsIgnoreCase("FATAL");
    }

    public static void load(Properties properties, LoggerFactory loggerFactory, HandlerFactory handlerFactory, LevelFactory levelFactory) throws Exception {
        new PropertiesConfAccess().read(properties, loggerFactory, handlerFactory, levelFactory);
    }

    protected Handler parseHandlerProp(Properties properties, String string, HandlerFactory handlerFactory) throws Exception {
        if (properties == null || string == null || handlerFactory == null) {
            throw new Exception("The null parameters are not allowed");
        }
        String string2 = DottedStringTools.getFirst(string);
        if (string2 == null || !string2.equalsIgnoreCase(HANDLER_FIELD)) {
            throw new Exception("This key is not a Handler field:" + string);
        }
        string2 = DottedStringTools.getEnd(string);
        String string3 = DottedStringTools.getLast(string2);
        String string4 = DottedStringTools.getBegin(string2);
        Handler handler = handlerFactory.getHandler(string4);
        if (handler == null) {
            String string5 = properties.getProperty("handler." + string4 + '.' + HANDLER_TYPE_ATTRIBUTE, null);
            if (string5 == null) {
                throw new Exception("Impossible to define the handler " + string2 + ": the type is not defined");
            }
            handler = handlerFactory.createHandler(string4, this.getHandlerType(string5));
            if (!string3.equalsIgnoreCase(HANDLER_TYPE_ATTRIBUTE)) {
                handler.setAttribute(string3, (Object)properties.getProperty(string).trim());
            }
        } else if (!HANDLER_TYPE_ATTRIBUTE.equalsIgnoreCase(string3)) {
            handler.setAttribute(string3, (Object)properties.getProperty(string).trim());
        }
        return handler;
    }

    protected Level parseLevelProp(Properties properties, String string, LevelFactory levelFactory) throws Exception {
        return this.parseLevelProp(properties, string, levelFactory, new Vector());
    }

    protected Level parseLevelProp(Properties properties, String string, LevelFactory levelFactory, Vector vector) throws Exception {
        if (properties == null || string == null || levelFactory == null) {
            throw new Exception("The null parameters are not allowed");
        }
        String string2 = DottedStringTools.getFirst(string);
        if (string2 == null || !string2.equalsIgnoreCase(LEVEL_FIELD)) {
            throw new Exception("This key is not a level field:" + string);
        }
        string2 = DottedStringTools.getEnd(string);
        Level level = levelFactory.getLevel(string2);
        if (level == null) {
            if (!((Hashtable)properties).containsKey(string)) {
                throw new Exception("Level definition not found: " + string);
            }
            if (vector.contains(string2)) {
                throw new Exception("Circular level definition: " + string2);
            }
            String string3 = properties.getProperty(string).trim();
            String[] stringArray = this.getDependsLevel(string3);
            if (stringArray.length > 0) {
                vector.add(string2);
                int n = 0;
                while (n < stringArray.length) {
                    this.parseLevelProp(properties, "level." + stringArray[n], levelFactory, vector);
                    ++n;
                }
                vector.remove(string2);
            }
            level = levelFactory.defineLevel(string2, string3);
        }
        return level;
    }

    protected Logger parseLoggerProp(Properties properties, String string, LoggerFactory loggerFactory, HandlerFactory handlerFactory, LevelFactory levelFactory) throws Exception {
        if (properties == null || string == null || loggerFactory == null || handlerFactory == null || levelFactory == null) {
            throw new Exception("The null parameters are not allowed");
        }
        String string2 = DottedStringTools.getFirst(string);
        if (string2 == null || !string2.equalsIgnoreCase(LOGGER_FIELD)) {
            throw new Exception("This key is not a Logger property:" + string);
        }
        TopicalLogger topicalLogger = null;
        string2 = DottedStringTools.getEnd(string);
        String string3 = DottedStringTools.getLast(string2);
        if (string3.equalsIgnoreCase(LEVEL_FIELD)) {
            topicalLogger = (TopicalLogger)loggerFactory.getLogger(DottedStringTools.getBegin(string2));
            String string4 = properties.getProperty(string).trim();
            Level level = levelFactory.getLevel(string4);
            if (level == null) {
                level = this.parseLevelProp(properties, "level." + string4, levelFactory);
            }
            topicalLogger.setLevel(level);
        } else if (string3.equalsIgnoreCase(ADDITIVITY_FIELD)) {
            topicalLogger = (TopicalLogger)loggerFactory.getLogger(DottedStringTools.getBegin(string2));
            String string5 = properties.getProperty(string).trim();
            if (string5 != null) {
                topicalLogger.setAdditivity(string5.equalsIgnoreCase("false") ^ true);
            }
        } else {
            try {
                int n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NestedException(numberFormatException, "The last element of the key must be a number:" + string);
            }
            string2 = DottedStringTools.getBegin(string2);
            string3 = DottedStringTools.getLast(string2);
            if (string3.equalsIgnoreCase(HANDLER_FIELD)) {
                string2 = DottedStringTools.getBegin(string2);
                topicalLogger = (TopicalLogger)loggerFactory.getLogger(string2);
                String string6 = properties.getProperty(string).trim();
                Handler handler = handlerFactory.getHandler(string6);
                if (handler == null) {
                    handler = this.parseHandlerProp(properties, "handler." + string6 + '.' + HANDLER_TYPE_ATTRIBUTE, handlerFactory);
                }
                this.cleanOldHandler(topicalLogger);
                topicalLogger.addHandler(handler);
            } else if (string3.equalsIgnoreCase(TOPIC_FIELD)) {
                string2 = DottedStringTools.getBegin(string2);
                topicalLogger = (TopicalLogger)loggerFactory.getLogger(string2);
                topicalLogger.addTopic(properties.getProperty(string).trim());
            } else {
                throw new Exception("Unknown definition" + string + " " + properties.getProperty(string));
            }
        }
        return topicalLogger;
    }

    public void read(Properties properties, LoggerFactory loggerFactory, HandlerFactory handlerFactory, LevelFactory levelFactory) throws Exception {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith(LOGGER_FIELD)) {
                this.parseLoggerProp(properties, string, loggerFactory, handlerFactory, levelFactory);
                continue;
            }
            if (string.startsWith(HANDLER_FIELD)) {
                this.parseHandlerProp(properties, string, handlerFactory);
                continue;
            }
            if (!string.startsWith(LEVEL_FIELD)) continue;
            this.parseLevelProp(properties, string, levelFactory);
        }
    }

    public static void store(Properties properties, LoggerFactory loggerFactory, HandlerFactory handlerFactory, LevelFactory levelFactory) throws Exception {
        new PropertiesConfAccess().write(properties, loggerFactory, handlerFactory, levelFactory);
    }

    public void write(Properties properties, LoggerFactory loggerFactory, HandlerFactory handlerFactory, LevelFactory levelFactory) throws Exception {
        int n;
        Object[] objectArray;
        String string = null;
        String string2 = null;
        Level[] levelArray = levelFactory.getLevels();
        int n2 = 0;
        while (n2 < levelArray.length) {
            if (!this.isDefaultLevel(levelArray[n2])) {
                string = "level." + levelArray[n2].getName();
                string2 = ((LevelImpl)levelArray[n2]).getStringValue();
                this.debug(String.valueOf(string) + " " + string2);
                properties.setProperty(string, string2.trim());
            }
            ++n2;
        }
        Handler[] handlerArray = handlerFactory.getHandlers();
        int n3 = 0;
        while (n3 < handlerArray.length) {
            string = "handler." + handlerArray[n3].getName() + '.' + HANDLER_TYPE_ATTRIBUTE;
            string2 = this.getHandlerType(handlerArray[n3].getType());
            this.debug(String.valueOf(string) + " " + string2);
            properties.setProperty(string, string2);
            objectArray = handlerArray[n3].getAttributeNames();
            n = 0;
            while (n < objectArray.length) {
                string = "handler." + handlerArray[n3].getName() + '.' + (String)objectArray[n];
                string2 = (String)handlerArray[n3].getAttribute((String)objectArray[n]);
                this.debug(String.valueOf(string) + " " + string2);
                properties.setProperty(string, string2.trim());
                ++n;
            }
            ++n3;
        }
        objectArray = (TopicalLogger[])loggerFactory.getLoggers();
        n = 0;
        while (n < objectArray.length) {
            String[] stringArray;
            Level level;
            if (objectArray[n].getTopic().length == 0) {
                throw new Exception("Impossible to set the definition of a logger without name");
            }
            String string3 = "logger." + objectArray[n].getTopic()[0];
            if (!objectArray[n].getAdditivity()) {
                string = String.valueOf(string3) + '.' + ADDITIVITY_FIELD;
                string2 = "false";
                this.debug(String.valueOf(string) + " " + string2);
                properties.setProperty(string, string2.trim());
            }
            if ((level = objectArray[n].getCurrentLevel()) != null && level.getIntValue() != BasicLevel.INHERIT) {
                string = String.valueOf(string3) + '.' + LEVEL_FIELD;
                string2 = " " + level.getName();
                this.debug(String.valueOf(string) + " " + string2);
                properties.setProperty(string, string2.trim());
            }
            if ((handlerArray = objectArray[n].getHandlers()) != null && handlerArray.length > 0) {
                int n4 = 0;
                while (n4 < handlerArray.length) {
                    this.debug(String.valueOf(string3) + '.' + HANDLER_FIELD + '.' + n4 + " " + handlerArray[n4].getName());
                    if (handlerArray[n4].getName() != null) {
                        string = String.valueOf(string3) + '.' + HANDLER_FIELD + '.' + n4;
                        string2 = handlerArray[n4].getName();
                        this.debug(String.valueOf(string) + " " + string2);
                        properties.setProperty(string, string2.trim());
                    }
                    ++n4;
                }
            }
            if ((stringArray = objectArray[n].getTopic()) != null && stringArray.length > 0) {
                int n5 = 1;
                while (n5 < stringArray.length) {
                    string = String.valueOf(string3) + '.' + TOPIC_FIELD + '.' + (n5 - 1);
                    string2 = stringArray[n5];
                    this.debug(String.valueOf(string) + " " + string2);
                    properties.setProperty(string, string2.trim());
                    ++n5;
                }
            }
            ++n;
        }
    }

    class NestedException
    extends Exception {
        Exception nestedException = null;

        public NestedException() {
        }

        public NestedException(Exception exception) {
            this.nestedException = exception;
        }

        public NestedException(Exception exception, String string) {
            super(string);
            this.nestedException = exception;
        }

        public Exception getNestedException() {
            return this.nestedException;
        }

        public void printStackTrace() {
            this.printStackTrace(new PrintStream(System.out));
        }

        public void printStackTrace(PrintStream printStream) {
            if (this.nestedException != null) {
                printStream.println("Nested: " + this.getMessage());
                this.nestedException.printStackTrace(printStream);
            } else {
                super.printStackTrace(printStream);
            }
        }

        public void printStackTrace(PrintWriter printWriter) {
            if (this.nestedException != null) {
                printWriter.println("Nested: " + this.getMessage());
                this.nestedException.printStackTrace(printWriter);
            } else {
                super.printStackTrace(printWriter);
            }
        }
    }
}

