/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.lmi;

import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.objectweb.carol.jndi.lmi.LmiNameParser;
import org.objectweb.carol.util.configuration.TraceCarol;

public class LmiInitialContext
implements Context {
    private static Hashtable lmiEnv = new Hashtable();
    private static Hashtable bindings = new Hashtable();
    private static NameParser lmiParser = new LmiNameParser();

    private Object resolveObject(Object o) {
        try {
            if (o instanceof Reference) {
                Reference objRef = (Reference)o;
                ObjectFactory objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                return (Referenceable)objFact.getObjectInstance(objRef, null, null, null);
            }
            return o;
        }
        catch (Exception e) {
            TraceCarol.error("LmiInitialContext.resolveObject()", e);
            return o;
        }
    }

    private Object encodeObject(Object o) throws NamingException {
        try {
            if (!(o instanceof Remote) && o instanceof Referenceable) {
                return ((Referenceable)o).getReference();
            }
            return o;
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public LmiInitialContext() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.LmiInitialContext()");
        }
    }

    public LmiInitialContext(Hashtable ev) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.LmiInitialContext(Hashtable env)");
        }
        if (ev != null) {
            lmiEnv = (Hashtable)ev.clone();
        }
    }

    public Object lookup(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.lookup(\"" + name + "\")");
        }
        if (name == null && name.equals("")) {
            return new LmiInitialContext(lmiEnv);
        }
        Object o = bindings.get(name);
        if (o != null) {
            return this.resolveObject(o);
        }
        throw new NameNotFoundException(name + " not found");
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.bind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (bindings.get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        bindings.put(name, this.encodeObject(obj));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.rebind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        bindings.put(name, this.encodeObject(obj));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.unbind(\"" + name + "\")");
        }
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        bindings.remove(name);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.rename(\"" + oldName + "\",\"" + newName + "\")");
        }
        if (oldName.equals("") || newName.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (bindings.get(newName) != null) {
            throw new NameAlreadyBoundException(newName + " is already bound");
        }
        Object oldb = bindings.remove(oldName);
        if (oldb == null) {
            throw new NameNotFoundException(oldName + " not bound");
        }
        bindings.put(newName, oldb);
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.list(\"" + name + "\")");
        }
        if (name.equals("")) {
            return new LmiNames(bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.listBindings(\"" + name + "\")/rmi name=\"");
        }
        if (name.equals("")) {
            return new LmiBindings(bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        TraceCarol.error("LmiInitialContext.destroySubcontext(\"" + name + "\"): Not supported");
        throw new OperationNotSupportedException("LmiInitialContext.destroySubcontext(\"" + name + "\"): Not supported");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        TraceCarol.error("LmiInitialContext.createSubcontext(\"" + name + "\"): Not supported");
        throw new OperationNotSupportedException("LmiInitialContext.createSubcontext(\"" + name + "\"): Not supported");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.lookupLink(\"" + name + "\")");
        }
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.getNameParser(\"" + name + "\")");
        }
        return lmiParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.composeName(" + name + "," + prefix + ")");
        }
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.composeName(" + name + "," + prefix + ")");
        }
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.addToEnvironment(\"" + propName + "\"," + this.simpleClass(propVal.getClass().getName()) + " object)");
        }
        if (lmiEnv == null) {
            lmiEnv = new Hashtable();
        }
        return lmiEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.removeFromEnvironment(\"" + propName + "\")");
        }
        if (lmiEnv == null) {
            return null;
        }
        return lmiEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.getEnvironment()");
        }
        if (lmiEnv == null) {
            lmiEnv = new Hashtable();
        }
        return lmiEnv;
    }

    public void close() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.close()");
        }
    }

    public String getNameInNamespace() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("LmiInitialContext.getNameInNamespace()");
        }
        return "lmiContext";
    }

    private String simpleClass(String c) {
        return c.substring(c.lastIndexOf(46) + 1);
    }

    class LmiBindings
    implements NamingEnumeration {
        Enumeration names;

        LmiBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            return new Binding(name, bindings.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.names = null;
        }
    }

    class LmiNames
    implements NamingEnumeration {
        Enumeration names;

        LmiNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            String className = bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.names = null;
        }
    }
}

