/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.CarolConfiguration;
import org.objectweb.carol.util.configuration.RMIConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class NameServiceManager {
    public static Hashtable nsTable;
    private static NameServiceManager current;

    private NameServiceManager() {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.NameServiceManager()");
        }
        try {
            nsTable = new Hashtable();
            Hashtable allRMIConfiguration = CarolConfiguration.getAllRMIConfiguration();
            int nbProtocol = allRMIConfiguration.size();
            Enumeration e = allRMIConfiguration.elements();
            while (e.hasMoreElements()) {
                RMIConfiguration currentConf = (RMIConfiguration)e.nextElement();
                String rmiName = currentConf.getName();
                NameService nsC = (NameService)Class.forName(currentConf.getNameService()).newInstance();
                nsC.setPort(currentConf.getPort());
                nsTable.put(rmiName, nsC);
            }
        }
        catch (Exception e) {
            String msg = "NameServiceManager.NameServiceManager() fail";
            TraceCarol.error(msg, e);
        }
    }

    public static NameServiceManager getNSManagerCurrent() {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.getNSManagerCurrent()");
        }
        return current;
    }

    public static void startNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.startNS()");
        }
        Enumeration e = nsTable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            NameService currentNS = (NameService)nsTable.get(k);
            if (!currentNS.isStarted()) continue;
            throw new NameServiceException("The " + k + " name service is allready started");
        }
        NameServiceManager.startNonStartedNS();
    }

    public static void startNonStartedNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.startNonStartedNS()");
        }
        Enumeration e = nsTable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            NameService currentNS = (NameService)nsTable.get(k);
            try {
                currentNS.start();
            }
            catch (NameServiceException nse) {
                if (!TraceCarol.isDebugJndiCarol()) continue;
                TraceCarol.debugJndiCarol("NameServiceManager.startNonStartedNS() can not start name service: " + k);
            }
        }
    }

    public static void stopNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.stopNS()");
        }
        Enumeration e = nsTable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            NameService currentNS = (NameService)nsTable.get(k);
            currentNS.stop();
        }
    }

    public static void main(String[] args) {
        try {
            NameServiceManager.startNonStartedNS();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        NameServiceManager.stopNS();
                    }
                    catch (Exception e) {
                        TraceCarol.error("Carol Naming ShutdownHook problem", e);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        current = new NameServiceManager();
    }
}

