/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.multi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.CarolConfiguration;
import org.objectweb.carol.util.configuration.RMIConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class ProtocolCurrent {
    private static Hashtable prodHashtable = null;
    private static Hashtable icHashtable = null;
    private static String defaultRMI;
    private static InheritableThreadLocal threadCtx;
    private static ProtocolCurrent current;

    private ProtocolCurrent() {
        block4: {
            try {
                threadCtx = new InheritableThreadLocal();
                prodHashtable = new Hashtable();
                icHashtable = new Hashtable();
                Hashtable allRMIConfiguration = CarolConfiguration.getAllRMIConfiguration();
                int nbProtocol = allRMIConfiguration.size();
                Enumeration e = allRMIConfiguration.elements();
                while (e.hasMoreElements()) {
                    RMIConfiguration currentConf = (RMIConfiguration)e.nextElement();
                    String rmiName = currentConf.getName();
                    prodHashtable.put(rmiName, (PortableRemoteObjectDelegate)Class.forName(currentConf.getPro()).newInstance());
                    icHashtable.put(rmiName, new InitialContext(currentConf.getJndiProperties()));
                }
                defaultRMI = CarolConfiguration.getDefaultProtocol().getName();
                threadCtx.set(defaultRMI);
                if (TraceCarol.isDebugCarol()) {
                    TraceCarol.debugCarol("ProtocolCurrent.ProtocolCurrent()");
                    TraceCarol.debugCarol("Number of rmi:" + icHashtable.size());
                    TraceCarol.debugCarol("Default:" + defaultRMI);
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCarol()) break block4;
                TraceCarol.debugCarol("ProtocolCurrent.ProtocolCurrent() Exception:" + e);
            }
        }
    }

    public static ProtocolCurrent getCurrent() {
        return current;
    }

    public void setRMI(String s) {
        threadCtx.set(s);
    }

    public void setDefault() {
        threadCtx.set(defaultRMI);
    }

    public Hashtable getPortableRemoteObjectHashtable() {
        return prodHashtable;
    }

    public Hashtable getContextHashtable() {
        return icHashtable;
    }

    public PortableRemoteObjectDelegate getCurrentPortableRemoteObject() {
        if (threadCtx.get() == null) {
            return (PortableRemoteObjectDelegate)prodHashtable.get(defaultRMI);
        }
        return (PortableRemoteObjectDelegate)prodHashtable.get((String)threadCtx.get());
    }

    public Context getCurrentInitialContext() {
        if (threadCtx.get() == null) {
            return (Context)icHashtable.get(defaultRMI);
        }
        return (Context)icHashtable.get((String)threadCtx.get());
    }

    public String getCurrentRMIName() {
        if (threadCtx.get() == null) {
            return defaultRMI;
        }
        return (String)threadCtx.get();
    }

    public String toString() {
        return "\nnumber of rmi:" + icHashtable.size() + "\ndefault:" + defaultRMI;
    }

    static {
        current = new ProtocolCurrent();
    }
}

