/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.log4j;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mortbay.util.Frame;
import org.mortbay.util.LogSink;

public class Log4jSink
implements LogSink {
    private String _options;
    private transient boolean _started;

    public void setOptions(String filename) {
        this._options = filename;
    }

    public String getOptions() {
        return this._options;
    }

    public void start() throws Exception {
        this._started = true;
    }

    public void stop() {
        this._started = false;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void log(String tag, Object msg, Frame frame, long time) {
        int ld;
        String method = frame.getMethod();
        int lb = method.indexOf(40);
        int n = ld = lb > 0 ? method.lastIndexOf(46, lb) : method.lastIndexOf(46);
        if (ld < 0) {
            ld = lb;
        }
        String class_name = ld > 0 ? method.substring(0, ld) : method;
        Logger log = Logger.getLogger((String)class_name);
        Priority priority = Priority.INFO;
        if ("DEBUG  ".equals(tag)) {
            priority = Priority.DEBUG;
        } else if ("WARN!! ".equals(tag) || "ASSERT ".equals(tag)) {
            priority = Priority.ERROR;
        } else if ("FAIL!! ".equals(tag)) {
            priority = Priority.FATAL;
        }
        if (!log.isEnabledFor(priority)) {
            return;
        }
        log.log("org.mortbay.util.Log4jSink", priority, (Object)("" + msg), null);
    }

    public synchronized void log(String s) {
        Logger.getRootLogger().log("org.mortbay.util.Log4jSink", Priority.INFO, (Object)s, null);
    }
}

