// ======================================================================
//  Copyright (C) 2003 by Mortbay Consulting Ltd
// $Id: Service.java,v 1.1 2003/06/30 11:10:52 janb Exp $ 
// ======================================================================

package org.mortbay.jetty.plus;

import org.mortbay.util.LifeCycle;


public interface Service extends LifeCycle
{
   
    public void setJNDI (String registration);

    public String getJNDI ();


    public void setName (String name);
    

    public String getName ();
        
    /* ------------------------------------------------------------ */
    /** Start the LifeCycle.
     * @exception Exception An arbitrary exception may be thrown.
     */
    public void start()
        throws Exception;  
    
    /* ------------------------------------------------------------ */
    /** Stop the LifeCycle.
     * The LifeCycle may wait for current activities to complete
     * normally, but it can be interrupted.
     * @exception InterruptedException Stopping a lifecycle is rarely atomic
     * and may be interrupted by another thread.  If this happens
     * InterruptedException is throw and the component will be in an
     * indeterminant state and should probably be discarded.
     */
    public void stop()
        throws InterruptedException;
   
    /* ------------------------------------------------------------ */
    /** 
     * @return True if the LifeCycle has been started. 
     */
    public boolean isStarted();    
}
