// ========================================================================
// Copyright (c) 2003 Mort Bay Consulting (Australia) Pty. Ltd.
// $Id: TestSetResponseHeadersHandler.java,v 1.1 2003/02/10 00:38:52 bretts Exp $
// ========================================================================

package org.mortbay.http.handler;

import java.io.IOException;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;

/* ------------------------------------------------------------ */

/**
 * @version $Id: TestSetResponseHeadersHandler.java,v 1.1 2003/02/10 00:38:52 bretts Exp $
 * @author Brett Sealey
 */
public class TestSetResponseHeadersHandler extends TestCase
{
    /* ------------------------------------------------------------ */
    /** Create the named test case.
     * @param name The name of the test case.
     */
    public TestSetResponseHeadersHandler(String name)
    {
        super(name);
    }

    /* ------------------------------------------------------------ */
    /** Get the Test suite for the SetResponseHeadersHandler class.
     * @return A TestSuite for the SetResponseHeadersHandler class.
     */
    public static Test suite()
    {
        return new TestSuite(TestSetResponseHeadersHandler.class);
    }

    /* ------------------------------------------------------------ */
    /** main.
     */
    public static void main(String[] args)
    {
        junit.textui.TestRunner.run(suite());
    }

    /* ------------------------------------------------------------ */
    /**
     * Test the basic unconfigured operation of the SetResponseHeadersHandler
     */
    public void testUnconfigured() throws IOException
    {
        final String testUnchanged="TestUnchanged";
        SetResponseHeadersHandler shh=new SetResponseHeadersHandler();
        HttpRequest request=new HttpRequest();
        HttpResponse response=new HttpResponse();
        response.setField(testUnchanged,testUnchanged);
        assertEquals("Header size not as expected.",
                1,response.getHeader().size());

        shh.handle("","",request,response);

        assertEquals("Header size changed by Handler.",
                1,response.getHeader().size());
        assertEquals(testUnchanged,
                testUnchanged,response.getField(testUnchanged));
    }

    /* ------------------------------------------------------------ */
    /**
     * Test the basic operation of the SetResponseHeadersHandler
     */
    public void testBasicOperation() throws IOException,HttpException
    {
        final String testUnchanged="TestUnchanged";
        final String testReplaced="TestReplaced";
        final String testSingleValued="TestSingleValued";
        final String testMultiValued="TestMultiValued";
        final String[] values={"Value1","Value2"};

        SetResponseHeadersHandler shh=new SetResponseHeadersHandler();
        shh.setHeaderValue(testReplaced,testReplaced);
        shh.setHeaderValue(testSingleValued,testSingleValued);
        shh.setHeaderValues(testMultiValued,values);

        HttpRequest request=new HttpRequest();
        HttpResponse response=new HttpResponse();
        response.setField(testUnchanged,testUnchanged);
        response.setField(testReplaced,"Will be replaced by: " + testReplaced);
        assertEquals("Header size not as expected.",
                2,response.getHeader().size());

        shh.handle("","",request,response);

        assertEquals(testUnchanged,
                testUnchanged,response.getField(testUnchanged));
        assertEquals(testReplaced,
                testReplaced,response.getField(testReplaced));
        assertEquals(testSingleValued,
                testSingleValued,response.getField(testSingleValued));

        Enumeration ve=response.getFieldValues(testMultiValued);
        assertNotNull(testMultiValued,ve);
        for (int i=0;i<values.length;i++)
        {
            assertTrue(testMultiValued+" Empty on "+i,ve.hasMoreElements());
            String v=(String)ve.nextElement();
            assertEquals(testMultiValued+" values["+i+"]",values[i],v);
        }
        assertTrue(testMultiValued+" Too many values",!ve.hasMoreElements());
    }
}
