/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.jndi;

import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.objectweb.carol.cmi.ClusterRegistry;
import org.objectweb.carol.cmi.Naming;
import org.objectweb.carol.cmi.NamingContext;
import org.objectweb.carol.cmi.jndi.FlatNameParser;
import org.objectweb.carol.cmi.jndi.ReferenceImpl;
import org.objectweb.carol.cmi.jndi.RemoteReference;
import org.objectweb.carol.util.configuration.TraceCarol;

class FlatCtx
implements Context {
    private Hashtable myEnv = null;
    private String provider = null;
    private static NameParser myParser = new FlatNameParser();
    private ClusterRegistry reg;

    FlatCtx(Hashtable environment) throws NamingException {
        NamingContext nc;
        if (environment != null) {
            this.myEnv = (Hashtable)environment.clone();
            this.provider = (String)this.myEnv.get("java.naming.provider.url");
        }
        if (this.provider == null) {
            this.provider = "cmi:";
        }
        try {
            nc = new NamingContext(this.provider);
        }
        catch (MalformedURLException e) {
            throw new NamingException(e.toString());
        }
        try {
            this.reg = Naming.getRegistry(nc.hp);
        }
        catch (RemoteException e) {
            throw new NamingException(e.toString());
        }
    }

    public Object lookup(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("lookup(" + name + ")");
        }
        if (name.equals("")) {
            return new FlatCtx(this.myEnv);
        }
        try {
            Remote obj = this.reg.lookup(name);
            if (obj instanceof RemoteReference) {
                return NamingManager.getObjectInstance(((RemoteReference)obj).getReference(), null, this, this.myEnv);
            }
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("lookup(" + name + ") returned");
            }
            return obj;
        }
        catch (NotBoundException e) {
            throw new NameNotFoundException(e.toString());
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        block8: {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("bind(" + name + ")");
            }
            if (name.equals("")) {
                throw new InvalidNameException("Cannot bind empty name");
            }
            Object o = NamingManager.getStateToBind(obj, null, this, this.myEnv);
            try {
                if (o instanceof Remote) {
                    this.reg.bind(name, (Remote)o);
                    break block8;
                }
                if (o instanceof Reference) {
                    this.reg.bind(name, new ReferenceImpl((Reference)o));
                    break block8;
                }
                if (o instanceof Referenceable) {
                    this.reg.bind(name, new ReferenceImpl(((Referenceable)o).getReference()));
                    break block8;
                }
                throw new NamingException("object to bind must be Remote : " + obj.getClass().getName());
            }
            catch (RemoteException e) {
                throw new NamingException(e.toString());
            }
            catch (AlreadyBoundException e) {
                throw new NameAlreadyBoundException(e.toString());
            }
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        block7: {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("rebind(" + name + ")");
            }
            if (name.equals("")) {
                throw new InvalidNameException("Cannot bind empty name");
            }
            Object o = NamingManager.getStateToBind(obj, null, this, this.myEnv);
            try {
                if (o instanceof Remote) {
                    this.reg.rebind(name, (Remote)o);
                    break block7;
                }
                if (o instanceof Reference) {
                    this.reg.rebind(name, new ReferenceImpl((Reference)o));
                    break block7;
                }
                if (o instanceof Referenceable) {
                    this.reg.rebind(name, new ReferenceImpl(((Referenceable)o).getReference()));
                    break block7;
                }
                throw new NamingException("object to bind must be Remote : " + obj.getClass().getName());
            }
            catch (RemoteException e) {
                throw new NamingException(e.toString());
            }
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("unbind(" + name + ")");
        }
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        try {
            this.reg.unbind(name);
        }
        catch (RemoteException e) {
            throw new NamingException(e.toString());
        }
        catch (NotBoundException e) {
            throw new NameNotFoundException(e.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new NamingException("not supported");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        try {
            return new CmiNames(this.reg.list());
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new NamingException(e.toString());
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new NamingException("not supported");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("FlatCtx does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("FlatCtx does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
        this.myEnv = null;
        this.reg = null;
    }

    class CmiNames
    implements NamingEnumeration {
        String[] names;
        int index = 0;

        CmiNames(String[] names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.index < this.names.length;
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = this.names[this.index++];
            String className = "java.lang.Object";
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.names = null;
        }
    }
}

