/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.server.JRemoteServerCall;
import org.objectweb.carol.rmi.jrmp.server.JUnicastRef;
import org.objectweb.carol.rmi.jrmp.server.JUnicastRemoteObject;
import org.objectweb.carol.rmi.jrmp.server.JUnicastThreadFactory;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;

public class JUnicastServerRef
extends UnicastServerRef {
    protected JServerRequestInterceptor[] sis = null;
    protected JClientRequestInterceptor[] cis = null;

    public JUnicastServerRef() {
    }

    public JUnicastServerRef(LiveRef ref, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) {
        super(ref);
        this.sis = sis;
        this.cis = cis;
    }

    public JUnicastServerRef(int port, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) {
        super(new LiveRef(port));
        this.sis = sis;
        this.cis = cis;
    }

    public String getRefClass(ObjectOutput out) {
        super.getRefClass(out);
        return "org.objectweb.carol.rmi.jrmp.server.JUnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new JUnicastRef(this.ref, this.cis, JInterceptorStore.getJRMPInitializers());
    }

    protected void unmarshalCustomCallData(ObjectInput in) throws IOException, ClassNotFoundException {
        JServerInterceptorHelper.receive_request(in, this.sis);
        super.unmarshalCustomCallData(in);
    }

    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        JUnicastThreadFactory factory = JUnicastRemoteObject.getDefaultThreadFactory();
        if (factory == null) {
            this.runDispatch(obj, call);
        } else {
            DispatchRunnable dr = new DispatchRunnable(obj, call);
            factory.getThread(dr).run();
            if (dr.getIOException() != null) {
                throw dr.getIOException();
            }
        }
    }

    private void runDispatch(Remote obj, RemoteCall call) throws IOException {
        super.dispatch(obj, new JRemoteServerCall(call, this.sis));
    }

    private class DispatchRunnable
    implements Runnable {
        Remote obj;
        RemoteCall call;
        IOException e = null;

        public DispatchRunnable(Remote obj, RemoteCall call) {
            this.obj = obj;
            this.call = call;
        }

        public void run() {
            try {
                JUnicastServerRef.this.runDispatch(this.obj, this.call);
            }
            catch (IOException e) {
                this.e = e;
            }
        }

        public IOException getIOException() {
            return this.e;
        }
    }
}

