/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jetty;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.deployment.DeploymentException;
import org.jboss.jetty.JBossWebApplicationContext;
import org.jboss.jetty.JettyService;
import org.jboss.logging.Logger;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.WebApplication;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.j2ee.session.Manager;
import org.mortbay.jetty.Server;
import org.mortbay.util.MultiException;
import org.mortbay.xml.XmlConfiguration;
import org.w3c.dom.Element;

public class Jetty
extends Server {
    protected static final Logger _log = Logger.getLogger((String)"org.jboss.jetty");
    JettyService _service;
    String _xmlConfigString = null;
    Element _configElement = null;
    boolean _loaderCompliance = true;
    boolean _unpackWars = false;
    String _webDefaultResource;
    String _subjectAttributeName;
    Hashtable _deployed = new Hashtable();
    protected Manager _distributableSessionManagerPrototype;
    protected boolean _forceDistributable = false;
    protected boolean _supportJSR77 = true;
    protected boolean _stopWebApplicationsGracefully = false;

    Jetty(JettyService service) {
        this._service = service;
        if (this.findResourceInJar("com/sun/tools/javac/v8/resources/javac.properties") == null) {
            _log.warn((Object)"JSP compilation requires $JAVA_HOME/lib/tools.jar on your JBOSS_CLASSPATH");
        }
    }

    public synchronized void setJava2ClassLoadingCompliance(boolean loaderCompliance) {
        this._loaderCompliance = loaderCompliance;
    }

    public synchronized boolean getJava2ClassLoadingCompliance() {
        return this._loaderCompliance;
    }

    public synchronized void setUnpackWars(boolean unpackWars) {
        this._unpackWars = unpackWars;
    }

    public synchronized boolean getUnpackWars() {
        return this._unpackWars;
    }

    public synchronized void setWebDefaultResource(String webDefaultResource) {
        if (webDefaultResource != null) {
            URL webDefaultURL = this.findResourceInJar(webDefaultResource);
            if (webDefaultURL != null) {
                this._webDefaultResource = Jetty.fixURL(webDefaultURL.toString());
            } else {
                this._webDefaultResource = null;
                _log.warn((Object)("Cannot find resource for " + webDefaultResource + ": using default"));
            }
        } else {
            this._webDefaultResource = null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("webdefault specification is: " + this._webDefaultResource));
        }
    }

    public synchronized String getWebDefaultResource() {
        return this._webDefaultResource;
    }

    public synchronized void setSubjectAttributeName(String subjectAttributeName) {
        this._subjectAttributeName = subjectAttributeName;
    }

    public synchronized String getSubjectAttributeName() {
        return this._subjectAttributeName;
    }

    public Element getConfigurationElement() {
        return this._configElement;
    }

    public void setConfigurationElement(Element configElement) {
        this._configElement = configElement;
        try {
            DOMSource source = new DOMSource(configElement);
            CharArrayWriter writer = new CharArrayWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            this._xmlConfigString = writer.toString();
            int index = this._xmlConfigString.indexOf("?>");
            if (index >= 0) {
                index += 2;
                while (this._xmlConfigString.charAt(index) == '\n' || this._xmlConfigString.charAt(index) == '\r') {
                    ++index;
                }
            }
            this._xmlConfigString = this._xmlConfigString.substring(index);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Passing xml config to jetty:\n" + this._xmlConfigString));
            }
            this.setXMLConfiguration(this._xmlConfigString);
        }
        catch (TransformerConfigurationException tce) {
            _log.error((Object)"Can't transform config Element -> xml:", (Throwable)tce);
        }
        catch (TransformerException te) {
            _log.error((Object)"Can't transform config Element -> xml:", (Throwable)te);
        }
        catch (Exception e) {
            _log.error((Object)"Unexpected exception converting configuration Element -> xml", (Throwable)e);
        }
    }

    private void setXMLConfiguration(String xmlString) {
        try {
            XmlConfiguration xmlConfigurator = new XmlConfiguration(xmlString);
            xmlConfigurator.configure((Object)this);
        }
        catch (Exception e) {
            _log.error((Object)"problem configuring Jetty:", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebApplication deploy(WebApplication wa, String warUrl, AbstractWebContainer.WebDescriptorParser descriptorParser) throws DeploymentException {
        String contextPath = wa.getMetaData().getContextRoot();
        try {
            int i;
            MultiException me2;
            wa.setURL(new URL(warUrl));
            if (this.getContext(null, contextPath, 0) != null) {
                _log.warn((Object)("A WebApplication is already deployed in context '" + contextPath + "' - proceed at your own risk."));
            }
            JBossWebApplicationContext app = new JBossWebApplicationContext(this, descriptorParser, wa, warUrl);
            app.setContextPath(contextPath);
            Manager manager = this.getDistributableSessionManagerPrototype();
            if (manager != null) {
                app.setDistributableSessionManager((Manager)manager.clone());
                if (this.getForceDistributable()) {
                    app.setDistributable(true);
                }
            }
            app.setExtractWAR(this.getUnpackWars());
            if (this.getWebDefaultResource() != null) {
                app.setDefaultsDescriptor(this.getWebDefaultResource());
            }
            Iterator hosts = wa.getMetaData().getVirtualHosts();
            while (true) {
                if (!hosts.hasNext()) {
                    this.addContext((HttpContext)app);
                    this._deployed.put(warUrl, app);
                    try {
                        app.start();
                        _log.info((Object)("successfully deployed " + warUrl + " to " + contextPath));
                        return wa;
                    }
                    catch (MultiException me2) {
                        _log.warn((Object)("problem deploying " + warUrl + " to " + contextPath));
                        i = 0;
                        break;
                    }
                }
                app.addVirtualHost((String)hosts.next());
            }
            while (true) {
                if (i >= me2.size()) {
                    return wa;
                }
                Exception e = me2.getException(i);
                _log.warn((Object)e, (Throwable)e);
                ++i;
            }
        }
        catch (DeploymentException e) {
            this.undeploy(warUrl);
            throw e;
        }
        catch (Exception e) {
            this.undeploy(warUrl);
            throw new DeploymentException((Throwable)e);
        }
    }

    public void undeploy(String warUrl) throws DeploymentException {
        JBossWebApplicationContext app = (JBossWebApplicationContext)((Object)this._deployed.get(warUrl));
        if (app == null) {
            _log.warn((Object)("app (" + warUrl + ") not currently deployed"));
        } else {
            try {
                app.stop(app.getStopGracefully());
                this.removeContext((HttpContext)app);
                app = null;
                _log.info((Object)("Successfully undeployed " + warUrl));
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        this._deployed.remove(warUrl);
    }

    public boolean isDeployed(String warUrl) {
        return this._deployed.get(warUrl) != null;
    }

    public URL findResourceInJar(String name) {
        URL url = null;
        try {
            url = ((Object)((Object)this)).getClass().getClassLoader().getResource(name);
        }
        catch (Exception e) {
            _log.error((Object)("Could not find resource: " + name), (Throwable)e);
        }
        return url;
    }

    static String fixURL(String url) {
        int index = url.indexOf(33);
        index = index >= 0 ? url.lastIndexOf(47, index) : url.lastIndexOf(47);
        if (index >= 0) {
            return url.substring(0, index) + "/." + url.substring(index);
        }
        return url;
    }

    public String[] getCompileClasspath(ClassLoader cl) {
        return this._service.getCompileClasspath(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpContext service(HttpRequest request, HttpResponse response) throws IOException, HttpException {
        try {
            HttpContext httpContext = super.service(request, response);
            Object var5_4 = null;
            return httpContext;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    public void setDistributableSessionManagerPrototype(Manager manager) {
        this._distributableSessionManagerPrototype = manager;
    }

    public Manager getDistributableSessionManagerPrototype() {
        return this._distributableSessionManagerPrototype;
    }

    public boolean getForceDistributable() {
        return this._forceDistributable;
    }

    public void setForceDistributable(boolean distributable) {
        this._forceDistributable = distributable;
    }

    public boolean getSupportJSR77() {
        return this._supportJSR77;
    }

    public void setSupportJSR77(boolean graceful) {
        this._supportJSR77 = graceful;
    }

    public boolean getStopWebApplicationsGracefully() {
        return this._stopWebApplicationsGracefully;
    }

    public void setStopWebApplicationsGracefully(boolean graceful) {
        this._stopWebApplicationsGracefully = graceful;
    }
}

