/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.shared;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpProxy {
    protected static Log _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.codehaus.wadi.shared.HttpProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = LogFactory.getLog((Class)clazz);
    }

    public static boolean proxy(String hostname, int port, HttpServletRequest request, HttpServletResponse response) {
        GetMethod method = null;
        String m = request.getMethod();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("method=" + m));
        }
        if (!m.equals("GET")) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("method NYI: " + m));
            }
            return false;
        }
        method = new GetMethod();
        String cpath = String.valueOf(request.getContextPath()) + request.getServletPath();
        if (request.isRequestedSessionIdFromURL()) {
            cpath = String.valueOf(cpath) + ";jsessionid=" + request.getRequestedSessionId();
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("cpath::" + cpath));
        }
        method.setPath(cpath);
        method.setQueryString(request.getQueryString());
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            String values = "";
            Enumeration f = request.getHeaders(header);
            while (f.hasMoreElements()) {
                Object value = f.nextElement();
                values = String.valueOf(values) + (values.length() > 0 ? "," : "") + value;
            }
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("req - Header: " + header + ": " + values));
            }
            method.setRequestHeader(header, values);
        }
        HttpState state = new HttpState();
        javax.servlet.http.Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                String path;
                javax.servlet.http.Cookie c = cookies[i];
                String domain = c.getDomain();
                if (domain == null) {
                    domain = "192.168.0.2";
                }
                if ((path = c.getPath()) == null) {
                    path = request.getContextPath();
                }
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("PATH: value=" + path + " length=" + (path == null ? 0 : path.length())));
                }
                Cookie cookie = new Cookie(domain, c.getName(), c.getValue(), path, c.getMaxAge(), c.getSecure());
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("Cookie: " + cookie.getDomain() + "," + cookie.getName() + "," + cookie.getValue() + "," + cookie.getPath() + "," + cookie.getExpiryDate() + "," + cookie.getSecure()));
                }
                state.addCookie(cookie);
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("Cookie: " + cookie.toString()));
                }
                ++i;
            }
        }
        String scheme = request.getScheme();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("proxying request to: " + scheme + "://" + hostname + ":" + port));
        }
        try {
            HttpClient client = new HttpClient();
            HostConfiguration hc = new HostConfiguration();
            hc.setHost(hostname, port);
            client.executeMethod(hc, (HttpMethod)method, state);
        }
        catch (IOException e2) {
            _log.warn((Object)"problem proxying connection:", (Throwable)e2);
        }
        Header[] headers = method.getResponseHeaders();
        int i = 0;
        while (i < headers.length) {
            String header = headers[i].toExternalForm();
            int colon = header.indexOf(58);
            String name = header.substring(0, colon).trim();
            String value = header.substring(colon + 1, header.length()).trim();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("res - Header: " + name + ": " + value));
            }
            if (!name.equals("Transfer-Encoding")) {
                response.setHeader(name, value);
            }
            ++i;
        }
        Cookie[] cookee = state.getCookies();
        int i2 = 0;
        while (i2 < cookee.length) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("res - Cookie: " + cookee[i2] + ", domain=" + cookee[i2].getDomain() + ", path=" + cookee[i2].getPath()));
            }
            ++i2;
        }
        try {
            InputStream is;
            response.flushBuffer();
            if (method instanceof EntityEnclosingMethod) {
                ((EntityEnclosingMethod)method).setRequestBody((InputStream)request.getInputStream());
            }
            if ((is = method.getResponseBodyAsStream()) != null) {
                Thread res = new Thread(new StreamCopy(is, (OutputStream)response.getOutputStream()));
                res.start();
                res.join();
                is.close();
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("null response body - failed request - is " + hostname + ";" + port + " available ?"));
            }
            _log.trace((Object)"response successfully transferred");
            return true;
        }
        catch (IOException e3) {
            _log.warn((Object)"problem proxying connection:", (Throwable)e3);
        }
        catch (InterruptedException e4) {
            _log.warn((Object)"problem proxying connection:", (Throwable)e4);
        }
        return false;
    }

    public static class StreamCopy
    implements Runnable {
        protected final InputStream _is;
        protected final OutputStream _os;

        public StreamCopy(InputStream is, OutputStream os) {
            this._is = is;
            this._os = os;
        }

        public void run() {
            byte[] b = new byte[1024];
            try {
                int bytes;
                while ((bytes = this._is.read(b)) > -1) {
                    this._os.write(b, 0, bytes);
                }
                this._os.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

