/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.test;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SyncMap;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.shared.RWLock;

public class TestConcurrency
extends TestCase {
    protected Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected int _priority = 11;
    final int INVALIDATION_PRIORITY = 3;
    final int TIMEOUT_PRIORITY = 2;
    final int EMMIGRATION_PRIORITY = 1;
    final int EVICTION_PRIORITY = 0;
    final int MAX_PRIORITY = 3;
    protected boolean _first = true;

    public TestConcurrency(String name) {
        super(name);
    }

    protected long testMap(Map map) {
        String s;
        int iters;
        long start = System.currentTimeMillis();
        int i = iters = 100;
        while (i > 0) {
            s = "" + i;
            map.put(s, s);
            --i;
        }
        i = iters;
        while (i > 0) {
            s = "" + i;
            Assert.assertTrue((boolean)map.get(s).equals(s));
            --i;
        }
        i = iters;
        while (i > 0) {
            s = "" + i;
            map.remove(s);
            --i;
        }
        Assert.assertTrue((map.size() == 0 ? 1 : 0) != 0);
        long end = System.currentTimeMillis();
        return end - start;
    }

    public void testMaps() throws Exception {
        System.out.println("HashMap:                                " + this.testMap(new HashMap()));
        System.out.println("ConcurrentReaderHashMap:                " + this.testMap((Map)new ConcurrentReaderHashMap()));
        System.out.println("ConcurrentHashMap:                      " + this.testMap((Map)new ConcurrentHashMap()));
        System.out.println("HashMap:                                " + this.testMap(new HashMap()));
        System.out.println("Mutex(HashMap):                         " + this.testMap((Map)new SyncMap(new HashMap(), (Sync)new Mutex())));
        System.out.println("WriterPreferenceReadWriteLock(HashMap): " + this.testMap((Map)new SyncMap(new HashMap(), (ReadWriteLock)new WriterPreferenceReadWriteLock())));
        Assert.assertTrue((boolean)true);
    }

    public void testIterator() {
        ConcurrentReaderHashMap map = new ConcurrentReaderHashMap();
        map.put("a", "1");
        map.put("b", "2");
        map.put("c", "3");
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            System.out.println("removing element...");
            i.next();
            i.remove();
        }
        Assert.assertTrue((map.size() == 0 ? 1 : 0) != 0);
    }

    public void priority(final boolean acquire) throws Exception {
        final RWLock lock = new RWLock(3);
        Thread[] threads = new Thread[4];
        lock.setPriority(0);
        lock.readLock().attempt(60000L);
        int i = 0;
        while (i <= 3) {
            Thread t;
            final int p = i;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("starting: " + p));
            }
            threads[i] = t = new Thread(){

                public void run() {
                    try {
                        lock.setPriority(p);
                        if (acquire) {
                            lock.writeLock().acquire();
                        } else {
                            lock.writeLock().attempt(60000L);
                        }
                        int priority = lock.getPriority();
                        if (TestConcurrency.this._log.isInfoEnabled()) {
                            TestConcurrency.this._log.info((Object)("priority: " + priority));
                        }
                        Assert.assertTrue((priority < TestConcurrency.this._priority ? 1 : 0) != 0);
                        TestConcurrency.this._priority = priority;
                        lock.writeLock().release();
                    }
                    catch (Exception e) {
                        TestConcurrency.this._log.warn((Object)"oops", (Throwable)e);
                    }
                }
            };
            t.start();
            ++i;
        }
        Thread.yield();
        this._log.info((Object)"releasing read lock");
        lock.readLock().release();
        i = 0;
        while (i <= 3) {
            Thread t = threads[i];
            t.join();
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("joining: " + i));
            }
            ++i;
        }
    }

    public void testPriority() throws Exception {
        this._priority = 4;
        this.priority(true);
        this._priority = 4;
        this.priority(false);
    }

    public void testOverlap() throws Exception {
        final RWLock lock = new RWLock(3);
        lock.readLock().acquire();
        Thread t1 = new Thread(){

            public void run() {
                try {
                    lock.setPriority(0);
                    lock.writeLock().acquire();
                    TestConcurrency.this._log.info((Object)"I lost");
                    Assert.assertTrue((!TestConcurrency.this._first ? 1 : 0) != 0);
                    lock.writeLock().release();
                }
                catch (Exception e) {
                    TestConcurrency.this._log.warn((Object)e);
                }
            }
        };
        t1.start();
        lock.setPriority(3);
        lock.overlap();
        this._log.info((Object)"I won");
        Assert.assertTrue((this._first ? 1 : 0) != 0);
        this._first = false;
        lock.writeLock().release();
        t1.join();
    }
}

