/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.jetty.HttpSessionImpl;
import org.codehaus.wadi.jetty.Manager;
import org.codehaus.wadi.plugins.FilePassivationStrategy;
import org.codehaus.wadi.plugins.GZIPStreamingStrategy;
import org.codehaus.wadi.shared.SerializableContent;
import org.mortbay.http.HttpContext;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class TestHttpSession
extends TestCase {
    protected Log _log;
    protected Manager _manager;
    protected Listener _listener;
    protected List _events;
    static /* synthetic */ Class class$0;

    public TestHttpSession(String name) {
        super(name);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.codehaus.wadi.test.TestHttpSession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this._events = new ArrayList();
    }

    protected void setUp() throws Exception {
        this._manager = new Manager();
        WebApplicationHandler handler = new WebApplicationHandler();
        handler.initialize((HttpContext)new WebApplicationContext());
        handler.start();
        this._manager.initialize((ServletHandler)handler);
        this._listener = new Listener();
        this._manager.addEventListener((EventListener)((Object)this._listener));
        this._manager.start();
    }

    protected void tearDown() throws InterruptedException {
        this._manager.stop();
        this._manager.removeEventListener((EventListener)((Object)this._listener));
        this._listener = null;
        this._manager = null;
    }

    public void testCreateHttpSession() {
        this._events.clear();
        HttpSession session = this._manager.newHttpSession();
        Assert.assertTrue((!session.getAttributeNames().hasMoreElements() ? 1 : 0) != 0);
        Assert.assertTrue((session.getValueNames().length == 0 ? 1 : 0) != 0);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("sessionCreated"));
        Assert.assertTrue((pair.getEvent().getSession() == session ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testSetAttribute() {
        HttpSession session = this._manager.newHttpSession();
        this._events.clear();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueBound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeAdded"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testPutValue() {
        HttpSession session = this._manager.newHttpSession();
        this._events.clear();
        String key = "foo";
        Listener val = new Listener();
        session.putValue(key, (Object)val);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueBound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeAdded"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testGetAttribute() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        this._events.clear();
        Assert.assertTrue((session.getAttribute(key) == val ? 1 : 0) != 0);
    }

    public void testGetValue() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        this._events.clear();
        Assert.assertTrue((session.getValue(key) == val ? 1 : 0) != 0);
    }

    public void testRemoveAttribute() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        this._events.clear();
        session.removeAttribute(key);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueUnbound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeRemoved"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        Assert.assertTrue((session.getAttribute(key) == null ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testRemoveValue() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        this._events.clear();
        session.removeValue(key);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueUnbound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeRemoved"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        Assert.assertTrue((session.getAttribute(key) == null ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testSetAttributeNull() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        this._events.clear();
        session.setAttribute(key, null);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueUnbound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeRemoved"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        Assert.assertTrue((session.getAttribute(key) == null ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testPutValueNull() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener val = new Listener();
        session.setAttribute(key, (Object)val);
        this._events.clear();
        session.putValue(key, null);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueUnbound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeRemoved"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == val ? 1 : 0) != 0);
        Assert.assertTrue((session.getValue(key) == null ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testReplaceAttribute() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener oldVal = new Listener();
        Listener newVal = new Listener();
        session.setAttribute(key, (Object)oldVal);
        this._events.clear();
        session.setAttribute(key, (Object)newVal);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueUnbound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == oldVal ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueBound"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == newVal ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeReplaced"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == oldVal ? 1 : 0) != 0);
        Assert.assertTrue((session.getValue(key) == newVal ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    public void testReplaceValue() {
        HttpSession session = this._manager.newHttpSession();
        String key = "foo";
        Listener oldVal = new Listener();
        Listener newVal = new Listener();
        session.setAttribute(key, (Object)oldVal);
        this._events.clear();
        session.putValue(key, (Object)newVal);
        Pair pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueUnbound"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        HttpSessionBindingEvent be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == oldVal ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("valueBound"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == newVal ? 1 : 0) != 0);
        pair = (Pair)this._events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("attributeReplaced"));
        e = pair.getEvent();
        Assert.assertTrue((session == e.getSession() ? 1 : 0) != 0);
        be = (HttpSessionBindingEvent)e;
        Assert.assertTrue((be.getName() == key ? 1 : 0) != 0);
        Assert.assertTrue((be.getValue() == oldVal ? 1 : 0) != 0);
        Assert.assertTrue((session.getValue(key) == newVal ? 1 : 0) != 0);
        Assert.assertTrue((this._events.size() == 0 ? 1 : 0) != 0);
    }

    protected int enumerationLength(Enumeration e) {
        int i = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++i;
        }
        return i;
    }

    public void testGetAttributeNames() {
        HttpSession session = this._manager.newHttpSession();
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 0 ? 1 : 0) != 0);
        session.setAttribute("foo", (Object)"bar");
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 1 ? 1 : 0) != 0);
        session.setAttribute("bar", (Object)"baz");
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 2 ? 1 : 0) != 0);
        session.setAttribute("baz", (Object)"foo");
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 3 ? 1 : 0) != 0);
        session.setAttribute("baz", null);
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 2 ? 1 : 0) != 0);
        session.setAttribute("bar", null);
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 1 ? 1 : 0) != 0);
        session.setAttribute("foo", null);
        Assert.assertTrue((this.enumerationLength(session.getAttributeNames()) == 0 ? 1 : 0) != 0);
    }

    public void testGetValueNames() {
        HttpSession session = this._manager.newHttpSession();
        Assert.assertTrue((session.getValueNames().length == 0 ? 1 : 0) != 0);
        session.setAttribute("foo", (Object)"bar");
        Assert.assertTrue((session.getValueNames().length == 1 ? 1 : 0) != 0);
        session.setAttribute("bar", (Object)"baz");
        Assert.assertTrue((session.getValueNames().length == 2 ? 1 : 0) != 0);
        session.setAttribute("baz", (Object)"foo");
        Assert.assertTrue((session.getValueNames().length == 3 ? 1 : 0) != 0);
        session.setAttribute("baz", null);
        Assert.assertTrue((session.getValueNames().length == 2 ? 1 : 0) != 0);
        session.setAttribute("bar", null);
        Assert.assertTrue((session.getValueNames().length == 1 ? 1 : 0) != 0);
        session.setAttribute("foo", null);
        Assert.assertTrue((session.getValueNames().length == 0 ? 1 : 0) != 0);
    }

    public void testMaxInactiveInterval() {
    }

    public void testInvalidate() {
        HttpSession session = this._manager.newHttpSession();
        session.getId();
        session.invalidate();
        try {
            session.getId();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            session.invalidate();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testIsNew() {
        HttpSession session = this._manager.newHttpSession();
        Assert.assertTrue((boolean)session.isNew());
        ((org.codehaus.wadi.jetty.HttpSession)session).access();
        Assert.assertTrue((!session.isNew() ? 1 : 0) != 0);
    }

    public void testNullName() {
        HttpSession session = this._manager.newHttpSession();
        try {
            session.setAttribute(null, (Object)"a");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            session.getAttribute(null);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            session.removeAttribute(null);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            session.putValue(null, (Object)"a");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            session.getValue(null);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            session.removeValue(null);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public byte[] marshall(SerializableContent writer) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        writer.writeContent(oos);
        oos.flush();
        return baos.toByteArray();
    }

    public void demarshall(SerializableContent reader, byte[] buffer) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bais);
        reader.readContent(ois);
    }

    public void testActivation() throws Exception {
        HttpSessionImpl s0 = new HttpSessionImpl();
        s0.init(this._manager, "1234", 0L, 60, 60);
        List events = ActivationListener._events;
        events.clear();
        String key = "test";
        ActivationListener l = new ActivationListener();
        s0.setAttribute(key, l, false);
        byte[] buffer = this.marshall(s0);
        s0.getAttribute(key);
        Assert.assertTrue((events.size() == 2 ? 1 : 0) != 0);
        Pair pair = (Pair)events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("sessionWillPassivate"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((s0.getFacade() == e.getSession() ? 1 : 0) != 0);
        pair = (Pair)events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("sessionDidActivate"));
        e = pair.getEvent();
        Assert.assertTrue((s0.getFacade() == e.getSession() ? 1 : 0) != 0);
        HttpSessionImpl s1 = new HttpSessionImpl();
        this.demarshall(s1, buffer);
        s1.setWadiManager(this._manager);
        Assert.assertTrue((events.size() == 0 ? 1 : 0) != 0);
        s1.getAttribute(key);
        Assert.assertTrue((events.size() == 1 ? 1 : 0) != 0);
        Pair pair2 = (Pair)events.remove(0);
        Assert.assertTrue((pair2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair2.getType().equals("sessionDidActivate"));
        HttpSessionEvent e2 = pair2.getEvent();
        Assert.assertTrue((s1.getFacade() == e2.getSession() ? 1 : 0) != 0);
    }

    public void testMigration() {
        HttpSessionImpl impl1 = new HttpSessionImpl();
        String id = "test-httpsession";
        impl1.init(null, id, System.currentTimeMillis(), 1800, 1800);
        impl1.setWadiManager(this._manager);
        HttpSession s1 = impl1.getFacade();
        List events = ActivationListener._events;
        events.clear();
        String key = "test";
        ActivationListener l = new ActivationListener();
        impl1.setAttribute(key, l, false);
        FilePassivationStrategy fmp = new FilePassivationStrategy(new File("/tmp"));
        fmp.setStreamingStrategy(new GZIPStreamingStrategy());
        Assert.assertTrue((boolean)fmp.passivate(impl1));
        Assert.assertTrue((events.size() == 1 ? 1 : 0) != 0);
        Pair pair = (Pair)events.remove(0);
        Assert.assertTrue((pair != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair.getType().equals("sessionWillPassivate"));
        HttpSessionEvent e = pair.getEvent();
        Assert.assertTrue((s1 == e.getSession() ? 1 : 0) != 0);
        HttpSessionImpl impl2 = new HttpSessionImpl();
        Assert.assertTrue((boolean)fmp.activate(id, impl2));
        impl2.setWadiManager(this._manager);
        HttpSession s2 = impl2.getFacade();
        Assert.assertTrue((events.size() == 0 ? 1 : 0) != 0);
        impl2.getAttribute(key);
        Assert.assertTrue((events.size() == 1 ? 1 : 0) != 0);
        Pair pair2 = (Pair)events.remove(0);
        Assert.assertTrue((pair2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pair2.getType().equals("sessionDidActivate"));
        HttpSessionEvent e2 = pair2.getEvent();
        Assert.assertTrue((s2 == e2.getSession() ? 1 : 0) != 0);
        Assert.assertTrue((events.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((s1.getValueNames().length == s2.getValueNames().length ? 1 : 0) != 0);
        Enumeration e1 = s1.getAttributeNames();
        Enumeration e22 = s2.getAttributeNames();
        while (e1.hasMoreElements() && e22.hasMoreElements()) {
            Assert.assertTrue((boolean)((String)e1.nextElement()).equals((String)e22.nextElement()));
        }
    }

    static class Pair
    implements Serializable {
        String _type;
        HttpSessionEvent _event;

        Pair(String type, HttpSessionEvent event) {
            this._type = type;
            this._event = event;
        }

        String getType() {
            return this._type;
        }

        HttpSessionEvent getEvent() {
            return this._event;
        }

        public String toString() {
            return "<" + this._event.getSession().getId() + ":" + this._type + ">";
        }
    }

    class Listener
    implements HttpSessionListener,
    HttpSessionAttributeListener,
    HttpSessionBindingListener {
        Listener() {
        }

        public void sessionCreated(HttpSessionEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("sessionCreated", e));
        }

        public void sessionDestroyed(HttpSessionEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("sessionDestroyed", e));
        }

        public void attributeAdded(HttpSessionBindingEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("attributeAdded", (HttpSessionEvent)e));
        }

        public void attributeRemoved(HttpSessionBindingEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("attributeRemoved", (HttpSessionEvent)e));
        }

        public void attributeReplaced(HttpSessionBindingEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("attributeReplaced", (HttpSessionEvent)e));
        }

        public void valueBound(HttpSessionBindingEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("valueBound", (HttpSessionEvent)e));
        }

        public void valueUnbound(HttpSessionBindingEvent e) {
            e.getSession().getId();
            TestHttpSession.this._events.add(new Pair("valueUnbound", (HttpSessionEvent)e));
        }
    }

    static class ActivationListener
    implements HttpSessionActivationListener,
    Serializable {
        public static List _events = new ArrayList();
        protected static Log _log;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.codehaus.wadi.test.TestHttpSession$ActivationListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            _log = LogFactory.getLog((Class)clazz);
        }

        ActivationListener() {
        }

        public void sessionDidActivate(HttpSessionEvent e) {
            e.getSession().getId();
            _events.add(new Pair("sessionDidActivate", e));
            _log.trace((Object)"ACTIVATING");
        }

        public void sessionWillPassivate(HttpSessionEvent e) {
            e.getSession().getId();
            _events.add(new Pair("sessionWillPassivate", e));
            _log.trace((Object)"PASSIVATING");
        }
    }
}

