/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.test;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.jetty.HttpSessionImpl;
import org.codehaus.wadi.plugins.SimpleStreamingStrategy;
import org.codehaus.wadi.shared.MigrationService;

public class TestMigrationService
extends TestCase {
    protected final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected MigrationService.Server _server;
    protected MigrationService.Client _client;
    protected Map _serverSessions = new HashMap();
    protected Map _serverLocks = new HashMap();

    public TestMigrationService(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this._log.info((Object)"starting test");
        InetAddress.getByName("228.5.6.7");
        this._client = new MigrationService.Client();
        this._server = new MigrationService.Server(this._serverSessions, this._serverLocks, new SimpleStreamingStrategy());
        this._server.start();
    }

    protected void tearDown() throws InterruptedException {
        this._server.stop();
        this._server = null;
        this._client = null;
        this._log.info((Object)"stopping test");
    }

    public void testMigration() throws Exception {
        org.codehaus.wadi.tomcat.HttpSessionImpl session = new org.codehaus.wadi.tomcat.HttpSessionImpl();
        session.setId("" + System.currentTimeMillis());
        String id = session.getRealId();
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("session: " + id));
        }
        this._serverSessions.put(id, session);
        int serverPort = this._server.getPort();
        InetAddress serverAddress = this._server.getAddress();
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("server: " + serverAddress + ":" + serverPort));
        }
        HashMap clientSessions = new HashMap();
        HashMap clientLocks = new HashMap();
        Assert.assertTrue((this._serverSessions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this._serverSessions.containsKey(id));
        Assert.assertTrue((this._serverLocks.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((clientSessions.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!clientSessions.containsKey(id) ? 1 : 0) != 0);
        Assert.assertTrue((clientLocks.size() == 0 ? 1 : 0) != 0);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("_serverSessions: " + this._serverSessions + ", clientSessions:" + clientSessions));
        }
        this._client.run(clientSessions, clientLocks, id, new HttpSessionImpl(), serverAddress, serverPort, new SimpleStreamingStrategy());
        Assert.assertTrue((this._serverSessions.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!this._serverSessions.containsKey(id) ? 1 : 0) != 0);
        Assert.assertTrue((this._serverLocks.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((clientSessions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)clientSessions.containsKey(id));
        Assert.assertTrue((clientLocks.size() == 0 ? 1 : 0) != 0);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("serverSessions: " + this._serverSessions + ", clientSessions:" + clientSessions));
        }
    }
}

