/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.enhydra.jdbc.core.CoreDataSource;

public class StandardDataSource
extends CoreDataSource
implements DataSource {
    transient Driver driver = null;
    String driverName = "";
    String url = "";
    private int transIsolation = -1;
    private boolean loadedFromCCL = false;

    public StandardDataSource() {
    }

    protected StandardDataSource(Driver drv) throws SQLException {
        this();
        this.driver = drv;
        this.driverName = drv.getClass().getName();
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDriverName(String driverName) throws SQLException {
        if (!this.driverName.equals(driverName)) {
            this.driverName = driverName;
            this.driver = null;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTransactionIsolation(int level) {
        this.transIsolation = level;
    }

    public int getTransactionIsolation() {
        return this.transIsolation;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public synchronized Connection getConnection(String u, String p) throws SQLException {
        Connection ret = null;
        Properties prop = new Properties();
        if (u != null) {
            prop.put("user", u);
        }
        if (p != null) {
            prop.put("password", p);
        }
        if (this.url != null) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)Class.forName(this.driverName).newInstance();
                    this.loadedFromCCL = false;
                    this.log.debug("StandardDataSource:getConnection a new driver instance is created");
                }
                catch (Exception e) {
                    try {
                        this.driver = (Driver)Class.forName(this.driverName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                        this.loadedFromCCL = true;
                    }
                    catch (Exception e2) {
                        throw new SQLException("Error trying to load driver: " + this.driverName + " : " + e2.getMessage());
                    }
                }
            }
            try {
                ret = this.loadedFromCCL ? this.driver.connect(this.url, prop) : DriverManager.getConnection(this.url, prop);
                int transIsolation = this.getTransactionIsolation();
                if (transIsolation >= 0) {
                    ret.setTransactionIsolation(transIsolation);
                }
                this.log.debug("StandardDataSource:getConnection Connection from DriverManager is returned");
            }
            catch (SQLException e) {
                throw new SQLException("Cannot get connection for URL " + this.url + " : " + e.getMessage());
            }
        }
        return ret;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        ref.add(new StringRefAddr("driverName", this.getDriverName()));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.getLoginTimeout())));
        ref.add(new StringRefAddr("transIsolation", Integer.toString(this.getTransactionIsolation())));
        this.log.debug("StandardDataSource:getReference object returned");
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)refObj;
        this.setDriverName((String)ref.get("driverName").getContent());
        this.setUrl((String)ref.get("url").getContent());
        this.setUser((String)ref.get("user").getContent());
        this.setPassword((String)ref.get("password").getContent());
        this.setDescription((String)ref.get("description").getContent());
        this.setLoginTimeout(Integer.parseInt((String)ref.get("loginTimeout").getContent()));
        this.setTransactionIsolation(Integer.parseInt((String)ref.get("transIsolation").getContent()));
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardDataSource:\n");
        sb.append("     driver=<" + this.driver + ">\n");
        sb.append("     url=<" + this.url + ">\n");
        sb.append("     user=<" + this.user + ">\n");
        sb.append(super.toString());
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

