/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.SQLException;
import java.sql.Statement;
import org.enhydra.jdbc.core.CoreStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXAStatement
extends CoreStatement {
    private StandardXAConnectionHandle con;
    private boolean closed;
    private int resultSetType;
    private int resultSetConcurrency;

    StandardXAStatement(StandardXAConnectionHandle con, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.con = con;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.log = con.log;
        this.statement = this.newStatement();
    }

    private Statement newStatement() throws SQLException {
        if (this.resultSetType == 0 && this.resultSetConcurrency == 0) {
            return this.con.con.createStatement();
        }
        return this.con.con.createStatement(this.resultSetType, this.resultSetConcurrency);
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.closed = true;
    }

    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

