/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.config;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.config.ConfigurationBuilder;
import mx4j.tools.config.ConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultConfigurationBuilder
implements ConfigurationBuilder {
    public static final String SHUTDOWN_COMMAND = "shutdown";
    public static final String RESTART_COMMAND = "restart";
    private static final String NULL = "null";
    static /* synthetic */ Class class$mx4j$tools$config$DefaultConfigurationBuilder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$mx4j$tools$config$DefaultConfigurationBuilder$Object;

    public ConfigurationBuilder.Node createConfigurationNode(Element node) throws ConfigurationException {
        String loweredName = node.getNodeName().toLowerCase();
        StringBuffer buffer = new StringBuffer(loweredName);
        buffer.replace(0, 1, loweredName.substring(0, 1).toUpperCase());
        String className = this.getClass().getName() + "$" + buffer.toString();
        try {
            Logger logger = DefaultConfigurationBuilder.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Creating configuration node " + className);
            }
            return (ConfigurationBuilder.Node)this.getClass().getClassLoader().loadClass(className).newInstance();
        }
        catch (Exception x) {
            throw new ConfigurationException(x);
        }
    }

    private static Logger getLogger() {
        return Log.getLogger((class$mx4j$tools$config$DefaultConfigurationBuilder == null ? (class$mx4j$tools$config$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("mx4j.tools.config.DefaultConfigurationBuilder")) : class$mx4j$tools$config$DefaultConfigurationBuilder).getName());
    }

    private static Class[] getMethodSignature(ConfigurationBuilder.Node node) throws ConfigurationException {
        List children = node.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList<Class> signature = new ArrayList<Class>();
        for (int i = 0; i < children.size(); ++i) {
            ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(i);
            if (!(child instanceof Arg)) continue;
            Arg arg = (Arg)child;
            signature.add(arg.getJavaType());
        }
        return signature.toArray(new Class[signature.size()]);
    }

    private static String[] getJMXMethodSignature(ConfigurationBuilder.Node node) throws ConfigurationException {
        Class[] signature = DefaultConfigurationBuilder.getMethodSignature(node);
        if (signature == null) {
            return null;
        }
        ArrayList<String> jmxSignature = new ArrayList<String>();
        for (int i = 0; i < signature.length; ++i) {
            jmxSignature.add(signature[i].getName());
        }
        return jmxSignature.toArray(new String[jmxSignature.size()]);
    }

    private static java.lang.Object[] getMethodArguments(ConfigurationBuilder.Node node, MBeanServer server) throws ConfigurationException {
        List children = node.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList<java.lang.Object> arguments = new ArrayList<java.lang.Object>();
        for (int i = 0; i < children.size(); ++i) {
            ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(i);
            if (!(child instanceof Arg)) continue;
            Arg arg = (Arg)child;
            arguments.add(arg.configure(server));
        }
        return arguments.toArray();
    }

    private static Class loadClass(String className) throws ConfigurationException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationException(x);
        }
    }

    private static java.lang.Object getObject(ConfigurationBuilder.Node node, String key) {
        while (node != null) {
            ConfigurationBuilder.ObjectsHolder holder;
            if (node instanceof ConfigurationBuilder.ObjectsHolder && (holder = (ConfigurationBuilder.ObjectsHolder)((java.lang.Object)node)).containsKey(key)) {
                return holder.getObject(key);
            }
            node = node.getParent();
        }
        return null;
    }

    private static void putObject(ConfigurationBuilder.Node node, String key, java.lang.Object value) {
        while (node != null) {
            if (node instanceof ConfigurationBuilder.ObjectsHolder) {
                ConfigurationBuilder.ObjectsHolder holder = (ConfigurationBuilder.ObjectsHolder)((java.lang.Object)node);
                holder.putObject(key, value);
            }
            node = node.getParent();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Call
    extends AbstractNode {
        private String classname;
        private ObjectName objectname;
        private String refobjectid;
        private String method;
        private String operation;
        private String attribute;

        public void setClassname(String classname) {
            this.classname = classname;
        }

        public void setObjectname(String name) throws MalformedObjectNameException {
            if (name != null && !DefaultConfigurationBuilder.NULL.equals(name)) {
                this.objectname = ObjectName.getInstance(name);
            }
        }

        public void setRefobjectid(String refid) {
            this.refobjectid = refid;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            if (this.classname != null) {
                Class cls = DefaultConfigurationBuilder.loadClass(this.classname);
                try {
                    Method mthd = cls.getMethod(this.method, DefaultConfigurationBuilder.getMethodSignature(this));
                    return mthd.invoke(null, DefaultConfigurationBuilder.getMethodArguments(this, server));
                }
                catch (InvocationTargetException x) {
                    throw new ConfigurationException(x.getTargetException());
                }
                catch (ConfigurationException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new ConfigurationException(x);
                }
            }
            if (this.objectname != null) {
                if (this.operation != null) {
                    try {
                        return server.invoke(this.objectname, this.operation, DefaultConfigurationBuilder.getMethodArguments(this, server), DefaultConfigurationBuilder.getJMXMethodSignature(this));
                    }
                    catch (ConfigurationException x) {
                        throw x;
                    }
                    catch (Exception x) {
                        throw new ConfigurationException(x);
                    }
                }
                if (this.attribute != null) {
                    try {
                        List children = this.getChildren();
                        if (children == null || children.size() < 1) {
                            return server.getAttribute(this.objectname, this.attribute);
                        }
                        java.lang.Object arg = DefaultConfigurationBuilder.getMethodArguments(this, server)[0];
                        server.setAttribute(this.objectname, new Attribute(this.attribute, arg));
                        return null;
                    }
                    catch (ConfigurationException x) {
                        throw x;
                    }
                    catch (Exception x) {
                        throw new ConfigurationException(x);
                    }
                }
                throw new ConfigurationException("Missing 'attribute' or 'operation' attribute in JMX call");
            }
            java.lang.Object target = null;
            if (this.refobjectid != null) {
                target = DefaultConfigurationBuilder.getObject(this, this.refobjectid);
                if (target == null) {
                    throw new ConfigurationException("Could not find object with id " + this.refobjectid);
                }
                try {
                    Method mthd = target.getClass().getMethod(this.method, DefaultConfigurationBuilder.getMethodSignature(this));
                    return mthd.invoke(target, DefaultConfigurationBuilder.getMethodArguments(this, server));
                }
                catch (InvocationTargetException x) {
                    throw new ConfigurationException(x.getTargetException());
                }
                catch (ConfigurationException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new ConfigurationException(x);
                }
            }
            throw new ConfigurationException("Missing 'refobjectid' attribute in call element");
        }
    }

    public static class Create
    extends AbstractNode {
        private String classname;
        private ObjectName objectname;
        private String loadername;

        public void setClassname(String classname) {
            this.classname = classname;
        }

        public void setObjectname(String name) throws MalformedObjectNameException {
            if (name != null && !DefaultConfigurationBuilder.NULL.equals(name)) {
                this.objectname = ObjectName.getInstance(name);
            }
        }

        public void setLoadername(String name) throws MalformedObjectNameException {
            this.loadername = name;
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            try {
                if (this.loadername != null) {
                    ObjectName loader = null;
                    if (!DefaultConfigurationBuilder.NULL.equals(this.loadername)) {
                        loader = ObjectName.getInstance(this.loadername);
                    }
                    return server.createMBean(this.classname, this.objectname, loader, DefaultConfigurationBuilder.getMethodArguments(this, server), DefaultConfigurationBuilder.getJMXMethodSignature(this));
                }
                return server.createMBean(this.classname, this.objectname, DefaultConfigurationBuilder.getMethodArguments(this, server), DefaultConfigurationBuilder.getJMXMethodSignature(this));
            }
            catch (ConfigurationException x) {
                throw x;
            }
            catch (Exception x) {
                throw new ConfigurationException(x);
            }
        }
    }

    public static class Unregister
    extends AbstractNode {
        private ObjectName objectname;

        public void setObjectname(String name) throws MalformedObjectNameException {
            this.objectname = ObjectName.getInstance(name);
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            try {
                server.unregisterMBean(this.objectname);
                return null;
            }
            catch (Exception x) {
                throw new ConfigurationException(x);
            }
        }
    }

    public static class Register
    extends AbstractNode {
        private ObjectName objectname;

        public void setObjectname(String name) throws MalformedObjectNameException {
            if (name != null && !DefaultConfigurationBuilder.NULL.equals(name)) {
                this.objectname = ObjectName.getInstance(name);
            }
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            List children = this.getChildren();
            if (children != null && children.size() > 0) {
                ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(0);
                try {
                    return server.registerMBean(child.configure(server), this.objectname);
                }
                catch (ConfigurationException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new ConfigurationException(x);
                }
            }
            return null;
        }
    }

    public static class Arg
    extends AbstractNode {
        private static final String OBJECT_TYPE = "object";
        private static final String STRING_TYPE = "string";
        private static final String BOOLEAN_TYPE = "boolean";
        private static final String BYTE_TYPE = "byte";
        private static final String CHAR_TYPE = "char";
        private static final String DOUBLE_TYPE = "double";
        private static final String FLOAT_TYPE = "float";
        private static final String INT_TYPE = "int";
        private static final String LONG_TYPE = "long";
        private static final String SHORT_TYPE = "short";
        private String type;
        private String refobjectid;

        public void setType(String type) {
            this.type = type;
        }

        public void setRefobjectid(String refobjectid) {
            this.refobjectid = refobjectid;
        }

        public Class getJavaType() throws ConfigurationException {
            if (STRING_TYPE.equalsIgnoreCase(this.type)) {
                return class$java$lang$String == null ? (class$java$lang$String = DefaultConfigurationBuilder.class$("java.lang.String")) : class$java$lang$String;
            }
            if (OBJECT_TYPE.equalsIgnoreCase(this.type)) {
                return class$mx4j$tools$config$DefaultConfigurationBuilder$Object == null ? (class$mx4j$tools$config$DefaultConfigurationBuilder$Object = DefaultConfigurationBuilder.class$("mx4j.tools.config.DefaultConfigurationBuilder$Object")) : class$mx4j$tools$config$DefaultConfigurationBuilder$Object;
            }
            if (BOOLEAN_TYPE.equalsIgnoreCase(this.type)) {
                return Boolean.TYPE;
            }
            if (BYTE_TYPE.equalsIgnoreCase(this.type)) {
                return Byte.TYPE;
            }
            if (CHAR_TYPE.equalsIgnoreCase(this.type)) {
                return Character.TYPE;
            }
            if (DOUBLE_TYPE.equalsIgnoreCase(this.type)) {
                return Double.TYPE;
            }
            if (FLOAT_TYPE.equalsIgnoreCase(this.type)) {
                return Float.TYPE;
            }
            if (INT_TYPE.equalsIgnoreCase(this.type)) {
                return Integer.TYPE;
            }
            if (LONG_TYPE.equalsIgnoreCase(this.type)) {
                return Long.TYPE;
            }
            if (SHORT_TYPE.equalsIgnoreCase(this.type)) {
                return Short.TYPE;
            }
            return DefaultConfigurationBuilder.loadClass(this.type);
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            if (this.refobjectid != null) {
                return DefaultConfigurationBuilder.getObject(this, this.refobjectid);
            }
            List children = this.getChildren();
            if (children != null && children.size() > 0) {
                ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(0);
                return child.configure(server);
            }
            String text = this.getText();
            if (text == null || DefaultConfigurationBuilder.NULL.equals(text)) {
                return null;
            }
            if (STRING_TYPE.equalsIgnoreCase(this.type)) {
                return text;
            }
            if (OBJECT_TYPE.equalsIgnoreCase(this.type)) {
                return text;
            }
            if (BOOLEAN_TYPE.equalsIgnoreCase(this.type)) {
                return Boolean.valueOf(text);
            }
            if (BYTE_TYPE.equalsIgnoreCase(this.type)) {
                return Byte.valueOf(text);
            }
            if (CHAR_TYPE.equalsIgnoreCase(this.type)) {
                return new Character(text.length() < 1 ? (char)'\u0000' : text.charAt(0));
            }
            if (DOUBLE_TYPE.equalsIgnoreCase(this.type)) {
                return Double.valueOf(text);
            }
            if (FLOAT_TYPE.equalsIgnoreCase(this.type)) {
                return Float.valueOf(text);
            }
            if (INT_TYPE.equalsIgnoreCase(this.type)) {
                return Integer.valueOf(text);
            }
            if (LONG_TYPE.equalsIgnoreCase(this.type)) {
                return Long.valueOf(text);
            }
            if (SHORT_TYPE.equalsIgnoreCase(this.type)) {
                return Short.valueOf(text);
            }
            try {
                Constructor ctor = this.getJavaType().getConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultConfigurationBuilder.class$("java.lang.String")) : class$java$lang$String);
                return ctor.newInstance(text);
            }
            catch (InvocationTargetException x) {
                throw new ConfigurationException(x.getTargetException());
            }
            catch (ConfigurationException x) {
                throw x;
            }
            catch (Exception x) {
                throw new ConfigurationException(x);
            }
        }
    }

    public static class New
    extends AbstractNode {
        private String classname;

        public void setClassname(String classname) {
            this.classname = classname;
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            try {
                Class cls = DefaultConfigurationBuilder.loadClass(this.classname);
                Constructor ctor = cls.getConstructor(DefaultConfigurationBuilder.getMethodSignature(this));
                return ctor.newInstance(DefaultConfigurationBuilder.getMethodArguments(this, server));
            }
            catch (InvocationTargetException x) {
                throw new ConfigurationException(x.getTargetException());
            }
            catch (ConfigurationException x) {
                throw x;
            }
            catch (Exception x) {
                throw new ConfigurationException(x);
            }
        }
    }

    public static class Object
    extends AbstractNode {
        private String id;

        public void setObjectid(String id) {
            this.id = id;
        }

        public String getObjectid() {
            return this.id;
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            List children = this.getChildren();
            java.lang.Object result = null;
            if (children != null && children.size() > 0) {
                ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(0);
                result = child.configure(server);
            }
            DefaultConfigurationBuilder.putObject(this, this.id, result);
            return result;
        }
    }

    public static class Shutdown
    extends AbstractNode {
        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            List children = this.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(i);
                    child.configure(server);
                }
            }
            return null;
        }
    }

    public static class Startup
    extends AbstractNode {
        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            List children = this.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(i);
                    child.configure(server);
                }
            }
            return null;
        }
    }

    public static class Configuration
    extends AbstractNode
    implements ConfigurationBuilder.ObjectsHolder,
    Runnable {
        private Map objects;
        private int port = -1;
        private MBeanServer server;
        private Thread thread;

        public void setPort(String portString) {
            this.port = Integer.parseInt(portString);
        }

        public java.lang.Object configure(MBeanServer server) throws ConfigurationException {
            if (server != null) {
                this.server = server;
                return this.startup(server);
            }
            return this.shutdown(this.server);
        }

        private java.lang.Object startup(MBeanServer server) throws ConfigurationException {
            Logger logger = DefaultConfigurationBuilder.getLogger();
            List children = this.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(i);
                    if (!(child instanceof Startup)) continue;
                    child.configure(server);
                }
            }
            if (this.port > 0) {
                this.thread = new Thread((Runnable)this, "Configuration Shutdown");
                if (logger.isEnabledFor(0)) {
                    logger.trace("Starting " + this.thread.getName() + " Thread on port " + this.port);
                }
                this.thread.start();
            }
            return null;
        }

        private java.lang.Object shutdown(MBeanServer server) throws ConfigurationException {
            Logger logger = DefaultConfigurationBuilder.getLogger();
            List children = this.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    ConfigurationBuilder.Node child = (ConfigurationBuilder.Node)children.get(i);
                    if (!(child instanceof Shutdown)) continue;
                    child.configure(server);
                }
            }
            if (this.port > 0) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Stopping " + this.thread.getName() + " Thread on port " + this.port);
                }
                this.thread.interrupt();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block24: {
                ServerSocket server;
                Logger logger;
                block23: {
                    logger = DefaultConfigurationBuilder.getLogger();
                    server = null;
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Started " + this.thread.getName() + " Thread on port " + this.port);
                    }
                    server = new ServerSocket(this.port, 50, InetAddress.getByName(null));
                    server.setSoTimeout(1000);
                    byte[] buffer = new byte[64];
                    StringBuffer command = new StringBuffer();
                    while (!this.thread.isInterrupted()) {
                        Socket client = null;
                        try {
                            client = server.accept();
                        }
                        catch (InterruptedIOException x) {
                            continue;
                        }
                        if (logger.isEnabledFor(0)) {
                            logger.trace("Client connected " + client);
                        }
                        BufferedInputStream is = new BufferedInputStream(client.getInputStream());
                        command.setLength(0);
                        int read = -1;
                        while ((read = ((InputStream)is).read(buffer)) >= 0) {
                            command.append(new String(buffer, 0, read));
                        }
                        String cmd = command.toString();
                        if (logger.isEnabledFor(0)) {
                            logger.trace("Got command '" + cmd + "'");
                        }
                        if (!DefaultConfigurationBuilder.SHUTDOWN_COMMAND.equals(cmd)) continue;
                        try {
                            this.configure(null);
                            break;
                        }
                        catch (ConfigurationException x) {
                            if (!logger.isEnabledFor(30)) continue;
                            logger.warn("Bad configuration for shutdown", x);
                        }
                    }
                    java.lang.Object var11_12 = null;
                    if (!logger.isEnabledFor(0)) break block23;
                    logger.trace("Stopped " + this.thread.getName() + " Thread on port " + this.port);
                }
                try {
                    if (server != null) {
                        server.close();
                    }
                    break block24;
                }
                catch (IOException x2) {}
                break block24;
                {
                    catch (Exception x) {
                        if (logger.isEnabledFor(20)) {
                            logger.info("Caught Exception in " + this.thread.getName() + " Thread, exiting", x);
                        }
                        java.lang.Object var11_13 = null;
                        if (logger.isEnabledFor(0)) {
                            logger.trace("Stopped " + this.thread.getName() + " Thread on port " + this.port);
                        }
                        try {
                            if (server != null) {
                                server.close();
                            }
                            break block24;
                        }
                        catch (IOException x2) {}
                    }
                }
                catch (Throwable throwable) {
                    java.lang.Object var11_14 = null;
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Stopped " + this.thread.getName() + " Thread on port " + this.port);
                    }
                    try {
                        if (server != null) {
                            server.close();
                        }
                    }
                    catch (IOException x2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public java.lang.Object getObject(String key) {
            if (this.objects == null) {
                return null;
            }
            return this.objects.get(key);
        }

        public java.lang.Object putObject(String key, java.lang.Object value) {
            if (this.objects == null) {
                this.objects = new HashMap();
            }
            return this.objects.put(key, value);
        }

        public boolean containsKey(String key) {
            if (this.objects == null) {
                return false;
            }
            return this.objects.containsKey(key);
        }
    }

    public static abstract class AbstractNode
    implements ConfigurationBuilder.Node {
        private String text;
        private ConfigurationBuilder.Node parent;
        private List children;

        public void setText(String text) {
            this.text = text;
        }

        public void setParent(ConfigurationBuilder.Node parent) {
            this.parent = parent;
        }

        public void addChild(ConfigurationBuilder.Node child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.setParent(this);
            this.children.add(child);
        }

        protected String getText() {
            return this.text;
        }

        public ConfigurationBuilder.Node getParent() {
            return this.parent;
        }

        public List getChildren() {
            return this.children;
        }

        public void setAttributes(NamedNodeMap attributes) throws ConfigurationException {
            Logger logger = DefaultConfigurationBuilder.getLogger();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                String setterName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Calling " + setterName + " with " + value + " on " + this);
                    }
                    Method setter = this.getClass().getMethod(setterName, class$java$lang$String == null ? DefaultConfigurationBuilder.class$("java.lang.String") : class$java$lang$String);
                    setter.invoke((java.lang.Object)this, value);
                    continue;
                }
                catch (InvocationTargetException x) {
                    throw new ConfigurationException(x.getTargetException());
                }
                catch (Exception x) {
                    throw new ConfigurationException(x);
                }
            }
        }
    }
}

