/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.resolver.soap;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Logger;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.soap.ClientSOAPConnection;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AdminClient;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.utils.Options;

public class SOAPResolver
extends ConnectionResolver {
    private static final String SERVICE_JMX_SOAP = "service:jmx:soap";
    private static final String ID_CONTEXT = "/id/";
    private static final String SERVER_DEPLOY_WSDD = "server-deploy.wsdd";
    private static final String SERVER_UNDEPLOY_WSDD = "server-undeploy.wsdd";
    private static final String CLIENT_WSDD = "client.wsdd";
    private static int connectorID;
    private final Map mbeanServerIds = new HashMap();
    static /* synthetic */ Class class$mx4j$tools$remote$resolver$soap$SOAPResolver;

    public Object lookupClient(JMXServiceURL address, Map environment) throws IOException {
        String endpoint = this.getEndpoint(address, environment);
        InputStream wsdd = this.getClass().getResourceAsStream(CLIENT_WSDD);
        if (wsdd == null) {
            throw new IOException("Could not find AXIS deployment descriptor");
        }
        Service service = new Service((EngineConfiguration)new FileProvider(wsdd));
        service.setMaintainSession(true);
        return new ClientSOAPConnection(endpoint, service);
    }

    public Object bindClient(Object client, Map environment) throws IOException {
        return client;
    }

    private String getEndpoint(JMXServiceURL address, Map environment) {
        String transport = this.getTransportProtocol(environment);
        return transport + this.getEndpointPath(address);
    }

    private String getTransportProtocol(Map environment) {
        String transport = null;
        if (environment != null) {
            transport = (String)environment.get("jmx.remote.x.soap.transport.protocol");
        }
        if (transport == null || transport.length() == 0) {
            transport = "http";
        }
        transport = transport.toLowerCase();
        return transport;
    }

    private String getEndpointPath(JMXServiceURL url) {
        String address = url.toString();
        return address.substring(SERVICE_JMX_SOAP.length());
    }

    public Object createServer(JMXServiceURL url, Map environment) throws IOException {
        String connectorID = this.findConnectorID(url);
        if (connectorID == null) {
            return null;
        }
        String mbeanServerId = this.findMBeanServerId(connectorID);
        if (mbeanServerId == null) {
            return null;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(mbeanServerId);
        if (servers.size() == 1) {
            return servers.get(0);
        }
        return null;
    }

    private String findConnectorID(JMXServiceURL url) {
        String path = url.getURLPath();
        if (path == null) {
            return null;
        }
        int index = path.indexOf(ID_CONTEXT);
        if (index < 0) {
            return null;
        }
        return path.substring(index + ID_CONTEXT.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findMBeanServerId(String connectorID) {
        Map map = this.mbeanServerIds;
        synchronized (map) {
            return (String)this.mbeanServerIds.get(connectorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMXServiceURL bindServer(Object server, JMXServiceURL url, Map environment) throws IOException {
        String existingID = this.findConnectorID(url);
        String connectorID = existingID;
        if (connectorID == null) {
            connectorID = this.generateConnectorID();
        }
        final MBeanServer mbeanServer = (MBeanServer)server;
        try {
            try {
                String mbeanServerId = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws JMException {
                        return mbeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
                    }
                });
                Map map = this.mbeanServerIds;
                synchronized (map) {
                    String existing = this.findMBeanServerId(connectorID);
                    if (existing != null && !existing.equals(mbeanServerId)) {
                        throw new IOException("SOAPConnectorServer with ID " + connectorID + " is already attached to MBeanServer with ID " + existing);
                    }
                    this.mbeanServerIds.put(connectorID, mbeanServerId);
                }
            }
            catch (PrivilegedActionException x) {
                throw (JMException)x.getException();
            }
        }
        catch (JMException x) {
            throw new IOException("Cannot retrieve MBeanServer ID " + x.toString());
        }
        this.deploy(url, environment);
        JMXServiceURL address = null;
        if (existingID != null) {
            address = url;
        } else {
            String path = url.getURLPath();
            if (path == null) {
                path = "";
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            address = new JMXServiceURL(url.getProtocol(), url.getHost(), url.getPort(), path + ID_CONTEXT + connectorID);
        }
        return address;
    }

    private void deploy(JMXServiceURL address, Map environment) throws IOException {
        String deployPath;
        String string = deployPath = environment == null ? null : (String)environment.get("jmx.remote.x.axis.deploy.url");
        if (deployPath == null || deployPath.length() == 0) {
            deployPath = "/axis/services/AdminService";
        }
        JMXServiceURL temp = new JMXServiceURL(address.getProtocol(), address.getHost(), address.getPort(), deployPath);
        String deployEndpoint = this.getEndpoint(temp, environment);
        try {
            AdminClient deployer = new AdminClient();
            Options options = new Options(null);
            options.setDefaultURL(deployEndpoint);
            InputStream wsdd = this.getClass().getResourceAsStream(SERVER_DEPLOY_WSDD);
            if (wsdd == null) {
                throw new IOException("Could not find AXIS deployment descriptor");
            }
            deployer.process(options, wsdd);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            Logger logger = SOAPResolver.getLogger();
            if (logger.isEnabledFor(20)) {
                logger.info("Exception while deploying AXIS service", x);
            }
            throw new IOException("Could not deploy SOAPConnectorServer to AXIS " + x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateConnectorID() {
        Class clazz = class$mx4j$tools$remote$resolver$soap$SOAPResolver == null ? (class$mx4j$tools$remote$resolver$soap$SOAPResolver = SOAPResolver.class$("mx4j.tools.remote.resolver.soap.SOAPResolver")) : class$mx4j$tools$remote$resolver$soap$SOAPResolver;
        synchronized (clazz) {
            return String.valueOf(++connectorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindServer(Object server, JMXServiceURL address, Map environment) throws IOException {
        String connectorID = this.findConnectorID(address);
        if (connectorID == null) {
            throw new IOException("Unknown SOAPConnectorServer ID: " + address);
        }
        Map map = this.mbeanServerIds;
        synchronized (map) {
            this.mbeanServerIds.remove(connectorID);
        }
        this.undeploy(address, environment);
    }

    private void undeploy(JMXServiceURL address, Map environment) throws IOException {
        String deployPath;
        String string = deployPath = environment == null ? null : (String)environment.get("jmx.remote.x.axis.deploy.url");
        if (deployPath == null || deployPath.length() == 0) {
            deployPath = "/axis/services/AdminService";
        }
        JMXServiceURL temp = new JMXServiceURL(address.getProtocol(), address.getHost(), address.getPort(), deployPath);
        String undeployEndpoint = this.getEndpoint(temp, environment);
        try {
            AdminClient deployer = new AdminClient();
            Options options = new Options(null);
            options.setDefaultURL(undeployEndpoint);
            InputStream wsdd = this.getClass().getResourceAsStream(SERVER_UNDEPLOY_WSDD);
            if (wsdd == null) {
                throw new IOException("Could not find AXIS deployment descriptor");
            }
            deployer.process(options, wsdd);
        }
        catch (Exception x) {
            Logger logger = SOAPResolver.getLogger();
            if (logger.isEnabledFor(20)) {
                logger.info("Exception while deploying AXIS service", x);
            }
            throw new IOException("Could not deploy SOAPConnectorServer to AXIS " + x.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

