/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.ftp.Ftp;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;

public class DataPort
extends Thread {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$ftp$DataPort == null ? (class$org$mortbay$ftp$DataPort = DataPort.class$("org.mortbay.ftp.DataPort")) : class$org$mortbay$ftp$DataPort));
    private static final int SOCKET_LISTEN_TIMEOUT = 120000;
    private int port = 0;
    private InetAddress addr = null;
    private ServerSocket listen = null;
    private Socket connection = null;
    private InputStream in = null;
    private OutputStream out = null;
    private Ftp ftp = null;
    private boolean terminated = false;
    static /* synthetic */ Class class$org$mortbay$ftp$DataPort;

    public static void main(String[] args) {
        DataPort dp = new DataPort(null, System.out);
        System.err.println(dp.getFtpPortCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataPort(Ftp ftp, InputStream in) {
        super("FtpDataIn");
        DataPort dataPort = this;
        synchronized (dataPort) {
            this.in = in;
            this.ftp = ftp;
            this.start();
            try {
                this.wait();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Listening on " + this.addr + " " + this.port));
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"Interrupted");
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataPort(Ftp ftp, OutputStream out) {
        super("FtpDataOut");
        DataPort dataPort = this;
        synchronized (dataPort) {
            this.out = out;
            this.ftp = ftp;
            this.start();
            try {
                this.wait();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Listening on " + this.addr + " " + this.port));
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"Interrupted");
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataPort(Ftp ftp, InputStream in, InetAddress addr, int port) {
        super("ActiveFtpDataIn");
        DataPort dataPort = this;
        synchronized (dataPort) {
            this.in = in;
            this.ftp = ftp;
            this.addr = addr;
            this.port = port;
            this.start();
            try {
                this.wait();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connected to " + addr + " " + port));
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"Interrupted");
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataPort(Ftp ftp, OutputStream out, InetAddress addr, int port) {
        super("ActiveFtpDataOut");
        DataPort dataPort = this;
        synchronized (dataPort) {
            this.out = out;
            this.ftp = ftp;
            this.addr = addr;
            this.port = port;
            this.start();
            try {
                this.wait();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connected to " + addr + " " + port));
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"Interrupted");
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.terminated = false;
        try {
            while (this.connection == null) {
                if (this.addr == null) {
                    this.listen();
                } else {
                    this.connect();
                }
                boolean bl = this.terminated = this.connection == null;
                if (!this.terminated) continue;
                return;
            }
            this.handle();
        }
        catch (Exception e) {
            if (this.ftp != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"DataPort failed", (Throwable)e);
                }
                this.ftp.transferCompleteNotification(e);
                this.ftp = null;
            }
        }
        finally {
            if (this.connection != null) {
                block22: {
                    try {
                        this.connection.close();
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block22;
                        log.debug((Object)"Close Exception", (Throwable)e);
                    }
                }
                this.connection = null;
            }
            if (this.ftp != null) {
                this.ftp.transferCompleteNotification(null);
            }
        }
    }

    public final void close() {
        log.debug((Object)"Close DataPort");
        this.terminated = true;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ioe) {
                LogSupport.ignore((Log)log, (Throwable)ioe);
            }
            this.connection = null;
        }
        if (this.listen != null) {
            try {
                this.listen.close();
            }
            catch (IOException ioe) {
                LogSupport.ignore((Log)log, (Throwable)ioe);
            }
            this.listen = null;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                LogSupport.ignore((Log)log, (Throwable)ioe);
            }
            this.in = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                LogSupport.ignore((Log)log, (Throwable)ioe);
            }
            this.out = null;
        }
        this.ftp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws IOException {
        this.listen = null;
        DataPort dataPort = this;
        synchronized (dataPort) {
            try {
                this.listen = new ServerSocket(0);
                this.port = this.listen.getLocalPort();
                this.addr = this.listen.getInetAddress();
                if (this.addr == null || this.addr.getAddress()[0] == 0) {
                    this.addr = this.ftp.getLocalAddress();
                }
                Object var3_2 = null;
                this.notify();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.notify();
                throw throwable;
            }
        }
        if (!this.terminated) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Waiting for connection... " + this.listen));
            }
            this.listen.setSoTimeout(120000);
            this.connection = this.listen.accept();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Accepted " + this.connection));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException {
        DataPort dataPort = this;
        synchronized (dataPort) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Making connection: " + this.addr + ":" + this.port + "..."));
                }
                this.connection = new Socket(this.addr, this.port);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connected " + this.connection));
                }
                Object var3_2 = null;
                this.notify();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.notify();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws IOException {
        if (this.out != null) {
            this.in = this.connection.getInputStream();
        } else {
            this.out = this.connection.getOutputStream();
        }
        try {
            IO.copy((InputStream)this.in, (OutputStream)this.out);
        }
        finally {
            block12: {
                if (this.out != null) {
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)"Exception ignored", (Throwable)e);
                    }
                }
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public int getListenPort() {
        return this.port;
    }

    public String getFtpPortCommand() {
        byte[] ip = this.addr.getAddress();
        String portCommand = "PORT " + (0xFF & ip[0]) + ',' + (0xFF & ip[1]) + ',' + (0xFF & ip[2]) + ',' + (0xFF & ip[3]) + ',' + this.port / 256 + "," + this.port % 256;
        return portCommand;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

