/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.ftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.ftp.CmdReply;
import org.mortbay.ftp.CmdReplyStream;
import org.mortbay.ftp.DataPort;
import org.mortbay.ftp.FtpException;
import org.mortbay.ftp.FtpReplyException;
import org.mortbay.util.LineInput;

public class Ftp {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$ftp$Ftp == null ? (class$org$mortbay$ftp$Ftp = Ftp.class$("org.mortbay.ftp.Ftp")) : class$org$mortbay$ftp$Ftp));
    public static final String anonymous = "anonymous";
    public static final int defaultPort = 21;
    public static final char ASCII = 'A';
    public static final char LOCAL = 'L';
    public static final char EBCDIC = 'E';
    public static final char IMAGE = 'I';
    public static final char BINARY = 'I';
    public static final char NON_PRINT = 'N';
    public static final char TELNET = 'T';
    public static final char CARRIAGE_CONTROL = 'C';
    Socket command = null;
    CmdReplyStream in = null;
    Writer out = null;
    DataPort transferDataPort = null;
    Exception transferException = null;
    static /* synthetic */ Class class$org$mortbay$ftp$Ftp;

    public Ftp() {
    }

    public Ftp(InetAddress hostAddr, String username, String password) throws FtpException, IOException {
        this(hostAddr, 21, username, password);
    }

    public Ftp(InetAddress hostAddr, int port, String username, String password) throws FtpException, IOException {
        this.open(hostAddr, port);
        this.authenticate(username, password);
    }

    public InetAddress getLocalAddress() {
        return this.command.getLocalAddress();
    }

    void cmd(String cmd) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command=" + cmd));
        }
        this.out.write(cmd);
        this.out.write("\r\n");
        this.out.flush();
    }

    public synchronized void open(InetAddress hostAddr) throws FtpException, IOException {
        this.open(hostAddr, 21);
    }

    public synchronized void open(InetAddress hostAddr, int port) throws FtpException, IOException {
        if (this.command != null) {
            throw new IllegalStateException("Ftp already opened");
        }
        if (port == 0) {
            port = 21;
        }
        this.command = new Socket(hostAddr, port);
        this.in = new CmdReplyStream(this.command.getInputStream());
        this.out = new OutputStreamWriter(this.command.getOutputStream(), "ISO8859_1");
        this.in.waitForCompleteOK();
        log.debug((Object)"Command Port Opened");
    }

    public synchronized void authenticate(String username, String password) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("USER " + username);
        CmdReply reply = this.in.readReply();
        if (reply.intermediate()) {
            log.debug((Object)"Sending password");
            this.cmd("PASS " + password);
        } else if (reply.positive()) {
            log.debug((Object)"No password required");
        } else {
            throw new FtpReplyException(reply);
        }
        this.in.waitForCompleteOK();
        log.debug((Object)"Authenticated");
    }

    public synchronized void setType(char type) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("TYPE " + type);
        this.in.waitForCompleteOK();
    }

    public synchronized void setType(char type, char param) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("TYPE " + type + ' ' + param);
        this.in.waitForCompleteOK();
    }

    public synchronized void setType(int length) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("TYPE L " + length);
        this.in.waitForCompleteOK();
    }

    public synchronized boolean transferComplete() throws FtpException, IOException {
        if (this.transferException != null) {
            if (this.transferException instanceof FtpException) {
                throw (FtpException)this.transferException;
            }
            if (this.transferException instanceof IOException) {
                throw (IOException)this.transferException;
            }
            log.fatal((Object)"Bad exception type", (Throwable)this.transferException);
            System.exit(1);
        }
        return this.transferDataPort == null;
    }

    public synchronized void waitUntilTransferComplete() throws FtpException, IOException {
        while (this.transferDataPort != null) {
            log.debug((Object)"waitUntilTransferComplete...");
            try {
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.transferException != null) {
            if (this.transferException instanceof FtpException) {
                throw (FtpException)this.transferException;
            }
            if (this.transferException instanceof IOException) {
                throw (IOException)this.transferException;
            }
            log.fatal((Object)"Bad exception type", (Throwable)this.transferException);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void transferCompleteNotification(Exception dataPortException) {
        log.debug((Object)"Transfer Complete");
        this.transferException = dataPortException;
        try {
            block5: {
                try {
                    if (this.in == null) break block5;
                    this.in.waitForCompleteOK();
                }
                catch (Exception e) {
                    if (this.transferException == null) {
                        this.transferException = e;
                    }
                    Object var4_3 = null;
                    this.transferDataPort = null;
                    this.notifyAll();
                    this.transferCompleteNotification();
                }
            }
            Object var4_2 = null;
            this.transferDataPort = null;
            this.notifyAll();
            this.transferCompleteNotification();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.transferDataPort = null;
            this.notifyAll();
            this.transferCompleteNotification();
            throw throwable;
        }
    }

    protected void transferCompleteNotification() {
    }

    public synchronized void startGet(String remoteName, String localName) throws FtpException, IOException {
        FileOutputStream file = new FileOutputStream(localName);
        this.startGet(remoteName, file);
    }

    public synchronized InputStream startGet(String remoteName) throws FtpException, IOException {
        PipedOutputStream pout = new PipedOutputStream();
        PipedInputStream pin = new PipedInputStream(pout);
        this.startGet(remoteName, pout);
        return pin;
    }

    public synchronized void startGet(String remoteName, OutputStream destination) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.transferException = null;
        this.transferDataPort = new DataPort(this, destination);
        try {
            this.cmd(this.transferDataPort.getFtpPortCommand());
            this.in.waitForCompleteOK();
            this.cmd("RETR " + remoteName);
            this.in.waitForPreliminaryOK();
        }
        catch (FtpException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
        catch (IOException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
    }

    public synchronized void startPut(String localName, String remoteName) throws FtpException, IOException {
        FileInputStream file = new FileInputStream(localName);
        this.startPut(file, remoteName);
    }

    public synchronized OutputStream startPut(String remoteName) throws FtpException, IOException {
        PipedOutputStream pout = new PipedOutputStream();
        PipedInputStream pin = new PipedInputStream(pout);
        this.startPut(pin, remoteName);
        return pout;
    }

    public synchronized void startPut(InputStream source, String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.transferException = null;
        this.transferDataPort = new DataPort(this, source);
        try {
            this.cmd(this.transferDataPort.getFtpPortCommand());
            this.in.waitForCompleteOK();
            this.cmd("STOR " + remoteName);
            this.in.waitForPreliminaryOK();
        }
        catch (FtpException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
        catch (IOException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
    }

    public synchronized void startPasvGet(String remoteName, String localName) throws FtpException, IOException {
        FileOutputStream file = new FileOutputStream(localName);
        this.startPasvGet(remoteName, file);
    }

    public synchronized void startPasvGet(String remoteName, OutputStream destination) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.transferException = null;
        this.cmd("PASV");
        CmdReply reply = this.in.waitForCompleteOK();
        String pasv = reply.text.substring(reply.text.lastIndexOf("(") + 1, reply.text.lastIndexOf(")"));
        int i1 = pasv.indexOf(",");
        i1 = pasv.indexOf(",", i1 + 1);
        i1 = pasv.indexOf(",", i1 + 1);
        i1 = pasv.indexOf(",", i1 + 1);
        int i2 = pasv.indexOf(",", i1 + 1);
        int dataPort = 256 * Integer.parseInt(pasv.substring(i1 + 1, i2)) + Integer.parseInt(pasv.substring(i2 + 1));
        this.cmd("RETR " + remoteName);
        this.transferDataPort = new DataPort(this, destination, this.command.getInetAddress(), dataPort);
        this.in.waitForPreliminaryOK();
    }

    public synchronized void startPasvPut(String localName, String remoteName) throws FtpException, IOException {
        FileInputStream file = new FileInputStream(localName);
        this.startPasvPut(file, remoteName);
    }

    public synchronized void startPasvPut(InputStream source, String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.transferException = null;
        this.cmd("PASV");
        CmdReply reply = this.in.waitForCompleteOK();
        String pasv = reply.text.substring(reply.text.lastIndexOf("(") + 1, reply.text.lastIndexOf(")"));
        int i1 = pasv.indexOf(",");
        i1 = pasv.indexOf(",", i1 + 1);
        i1 = pasv.indexOf(",", i1 + 1);
        i1 = pasv.indexOf(",", i1 + 1);
        int i2 = pasv.indexOf(",", i1 + 1);
        int dataPort = 256 * Integer.parseInt(pasv.substring(i1 + 1, i2)) + Integer.parseInt(pasv.substring(i2 + 1));
        this.cmd("STOR " + remoteName);
        this.transferDataPort = new DataPort(this, source, this.command.getInetAddress(), dataPort);
        this.in.waitForPreliminaryOK();
    }

    public synchronized void mkdir(String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("MKD " + remoteName);
        this.in.waitForCompleteOK();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + remoteName));
        }
    }

    public synchronized void sendFile(String srcName, InetAddress destAddr, int destPort, String username, String password, String destName) throws FtpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("startSend(" + srcName + ',' + destAddr + ',' + destPort + ',' + username + ',' + password + ',' + destName + ')'));
        }
        this.waitUntilTransferComplete();
        Ftp destFtp = new Ftp(destAddr, destPort, username, password);
        destFtp.cmd("PASV");
        CmdReply reply = destFtp.in.waitForCompleteOK();
        String portCommand = "PORT " + reply.text.substring(reply.text.lastIndexOf("(") + 1, reply.text.lastIndexOf(")"));
        log.debug((Object)portCommand);
        this.cmd(portCommand);
        this.in.waitForCompleteOK();
        destFtp.cmd("STOR " + destName);
        this.cmd("RETR " + srcName);
        this.in.waitForCompleteOK();
        destFtp.in.waitForCompleteOK();
    }

    public synchronized String workingDirectory() throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("PWD");
        CmdReply reply = this.in.waitForCompleteOK();
        if (log.isDebugEnabled()) {
            log.debug((Object)("PWD=" + reply.text));
        }
        return reply.text;
    }

    public synchronized void workingDirectory(String dir) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("CWD " + dir);
        CmdReply reply = this.in.waitForCompleteOK();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CWD=" + reply.text));
        }
    }

    public synchronized void rename(String oldName, String newName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("RNFR " + oldName);
        this.in.waitForIntermediateOK();
        this.cmd("RNTO " + newName);
        this.in.waitForCompleteOK();
        log.debug((Object)"Renamed");
    }

    public synchronized void delete(String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("DELE " + remoteName);
        this.in.waitForCompleteOK();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + remoteName));
        }
    }

    public synchronized void abort() throws FtpException, IOException {
        this.cmd("ABOR");
        if (this.transferDataPort == null) {
            this.in.waitForCompleteOK();
        } else {
            this.waitUntilTransferComplete();
        }
    }

    public synchronized Vector list() throws FtpException, IOException {
        String file;
        log.debug((Object)"list");
        this.waitUntilTransferComplete();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.transferException = null;
        this.transferDataPort = new DataPort(this, bout);
        try {
            this.cmd(this.transferDataPort.getFtpPortCommand());
            this.in.waitForCompleteOK();
            this.cmd("NLST");
            this.in.waitForPreliminaryOK();
            this.waitUntilTransferComplete();
        }
        catch (FtpReplyException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            if ("550".equals(e.reply.code)) {
                return null;
            }
            throw e;
        }
        catch (FtpException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
        catch (IOException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
        LineInput in = new LineInput((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        Vector<void> listVector = new Vector<void>();
        while ((file = in.readLine()) != null) {
            listVector.addElement(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got list " + listVector.toString()));
        }
        return listVector;
    }

    public synchronized String status() throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("STAT");
        CmdReply reply = this.in.waitForCompleteOK();
        if (log.isDebugEnabled()) {
            log.debug((Object)("STAT=" + reply.text));
        }
        return reply.text;
    }

    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.cmd("QUIT");
            if (this.command != null) {
                this.command.close();
                this.command = null;
                this.in = null;
                this.out = null;
                if (this.transferDataPort != null) {
                    this.transferDataPort.close();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getUrl(String url, OutputStream out) throws FtpException, IOException {
        if (!url.startsWith("ftp://")) {
            throw new IllegalArgumentException("url must be for the form: ftp://username:password@host:port/path/to/file");
        }
        uri = url.substring(6);
        if (uri.indexOf("?") >= 0) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        tok = new StringTokenizer(uri, ":@/", true);
        user = "anonymous";
        pass = "org.mortbay.ftp@" + InetAddress.getLocalHost().getHostName();
        host = null;
        port = null;
        path = null;
        s = new String[3];
        i = 0;
        block7: while (tok.hasMoreTokens()) {
            t = tok.nextToken();
            if (t.length() != 1) ** GOTO lbl-1000
            switch (t.charAt(0)) {
                case ':': {
                    break;
                }
                case '@': {
                    user = s[0];
                    pass = s[1];
                    i = 0;
                    s[0] = null;
                    s[1] = null;
                    break;
                }
                case '/': {
                    host = s[0];
                    if (i == 2) {
                        port = s[1];
                    }
                    try {
                        path = tok.nextToken(" \n\t");
                    }
                    catch (NoSuchElementException e) {
                        path = "/";
                    }
                    break block7;
                }
                default: lbl-1000:
                // 2 sources

                {
                    s[i++] = t;
                }
            }
        }
        if (Ftp.log.isDebugEnabled()) {
            Ftp.log.debug((Object)("getUrl=ftp://" + user + (pass == null ? "" : ":" + pass) + "@" + host + (port == null ? "" : ":" + port) + (path.startsWith("/") != false ? path : "/" + path)));
        }
        this.close();
        if (port != null) {
            this.open(InetAddress.getByName(host), Integer.parseInt(port));
        } else {
            this.open(InetAddress.getByName(host));
        }
        this.authenticate(user, pass);
        this.startGet(path, out);
        this.waitUntilTransferComplete();
    }

    public synchronized void rmdir(String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("RMD " + remoteName);
        this.in.waitForCompleteOK();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + remoteName));
        }
    }

    public synchronized String getLastModifiedTime(String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("MDTM " + remoteName);
        CmdReply reply = this.in.waitForCompleteOK();
        return reply.text;
    }

    public synchronized String getSize(String remoteName) throws FtpException, IOException {
        this.waitUntilTransferComplete();
        this.cmd("SIZE " + remoteName);
        CmdReply reply = this.in.waitForCompleteOK();
        return reply.text;
    }

    public synchronized Vector list(String mask) throws FtpException, IOException {
        String file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("list [" + mask + "]"));
        }
        this.waitUntilTransferComplete();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.transferException = null;
        this.transferDataPort = new DataPort(this, bout);
        try {
            this.cmd(this.transferDataPort.getFtpPortCommand());
            this.in.waitForCompleteOK();
            if (mask == null) {
                this.cmd("LIST");
            } else {
                this.cmd("LIST " + mask);
            }
            this.in.waitForPreliminaryOK();
            this.waitUntilTransferComplete();
        }
        catch (FtpReplyException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            if ("550".equals(e.reply.code)) {
                return null;
            }
            throw e;
        }
        catch (FtpException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
        catch (IOException e) {
            this.transferDataPort.close();
            this.transferDataPort = null;
            throw e;
        }
        LineInput in = new LineInput((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        Vector<void> listVector = new Vector<void>();
        while ((file = in.readLine()) != null) {
            listVector.addElement(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got list " + listVector.toString()));
        }
        return listVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        try {
            try {
                if (!(args.length == 1 || args.length >= 3 && (args.length < 4 || args[3].equals("del") || args[3].equals("ren") || args[3].equals("get") || args[3].equals("pget") || args[3].equals("snd") || args[3].equals("put") || args[3].equals("pput") || args[3].equals("mkdir") || args[3].equals("url")))) {
                    System.err.println("Usage: java org.mortbay.ftp.Ftp host user password [ del|[p]get|[p]put|ren|snd|mkdir args... ]");
                    System.err.println("       java org.mortbay.ftp.Ftp ftp://user:pass@host:port/file/path");
                    System.exit(1);
                }
                if (args.length == 1) {
                    Ftp ftp = new Ftp();
                    ftp.getUrl(args[0], System.out);
                }
                Ftp ftp = new Ftp(InetAddress.getByName(args[0]), args[1], args[2]);
                if (args.length == 3) {
                    System.out.println(ftp.list());
                }
                int file = 4;
                while (file < args.length) {
                    block34: {
                        System.out.println(args[3] + " " + args[file]);
                        try {
                            if (args[3].equals("del")) {
                                ftp.delete(args[file]);
                            } else if (args[3].equals("ren")) {
                                ftp.rename(args[file], args[++file]);
                            } else if (args[3].equals("get")) {
                                if (file + 1 == args.length) {
                                    ftp.startGet(args[file], System.out);
                                } else {
                                    ftp.startGet(args[file], args[++file]);
                                }
                            } else if (args[3].equals("pget")) {
                                if (file + 1 == args.length) {
                                    ftp.startPasvGet(args[file], System.out);
                                } else {
                                    ftp.startPasvGet(args[file], args[++file]);
                                }
                            } else if (args[3].equals("put")) {
                                ftp.startPasvPut(args[file], args[++file]);
                            } else if (args[3].equals("pput")) {
                                ftp.startPut(args[file], args[++file]);
                            } else if (args[3].equals("snd")) {
                                ftp.sendFile(args[file], InetAddress.getByName(args[++file]), 0, args[1], args[2], args[++file]);
                            } else if (args[3].equals("url")) {
                                ftp.getUrl(args[++file], System.err);
                            } else if (args[3].startsWith("mkd")) {
                                ftp.mkdir(args[file]);
                            }
                            ftp.waitUntilTransferComplete();
                        }
                        catch (Exception e) {
                            System.err.println(e.toString());
                            if (!log.isDebugEnabled()) break block34;
                            log.debug((Object)(args[3] + " failed"), (Throwable)e);
                        }
                    }
                    ++file;
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ftp failed", (Throwable)e);
                }
                Object var5_7 = null;
                log.debug((Object)"Exit main thread");
                return;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            log.debug((Object)"Exit main thread");
            throw throwable;
        }
        log.debug((Object)"Exit main thread");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

