/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Replace
extends MatchingTask {
    private File src;
    private NestedString token;
    private NestedString value;
    private File propertyFile;
    private File replaceFilterFile;
    private Properties properties;
    private Vector replacefilters;
    private File dir;
    private int fileCount;
    private int replaceCount;
    private boolean summary;
    private String encoding;
    private FileUtils fileUtils;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Vector vector = (Vector)this.replacefilters.clone();
        Properties properties = this.properties == null ? null : (Properties)this.properties.clone();
        try {
            Object object;
            String[] stringArray;
            Object object2;
            if (this.replaceFilterFile != null) {
                object2 = this.getProperties(this.replaceFilterFile);
                stringArray = ((Properties)object2).keys();
                while (stringArray.hasMoreElements()) {
                    String string = stringArray.nextElement().toString();
                    object = this.createReplacefilter();
                    ((Replacefilter)object).setToken(string);
                    ((Replacefilter)object).setValue(((Properties)object2).getProperty(string));
                }
            }
            this.validateAttributes();
            if (this.propertyFile != null) {
                this.properties = this.getProperties(this.propertyFile);
            }
            this.validateReplacefilters();
            this.fileCount = 0;
            this.replaceCount = 0;
            if (this.src != null) {
                this.processFile(this.src);
            }
            if (this.dir != null) {
                object2 = super.getDirectoryScanner(this.dir);
                stringArray = ((DirectoryScanner)object2).getIncludedFiles();
                int n = 0;
                while (n < stringArray.length) {
                    object = new File(this.dir, stringArray[n]);
                    this.processFile((File)object);
                    ++n;
                }
            }
            if (this.summary) {
                this.log("Replaced " + this.replaceCount + " occurrences in " + this.fileCount + " files.", 2);
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.replacefilters = vector;
            this.properties = properties;
            throw throwable;
        }
        {
            Object var4_10 = null;
            this.replacefilters = vector;
            this.properties = properties;
            return;
        }
    }

    public void validateAttributes() throws BuildException {
        if (this.src == null && this.dir == null) {
            String string = "Either the file or the dir attribute must be specified";
            throw new BuildException(string, this.getLocation());
        }
        if (this.propertyFile != null && !this.propertyFile.exists()) {
            String string = "Property file " + this.propertyFile.getPath() + " does not exist.";
            throw new BuildException(string, this.getLocation());
        }
        if (this.token == null && this.replacefilters.size() == 0) {
            String string = "Either token or a nested replacefilter must be specified";
            throw new BuildException(string, this.getLocation());
        }
        if (this.token != null && "".equals(this.token.getText())) {
            String string = "The token attribute must not be an empty string.";
            throw new BuildException(string, this.getLocation());
        }
    }

    public void validateReplacefilters() throws BuildException {
        int n = 0;
        while (n < this.replacefilters.size()) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(n);
            replacefilter.validate();
            ++n;
        }
    }

    public Properties getProperties(File file) throws BuildException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "Property file (" + file.getPath() + ") not found.";
            throw new BuildException(string);
        }
        catch (IOException iOException) {
            String string = "Property file (" + file.getPath() + ") cannot be loaded.";
            throw new BuildException(string);
        }
        return properties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processFile(File file) throws BuildException {
        Writer writer;
        File file2;
        block22: {
            if (!file.exists()) {
                throw new BuildException("Replace: source file " + file.getPath() + " doesn't exist", this.getLocation());
            }
            file2 = this.fileUtils.createTempFile("rep", ".tmp", this.fileUtils.getParentFile(file));
            file2.deleteOnExit();
            InputStreamReader inputStreamReader = null;
            writer = null;
            try {
                try {
                    boolean bl;
                    inputStreamReader = this.encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
                    writer = this.encoding == null ? new FileWriter(file2) : new OutputStreamWriter((OutputStream)new FileOutputStream(file2), this.encoding);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    BufferedWriter bufferedWriter = new BufferedWriter(writer);
                    String string = FileUtils.readFully(bufferedReader);
                    if (string == null) {
                        string = "";
                    }
                    String string2 = new String(string);
                    if (this.token != null) {
                        String string3 = this.stringReplace(this.value.getText(), "\r\n", "\n", false);
                        string3 = this.stringReplace(string3, "\n", StringUtils.LINE_SEP, false);
                        String string4 = this.stringReplace(this.token.getText(), "\r\n", "\n", false);
                        string4 = this.stringReplace(string4, "\n", StringUtils.LINE_SEP, false);
                        this.log("Replacing in " + file.getPath() + ": " + this.token.getText() + " --> " + this.value.getText(), 3);
                        string2 = this.stringReplace(string2, string4, string3, true);
                    }
                    if (this.replacefilters.size() > 0) {
                        string2 = this.processReplacefilters(string2, file.getPath());
                    }
                    if (bl = string2.equals(string) ^ true) {
                        bufferedWriter.write(string2, 0, string2.length());
                        bufferedWriter.flush();
                    }
                    bufferedWriter.close();
                    writer = null;
                    bufferedReader.close();
                    inputStreamReader = null;
                    if (bl) {
                        ++this.fileCount;
                        this.fileUtils.rename(file2, file);
                        file2 = null;
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("IOException in " + file + " - " + iOException.getClass().getName() + ':' + iOException.getMessage(), iOException, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                if (inputStreamReader != null) {
                    try {
                        ((Reader)inputStreamReader).close();
                    }
                    catch (IOException iOException) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                if (file2 == null) throw throwable;
                file2.delete();
                throw throwable;
            }
            {
                Object var6_15 = null;
                if (inputStreamReader == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            ((Reader)inputStreamReader).close();
        }
        if (writer != null) {
            try {}
            catch (IOException iOException) {}
            writer.close();
        }
        if (file2 == null) return;
        file2.delete();
    }

    private final String processReplacefilters(String string, String string2) {
        String string3 = new String(string);
        int n = 0;
        while (n < this.replacefilters.size()) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(n);
            this.log("Replacing in " + string2 + ": " + replacefilter.getToken() + " --> " + replacefilter.getReplaceValue(), 3);
            string3 = this.stringReplace(string3, replacefilter.getToken(), replacefilter.getReplaceValue(), true);
            ++n;
        }
        return string3;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setSummary(boolean bl) {
        this.summary = bl;
    }

    public void setReplaceFilterFile(File file) {
        this.replaceFilterFile = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setToken(String string) {
        this.createReplaceToken().addText(string);
    }

    public void setValue(String string) {
        this.createReplaceValue().addText(string);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            this.token = new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    public void setPropertyFile(File file) {
        this.propertyFile = file;
    }

    public Replacefilter createReplacefilter() {
        Replacefilter replacefilter = new Replacefilter();
        this.replacefilters.addElement(replacefilter);
        return replacefilter;
    }

    private final String stringReplace(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
            if (!bl) continue;
            ++this.replaceCount;
        }
        if (string.length() > n) {
            stringBuffer.append(string.substring(n, string.length()));
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.src = null;
        this.token = null;
        this.value = new NestedString();
        this.propertyFile = null;
        this.replaceFilterFile = null;
        this.properties = null;
        this.replacefilters = new Vector();
        this.dir = null;
        this.summary = false;
        this.encoding = null;
        this.fileUtils = FileUtils.newFileUtils();
    }

    public Replace() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Replacefilter {
        private String token;
        private String value;
        private String property;

        public void validate() throws BuildException {
            if (this.token == null) {
                String string = "token is a mandatory attribute of replacefilter.";
                throw new BuildException(string);
            }
            if ("".equals(this.token)) {
                String string = "The token attribute must not be an empty string.";
                throw new BuildException(string);
            }
            if (this.value != null && this.property != null) {
                String string = "Either value or property can be specified, but a replacefilter element cannot have both.";
                throw new BuildException(string);
            }
            if (this.property != null) {
                if (Replace.this.propertyFile == null) {
                    String string = "The replacefilter's property attribute can only be used with the replacetask's propertyFile attribute.";
                    throw new BuildException(string);
                }
                if (Replace.this.properties == null || Replace.this.properties.getProperty(this.property) == null) {
                    String string = "property \"" + this.property + "\" was not found in " + Replace.this.propertyFile.getPath();
                    throw new BuildException(string);
                }
            }
        }

        public String getReplaceValue() {
            if (this.property != null) {
                return Replace.this.properties.getProperty(this.property);
            }
            if (this.value != null) {
                return this.value;
            }
            if (Replace.this.value != null) {
                return Replace.this.value.getText();
            }
            return new String("");
        }

        public void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public String getProperty() {
            return this.property;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NestedString {
        private StringBuffer buf;

        public void addText(String string) {
            this.buf.append(string);
        }

        public String getText() {
            return this.buf.substring(0);
        }

        private final /* synthetic */ void this() {
            this.buf = new StringBuffer();
        }

        public NestedString() {
            this.this();
        }
    }
}

