/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.plus.AbstractService;
import org.mortbay.jndi.Util;

public abstract class AbstractDataSourceService
extends AbstractService {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$plus$AbstractDataSourceService == null ? (class$org$mortbay$jetty$plus$AbstractDataSourceService = AbstractDataSourceService.class$("org.mortbay.jetty.plus.AbstractDataSourceService")) : class$org$mortbay$jetty$plus$AbstractDataSourceService));
    protected Map dsMap = new HashMap();
    static /* synthetic */ Class class$org$mortbay$jetty$plus$AbstractDataSourceService;
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$org$mortbay$jetty$plus$AbstractDataSourceService$DataSourceObjectFactory;

    public AbstractDataSourceService() {
        DataSourceObjectFactory.setDataSourceMap(new DataSourceMap(){

            public DataSource getDataSource(String name) {
                return AbstractDataSourceService.this.getDataSource(name);
            }
        });
    }

    public DataSource addConnectionPoolDataSource(String jndiName, ConnectionPoolDataSource cpds) throws Exception {
        DataSource ds = this.createPooledDataSource(jndiName, cpds);
        this.addDataSource(jndiName, ds);
        return ds;
    }

    public abstract DataSource createPooledDataSource(String var1, ConnectionPoolDataSource var2) throws Exception;

    public void addDataSource(String jndiName, DataSource ds) throws Exception {
        this.dsMap.put(jndiName, ds);
    }

    public DataSource getDataSource(String jndiName) {
        return (DataSource)this.dsMap.get(jndiName);
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            log.info((Object)("Starting Service " + this.getName()));
            InitialContext ictx = null;
            Object ctx = null;
            try {
                ictx = new InitialContext();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("InitialContext instanceof " + ictx.getClass().getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("java.naming.factory.initial=" + System.getProperty("java.naming.factory.initial")));
                }
            }
            catch (NamingException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                throw new IOException("No initial context: " + e);
            }
            Iterator dsItor = this.dsMap.entrySet().iterator();
            while (dsItor.hasNext()) {
                Map.Entry entry = dsItor.next();
                String dsName = (String)entry.getKey();
                DataSource ds = (DataSource)entry.getValue();
                Reference ref = this.getDataSourceReference(dsName, ds);
                try {
                    Util.bind(ictx, dsName, ref);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("DataSource ref bound in JNDI with name " + dsName));
                }
                catch (NamingException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("DataSource ref rebind failed :" + e.getExplanation()));
                    }
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                    throw e;
                }
            }
            super.start();
            log.info((Object)("Service " + this.getName() + " running."));
        } else {
            log.info((Object)("Service " + this.getName() + " is already running"));
        }
    }

    protected Reference getDataSourceReference(String jndiName, DataSource ds) {
        return new Reference((class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = AbstractDataSourceService.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).getName(), new StringRefAddr("name", jndiName), (class$org$mortbay$jetty$plus$AbstractDataSourceService$DataSourceObjectFactory == null ? (class$org$mortbay$jetty$plus$AbstractDataSourceService$DataSourceObjectFactory = AbstractDataSourceService.class$("org.mortbay.jetty.plus.AbstractDataSourceService$DataSourceObjectFactory")) : class$org$mortbay$jetty$plus$AbstractDataSourceService$DataSourceObjectFactory).getName(), null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DataSourceObjectFactory
    implements ObjectFactory {
        private static DataSourceMap mapper = null;

        public static void setDataSourceMap(DataSourceMap dsm) {
            mapper = dsm;
        }

        public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
            Reference ref;
            RefAddr addr;
            if (obj instanceof Reference && (addr = (ref = (Reference)obj).get("name")) != null && mapper != null) {
                return mapper.getDataSource((String)addr.getContent());
            }
            return null;
        }
    }

    public static interface DataSourceMap {
        public DataSource getDataSource(String var1);
    }
}

