/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import junit.textui.TestRunner;
import org.objectweb.howl.log.LogTest;
import org.objectweb.howl.log.LogTestWorker;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.TestDriver;

public class ExceptionTest
extends TestDriver {
    public ExceptionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.log = new Logger(this.cfg);
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Class)LogTest.class);
    }

    public void testIOException() throws Exception {
        String defDir = this.cfg.getLogFileDir();
        String logDir = this.prop.getProperty("test.ioexception.dir", defDir);
        this.cfg.setLogFileDir(logDir);
        this.log.open();
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.count", "100");
        System.err.println("Begin " + this.getName() + "\n  remove " + logDir + " to generate IOException");
        try {
            this.runWorkers(LogTestWorker.class);
            ExceptionTest.fail((String)"Expected an IOException");
        }
        catch (TestDriver.TestException e) {
            Throwable cause = e.getCause();
            ExceptionTest.assertTrue((boolean)(cause instanceof IOException));
        }
        System.err.println("End " + this.getName());
    }

    public void testVerifyMode_rw() throws Exception {
    }
}

