/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.objectweb.carol.cmi.ClusterRegistry;
import org.objectweb.carol.cmi.ClusterRegistryClient;
import org.objectweb.carol.cmi.ClusterRegistryInternal;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.LowerOrb;
import org.objectweb.carol.cmi.NamingContext;
import org.objectweb.carol.cmi.NamingContextHostPort;

public final class Naming {
    private Naming() {
    }

    private static ClusterRegistryInternal getRegistry(String host, int port) throws RemoteException {
        ClusterRegistryInternal r = (ClusterRegistryInternal)LowerOrb.getRegistryStub("org.objectweb.carol.cmi.ClusterRegistryImpl", host, port);
        return r;
    }

    public static ClusterRegistry getRegistry(NamingContextHostPort[] hp) throws RemoteException {
        int n = hp.length;
        if (n == 0) {
            return null;
        }
        ClusterRegistryInternal r = Naming.getRegistry(hp[0].host, hp[0].port);
        if (n == 1) {
            return new ClusterRegistryClient(r);
        }
        ClusterStubData csd = new ClusterStubData(r);
        int i = 1;
        while (i < n) {
            csd.setStub(Naming.getRegistry(hp[i].host, hp[i].port));
            ++i;
        }
        return new ClusterRegistryClient((ClusterRegistryInternal)((Object)csd.getClusterStub()));
    }

    public static ClusterRegistry getLocalRegistry(NamingContextHostPort[] hp) throws MalformedURLException, RemoteException {
        if (hp.length > 1) {
            throw new MalformedURLException("Can not bind or unbind in multiple machines");
        }
        ClusterRegistry creg = Naming.getRegistry(hp);
        return creg;
    }

    public static Object lookup(String name) throws MalformedURLException, NotBoundException, RemoteException {
        NamingContext nc = new NamingContext(name);
        ClusterRegistry reg = Naming.getRegistry(nc.hp);
        if (nc.name.length() == 0) {
            return reg;
        }
        return reg.lookup(nc.name);
    }

    public static void bind(String name, Remote obj) throws MalformedURLException, AlreadyBoundException, RemoteException {
        NamingContext nc = new NamingContext(name);
        ClusterRegistry reg = Naming.getLocalRegistry(nc.hp);
        if (obj == null) {
            throw new NullPointerException("cannot bind null object");
        }
        reg.bind(nc.name, obj);
    }

    public static void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        NamingContext nc = new NamingContext(name);
        ClusterRegistry reg = Naming.getLocalRegistry(nc.hp);
        if (obj == null) {
            throw new NullPointerException("cannot bind null object");
        }
        reg.rebind(nc.name, obj);
    }

    public static void unbind(String name) throws MalformedURLException, NotBoundException, RemoteException {
        NamingContext nc = new NamingContext(name);
        ClusterRegistry reg = Naming.getLocalRegistry(nc.hp);
        reg.unbind(nc.name);
    }

    public static String[] list(String name) throws MalformedURLException, RemoteException {
        NamingContext nc = new NamingContext(name);
        ClusterRegistry reg = Naming.getRegistry(nc.hp);
        String prefix = nc.scheme.equals("") ? "" : nc.scheme + ":";
        prefix = prefix + "//";
        int i = 0;
        while (i < nc.hp.length) {
            prefix = prefix + nc.hp[i].host;
            if (nc.hp[i].port != 1099) {
                prefix = prefix + ":" + nc.hp[i].port;
            }
            if (++i >= nc.hp.length) continue;
            prefix = prefix + ",";
        }
        prefix = prefix + "/";
        String[] lst = reg.list();
        i = 0;
        while (i < lst.length) {
            lst[i] = prefix + lst[i];
            ++i;
        }
        return lst;
    }
}

