/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.objectweb.carol.cmi.ClusterRegistryInternal;
import org.objectweb.carol.cmi.ClusterStub;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.StubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.StubLBFilter;

public class ClusterRegistryImpl_Cluster
implements ClusterStub,
ClusterRegistryInternal {
    private ClusterStubData csd;
    private StubLB lb;

    public ClusterRegistryImpl_Cluster(ClusterStubData csd) throws RemoteException {
        this.csd = csd;
        this.lb = csd.getRandom();
    }

    private void setLB() {
        if (this.lb == null) {
            this.lb = this.csd.getRandom();
        }
    }

    public String[] list() throws RemoteException {
        this.setLB();
        StubData sd = this.lb.get();
        ClusterRegistryInternal stub = (ClusterRegistryInternal)sd.getStub();
        StubLBFilter filter = null;
        while (true) {
            try {
                String[] result = stub.list();
                return result;
            }
            catch (RemoteException e) {
                if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) {
                    throw e;
                }
                if (this.csd.isStubDebug()) {
                    this.csd.debug("Connection to registry refused, retry");
                }
                if (filter == null) {
                    filter = new StubLBFilter();
                }
                filter.add(sd);
                sd = this.lb.get(filter);
                stub = (ClusterRegistryInternal)sd.getStub();
                continue;
            }
            break;
        }
    }

    public void test() throws RemoteException {
        this.setLB();
        StubData sd = this.lb.get();
        ClusterRegistryInternal stub = (ClusterRegistryInternal)sd.getStub();
        StubLBFilter filter = null;
        while (true) {
            try {
                stub.test();
                continue;
            }
            catch (RemoteException e) {
                if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) {
                    throw e;
                }
                if (this.csd.isStubDebug()) {
                    this.csd.debug("Connection to registry refused, retry");
                }
                if (filter == null) {
                    filter = new StubLBFilter();
                }
                filter.add(sd);
                sd = this.lb.get(filter);
                stub = (ClusterRegistryInternal)sd.getStub();
                continue;
            }
            break;
        }
    }

    public Object lookup(String name) throws NotBoundException, RemoteException {
        this.setLB();
        StubData sd = this.lb.get();
        ClusterRegistryInternal stub = (ClusterRegistryInternal)sd.getStub();
        StubLBFilter filter = null;
        while (true) {
            try {
                return stub.lookup(name);
            }
            catch (RemoteException e) {
                if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) {
                    throw e;
                }
                if (this.csd.isStubDebug()) {
                    this.csd.debug("Connection to registry refused, retry");
                }
                if (filter == null) {
                    filter = new StubLBFilter();
                }
                filter.add(sd);
                sd = this.lb.get(filter);
                stub = (ClusterRegistryInternal)sd.getStub();
                continue;
            }
            break;
        }
    }

    public void bindSingle(String name, Remote obj) throws AlreadyBoundException, RemoteException {
        throw new RemoteException("Can't bind into multiple servers");
    }

    public void rebindSingle(String name, Remote obj) throws RemoteException {
        throw new RemoteException("Can't rebind into multiple servers");
    }

    public void bindCluster(String name, byte[] obj) throws AlreadyBoundException, RemoteException {
        this.csd.getLocal();
        throw new RemoteException("Can't bind into multiple servers");
    }

    public void rebindCluster(String name, byte[] obj) throws RemoteException {
        this.csd.getLocal();
        throw new RemoteException("Can't rebind into multiple servers");
    }

    public void unbind(String name) throws NotBoundException, RemoteException {
        this.csd.getLocal();
        throw new RemoteException("Can't unbind from multiple servers");
    }
}

